/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.fox;

import com.tridium.crypto.core.bundle.CryptographicAlgorithmBundle;
import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.NCertificateParameters;
import com.tridium.crypto.core.cert.NHostExemption;
import com.tridium.crypto.core.cert.NKey;
import com.tridium.crypto.core.cert.NKeyPairGenerator;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.NRsaKeyPairGenerator;
import com.tridium.crypto.core.cert.NX509CertificateBuilder;
import com.tridium.crypto.core.cert.NX509CertificateBuilderBundle;
import com.tridium.crypto.core.cert.NX509CertificateEntry;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.CryptoStoreId;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreExemptionStore;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.crypto.core.io.ICoreStore;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.crypto.core.provider.IProvider;
import com.tridium.crypto.core.provider.NProvider;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nre.security.Aes256PasswordManager;
import com.tridium.nre.security.AesAlgorithmBundle;
import com.tridium.nre.security.EncryptionKeySource;
import com.tridium.nre.security.ISecretBytesSupplier;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.KeyStorePermission;
import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platcrypto.core.BCertManagerService;
import com.tridium.platcrypto.fox.ChannelCryptoManager;
import com.tridium.sys.Nre;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.Key;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.MissingEncodingKeyException;
import javax.baja.security.PasswordEncodingContext;
import javax.baja.security.PermissionException;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.LexiconModule;
import javax.baja.util.Version;

@NiagaraType
public class BCryptoChannel
extends BFoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BCryptoChannel.class);
    private ICoreCryptoManager service;
    private static final Logger LOGGER = Logger.getLogger("platCrypto");
    private static final LexiconModule LEX = LexiconModule.make((String)"platCrypto");
    private static final int DELETE_ENTRIES_WITHOUT_PASSWORDS_VERSION = 1;
    private static final int DELETE_ENTRIES_WITH_PASSWORDS_VERSION = 2;
    public static final String DELETE_ERROR_MESSAGE = "Invalid password to delete ";
    public static final String REPLACE_ERROR_MESSAGE = "Invalid password to replace ";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCryptoChannel() {
        super("crypto");
    }

    public void sessionOpened() throws Exception {
        if (this.isRunning()) {
            LOGGER.fine("pairing CertManagerService with CryptoChannel");
            BISession session = this.getSession();
            if (session instanceof BLocalHost) {
                ISecurityInfoProvider provider = AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider());
                this.service = CoreCryptoManager.get((ISecurityInfoProvider)provider);
            } else if (session instanceof BFoxSession) {
                this.service = new ChannelCryptoManager((BComponent)this);
            }
        }
    }

    public void sessionClosed(Throwable cause) throws Exception {
        LOGGER.fine("unpairing CertManagerService with CryptoChannel");
    }

    public FoxResponse process(FoxRequest req) throws Throwable {
        String command;
        switch (command = req.command) {
            case "keystore.serverAliases": {
                return this.keyStoreServerAliases(req);
            }
            case "keystore.aliases": {
                return this.keyStoreAliases(req);
            }
            case "keystore.containsAlias": {
                return this.keyStoreContainsAlias(req);
            }
            case "keystore.deleteEntry": {
                return this.keyStoreDeleteEntry(req);
            }
            case "keystore.getCertificate": {
                return this.keyStoreGetCertificate(req);
            }
            case "keystore.getCertificateAlias": {
                return this.keyStoreGetCertificateAlias(req);
            }
            case "keystore.getCertificateChain": {
                return this.keyStoreGetCertificateChain(req);
            }
            case "keystore.getCreationDate": {
                return this.keyStoreGetCreationDate(req);
            }
            case "keystore.getKey": {
                return this.keyStoreGetKey(req);
            }
            case "keystore.isCertificateEntry": {
                return this.keyStoreIsCertificateEntry(req);
            }
            case "keystore.isKeyEntry": {
                return this.keyStoreIsKeyEntry(req);
            }
            case "keystore.setCertificateEntry": {
                return this.keyStoreSetCertificateEntry(req);
            }
            case "keystore.setKeyEntry1": {
                return this.keyStoreSetKeyEntry1(req);
            }
            case "keystore.size": {
                return this.keyStoreSize(req);
            }
            case "keystore.save": {
                return this.keyStoreSave(req);
            }
            case "keystore.getCertificates": {
                return this.keyStoreGetCertificates(req);
            }
            case "keystore.deleteEntries": {
                return this.keyStoreDeleteEntries(req);
            }
            case "keystore.findCertificate": {
                return this.keyStoreFindCertificate(req);
            }
            case "mgr.generateSelfSignedCert": {
                return this.mgrGenerateSelfSignedCert(req);
            }
            case "mgr.resetUserKeyStore": {
                return this.mgrResetUserKeyStore(req);
            }
            case "mgr.getCertGenerationStatus": {
                return this.mgrGetCertGenerationStatus(req);
            }
            case "keystore.generateCSR": {
                return this.keyStoreGenerateCSR(req);
            }
            case "provider.Providers": {
                return this.providerProviders(req);
            }
            case "provider.getProvider": {
                return this.providerGetProvider(req);
            }
            case "exemption.exemptions": {
                return this.exemptionExemptions(req);
            }
            case "exemption.setExemption": {
                return this.exemptionSetExemption(req);
            }
            case "exemption.deleteExemption": {
                return this.exemptionDeleteExemption(req);
            }
            case "exemption.getExemption": {
                return this.exemptionGetExemption(req);
            }
            case "exemption.save": {
                return this.exemptionSave(req);
            }
            case "store.isReadOnly": {
                return this.storeIsReadOnly(req);
            }
        }
        throw new InvalidCommandException(command);
    }

    protected final boolean useSharedKeyEncryption() {
        return true;
    }

    public Enumeration<String> keyStoreServerAliases(CryptoStoreId id) throws Exception {
        KeyStorePermission.checkRead((String)id.getValue());
        FoxRequest req = this.makeRequest("keystore.serverAliases");
        req.add("cryptoStoreId", id.toString());
        FoxResponse resp = this.sendSync(req);
        String[] aliases = resp.listStrings("alias");
        List<String> list = Arrays.asList(aliases);
        return Collections.enumeration(list);
    }

    private FoxResponse keyStoreServerAliases(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminRead);
        FoxResponse resp = new FoxResponse(req);
        ICoreKeyStore keyStore = (ICoreKeyStore)this.getCorrectCryptoStore(req);
        Enumeration e = keyStore.aliases();
        while (e.hasMoreElements()) {
            String alias = (String)e.nextElement();
            if (!CertUtils.isValidServerCert((String)alias, (ICoreKeyStore)keyStore)) continue;
            resp.add("alias", alias);
        }
        return resp;
    }

    public Enumeration<String> keyStoreAliases(CryptoStoreId id) throws Exception {
        KeyStorePermission.checkRead((String)id.getValue());
        FoxRequest req = this.makeRequest("keystore.aliases");
        req.add("cryptoStoreId", id.toString());
        FoxResponse resp = this.sendSync(req);
        String[] aliases = resp.listStrings("alias");
        List<String> list = Arrays.asList(aliases);
        return Collections.enumeration(list);
    }

    private FoxResponse keyStoreAliases(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminRead);
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        Enumeration e = keyStore.aliases();
        while (e.hasMoreElements()) {
            String alias = (String)e.nextElement();
            resp.add("alias", alias);
        }
        return resp;
    }

    public boolean keyStoreContainsAlias(CryptoStoreId id, String alias) throws Exception {
        KeyStorePermission.checkRead((String)id.getValue());
        FoxRequest req = this.makeRequest("keystore.containsAlias");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        FoxResponse resp = this.sendSync(req);
        return resp.getBoolean("containsAlias");
    }

    private FoxResponse keyStoreContainsAlias(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminRead);
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        resp.add("containsAlias", keyStore.containsAlias(req.getString("alias")));
        return resp;
    }

    public void keyStoreDeleteEntry(CryptoStoreId id, String alias) throws Exception {
        this.keyStoreDeleteEntry(id, alias, null);
    }

    public void keyStoreDeleteEntry(CryptoStoreId id, String alias, SecretChars password) throws Exception {
        KeyStorePermission.checkWrite((String)id.getValue());
        FoxRequest req = this.makeRequest("keystore.deleteEntry");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        if (password != null) {
            req.add("password", this.encrypt(password.asSecretBytes(StandardCharsets.UTF_8, false), this.makeEncodingContext(null)));
        }
        this.sendSync(req);
    }

    private FoxResponse keyStoreDeleteEntry(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminInvoke);
        CryptoStoreId id = CryptoStoreId.getEnum((String)req.getString("cryptoStoreId"));
        if (id == CryptoStoreId.USER_EXEMPTION_STORE) {
            throw new IllegalArgumentException("Invalid store id passed to keyStoreDeleteEntry: " + id);
        }
        if (id == CryptoStoreId.USER_TRUST_STORE) {
            this.checkSuperUser(LEX.getText("cert.userTrustStore.deleteCommand", this.getSessionContext()));
        } else {
            BCryptoChannel.checkUserPermissions(BPermissions.adminInvoke);
        }
        if (id == CryptoStoreId.USER_KEY_STORE) {
            return this.keyStoreDeleteEntryForKeyStore(req);
        }
        return this.keyStoreDeleteEntryForTrustStore(req);
    }

    private FoxResponse keyStoreDeleteEntryForTrustStore(FoxRequest req) throws Exception {
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        String alias = req.getString("alias");
        keyStore.deleteEntry(alias);
        return new FoxResponse(req);
    }

    private FoxResponse keyStoreDeleteEntryForKeyStore(FoxRequest req) throws Exception {
        block13: {
            ICoreKeyStore keyStore = (ICoreKeyStore)this.getCorrectCryptoStore(req);
            String alias = req.getString("alias");
            try (SecretBytes password = this.decrypt(req.getString("password", null), this.makeDecodingContext(null));){
                if (BCryptoChannel.isAllowedToDeleteKeyStoreEntry(alias, SecretChars.fromSecretBytes((SecretBytes)password, (Charset)StandardCharsets.UTF_8, (boolean)true), keyStore)) {
                    keyStore.deleteEntry(alias);
                    break block13;
                }
                throw new UnrecoverableKeyException(DELETE_ERROR_MESSAGE + alias);
            }
        }
        return new FoxResponse(req);
    }

    public X509Certificate keyStoreGetCertificate(CryptoStoreId id, String alias) throws Exception {
        KeyStorePermission.checkRead((String)id.getValue());
        FoxRequest req = this.makeRequest("keystore.getCertificate");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        FoxResponse resp = this.sendSync(req);
        String certString = resp.getString("certificate", null);
        if (certString != null) {
            return CertUtils.decodeX509Certificate((String)certString);
        }
        return null;
    }

    private FoxResponse keyStoreGetCertificate(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminRead);
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        X509Certificate cert = keyStore.getCertificate(req.getString("alias"));
        if (cert != null) {
            resp.add("certificate", CertUtils.encodeX509Certificate((X509Certificate)cert));
        }
        return resp;
    }

    public String keyStoreGetCertificateAlias(CryptoStoreId id, X509Certificate cert) throws Exception {
        KeyStorePermission.checkRead((String)id.getValue());
        FoxRequest req = this.makeRequest("keystore.getCertificateAlias");
        req.add("cryptoStoreId", id.toString());
        req.add("certificate", CertUtils.encodeX509Certificate((X509Certificate)cert));
        FoxResponse resp = this.sendSync(req);
        return resp.getString("alias", null);
    }

    private FoxResponse keyStoreGetCertificateAlias(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminRead);
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        X509Certificate cert = CertUtils.decodeX509Certificate((String)req.getString("certificate"));
        String alias = keyStore.getCertificateAlias(cert);
        if (alias != null) {
            resp.add("alias", alias);
        }
        return resp;
    }

    public X509Certificate[] keyStoreGetCertificateChain(CryptoStoreId id, String alias) throws Exception {
        KeyStorePermission.checkRead((String)id.getValue());
        FoxRequest req = this.makeRequest("keystore.getCertificateChain");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        FoxResponse resp = this.sendSync(req);
        String[] certsStr = resp.listStrings("certificateChain");
        X509Certificate[] certs = null;
        if (certsStr.length > 0) {
            certs = new X509Certificate[certsStr.length];
            for (int i = 0; i < certsStr.length; ++i) {
                certs[i] = CertUtils.decodeX509Certificate((String)certsStr[i]);
            }
        }
        return certs;
    }

    private FoxResponse keyStoreGetCertificateChain(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminRead);
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        X509Certificate[] certs = keyStore.getCertificateChain(req.getString("alias"));
        if (certs != null) {
            for (X509Certificate cert : certs) {
                resp.add("certificateChain", CertUtils.encodeX509Certificate((X509Certificate)cert));
            }
        }
        return resp;
    }

    public Date keyStoreGetCreationDate(CryptoStoreId id, String alias) throws Exception {
        KeyStorePermission.checkRead((String)id.getValue());
        FoxRequest req = this.makeRequest("keystore.getCreationDate");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        FoxResponse resp = this.sendSync(req);
        return new Date(resp.getTime("creationDate"));
    }

    private FoxResponse keyStoreGetCreationDate(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminRead);
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        Date date = keyStore.getCreationDate(req.getString("alias"));
        resp.add("creationDate", date.getTime());
        return resp;
    }

    public Key keyStoreGetKey(CryptoStoreId id, String alias, char[] password) throws Exception {
        KeyStorePermission.checkRead((String)id.getValue());
        FoxRequest req = this.makeRequest("keystore.getKey");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        if (password != null) {
            String pass = new String(password);
            String encpass = this.encrypt(pass, this.makeEncodingContext(null));
            req.add("password", encpass);
        }
        FoxResponse resp = this.sendSync(req);
        Key key = null;
        boolean success = resp.getBoolean("success", false);
        if (success) {
            String encKey = this.decryptToString(resp.getString("key", null), this.makeDecodingContext(null));
            if (encKey != null) {
                key = NKey.decodeFromString((String)encKey);
            }
            return key;
        }
        throw new UnrecoverableKeyException("unable to recover key");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FoxResponse keyStoreGetKey(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminRead);
        FoxResponse resp = new FoxResponse(req);
        ICoreKeyStore keyStore = (ICoreKeyStore)this.getCorrectCryptoStore(req);
        String encryptedPassword = req.getString("password", null);
        try (SecretChars secretChars = encryptedPassword != null ? SecretChars.fromSecretBytes((SecretBytes)this.decrypt(req.getString("password"), this.makeDecodingContext(null)), (Charset)StandardCharsets.UTF_8, (boolean)true) : null;){
            char[] password = encryptedPassword != null ? secretChars.get() : null;
            Key key = keyStore.getKey(req.getString("alias"), password);
            if (key != null) {
                resp.add("success", true);
                resp.add("key", this.encrypt(NKey.encodeToString((Key)key), this.makeEncodingContext(null)));
            } else {
                resp.add("success", false);
            }
            FoxResponse foxResponse = resp;
            return foxResponse;
        }
        catch (UnrecoverableKeyException uke) {
            resp.add("success", false);
            return resp;
        }
    }

    public boolean keyStoreIsCertificateEntry(CryptoStoreId id, String alias) throws Exception {
        KeyStorePermission.checkRead((String)id.getValue());
        FoxRequest req = this.makeRequest("keystore.isCertificateEntry");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        FoxResponse resp = this.sendSync(req);
        return resp.getBoolean("isCertificateEntry");
    }

    private FoxResponse keyStoreIsCertificateEntry(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminRead);
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        resp.add("isCertificateEntry", keyStore.isCertificateEntry(req.getString("alias")));
        return resp;
    }

    public boolean keyStoreIsKeyEntry(CryptoStoreId id, String alias) throws Exception {
        KeyStorePermission.checkRead((String)id.getValue());
        FoxRequest req = this.makeRequest("keystore.isKeyEntry");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        FoxResponse resp = this.sendSync(req);
        return resp.getBoolean("isKeyEntry");
    }

    private FoxResponse keyStoreIsKeyEntry(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminRead);
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        resp.add("isKeyEntry", keyStore.isKeyEntry(req.getString("alias")));
        return resp;
    }

    public void keyStoreSetCertificateEntry(CryptoStoreId id, String alias, X509Certificate cert) throws Exception {
        KeyStorePermission.checkWrite((String)id.getValue());
        FoxRequest req = this.makeRequest("keystore.setCertificateEntry");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        req.add("certificate", CertUtils.encodeX509Certificate((X509Certificate)cert));
        this.sendSync(req);
    }

    private FoxResponse keyStoreSetCertificateEntry(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminInvoke);
        CryptoStoreId id = CryptoStoreId.getEnum((String)req.getString("cryptoStoreId"));
        if (id.equals((Object)CryptoStoreId.USER_TRUST_STORE)) {
            this.checkSuperUser(LEX.getText("cert.userTrustStore.setCommand", this.getSessionContext()));
        }
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        X509Certificate cert = CertUtils.decodeX509Certificate((String)req.getString("certificate"));
        keyStore.setCertificateEntry(req.getString("alias"), cert);
        return resp;
    }

    public void keyStoreSetKeyEntry1(CryptoStoreId id, String alias, Key key, SecretChars existingPassword, SecretChars newPassword, X509Certificate[] chain) throws Exception {
        KeyStorePermission.checkWrite((String)id.getValue());
        Context cx = this.makeEncodingContext(null);
        FoxRequest req = this.makeRequest("keystore.setKeyEntry1");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        req.add("key", this.encrypt(NKey.encodeToString((Key)key), cx));
        if (newPassword != null) {
            String encpass = this.encrypt(newPassword.asString(false), cx);
            req.add("password", encpass);
        }
        if (existingPassword != null) {
            String existingPwdStr = this.encrypt(existingPassword.asString(false), cx);
            req.add("existingCertPwd", existingPwdStr);
        }
        if (chain != null) {
            for (X509Certificate aChain : chain) {
                req.add("chain", CertUtils.encodeX509Certificate((X509Certificate)aChain));
            }
        }
        this.sendSync(req);
    }

    private FoxResponse keyStoreSetKeyEntry1(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminInvoke);
        Context cx = this.makeDecodingContext(null);
        CryptoStoreId id = CryptoStoreId.getEnum((String)req.getString("cryptoStoreId"));
        if (id.equals((Object)CryptoStoreId.USER_TRUST_STORE)) {
            this.checkSuperUser(LEX.getText("cert.userTrustStore.setCommand", this.getSessionContext()));
        }
        FoxResponse resp = new FoxResponse(req);
        ICoreKeyStore keyStore = (ICoreKeyStore)this.getCorrectCryptoStore(req);
        String alias = req.getString("alias");
        String existingPasswordStr = req.getString("existingCertPwd", null);
        if (keyStore.containsAlias(alias)) {
            try (SecretChars existingPassword = existingPasswordStr != null ? SecretChars.fromSecretBytes((SecretBytes)this.decrypt(existingPasswordStr, cx), (Charset)StandardCharsets.UTF_8, (boolean)true) : null;){
                if (!BCryptoChannel.isAllowedToDeleteKeyStoreEntry(alias, existingPassword, keyStore)) {
                    throw new Exception("unable to validate access to current key");
                }
            }
        }
        Key key = NKey.decodeFromString((String)this.decryptToString(req.getString("key"), cx));
        String encryptedPassword = req.getString("password", null);
        try (SecretChars secretChars = encryptedPassword != null ? SecretChars.fromSecretBytes((SecretBytes)this.decrypt(req.getString("password"), cx), (Charset)StandardCharsets.UTF_8, (boolean)true) : null;){
            char[] password = encryptedPassword != null ? secretChars.get() : null;
            X509Certificate[] certs = null;
            try {
                String[] chain = req.listStrings("chain");
                certs = new X509Certificate[chain.length];
                for (int i = 0; i < chain.length; ++i) {
                    certs[i] = CertUtils.decodeX509Certificate((String)chain[i]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            keyStore.setKeyEntry(alias, key, password, certs);
            FoxResponse foxResponse = resp;
            return foxResponse;
        }
    }

    public int keyStoreSize(CryptoStoreId id) throws Exception {
        KeyStorePermission.checkRead((String)id.getValue());
        FoxRequest req = this.makeRequest("keystore.size");
        req.add("cryptoStoreId", id.toString());
        FoxResponse resp = this.sendSync(req);
        return resp.getInt("size");
    }

    private FoxResponse keyStoreSize(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminRead);
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        resp.add("size", keyStore.size());
        return resp;
    }

    public void keyStoreSave(CryptoStoreId id) throws Exception {
        KeyStorePermission.checkWrite((String)id.getValue());
        FoxRequest req = this.makeRequest("keystore.save");
        req.add("cryptoStoreId", id.toString());
        this.sendSync(req);
    }

    private FoxResponse keyStoreSave(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminInvoke);
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        keyStore.save();
        return resp;
    }

    public Iterable<IX509CertificateEntry> keyStoreGetCertificates(CryptoStoreId id) throws Exception {
        KeyStorePermission.checkRead((String)id.getValue());
        FoxRequest req = this.makeRequest("keystore.getCertificates");
        req.add("cryptoStoreId", id.toString());
        FoxResponse resp = this.sendSync(req);
        String[] certs = resp.listStrings("cert");
        ArrayList<IX509CertificateEntry> entries = new ArrayList<IX509CertificateEntry>();
        for (String cert : certs) {
            NX509CertificateEntry entry = NX509CertificateEntry.decodeFromString((String)cert);
            entries.add((IX509CertificateEntry)entry);
        }
        return entries;
    }

    private FoxResponse keyStoreGetCertificates(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminRead);
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        for (IX509CertificateEntry entry : keyStore.getCertificateEntries()) {
            resp.add("cert", entry.encodeToString());
        }
        return resp;
    }

    public String keyStoreFindCertificate(CryptoStoreId id, X509Certificate cert) throws Exception {
        KeyStorePermission.checkRead((String)id.getValue());
        FoxRequest req = this.makeRequest("keystore.findCertificate");
        req.add("cryptoStoreId", id.toString());
        req.add("certificate", CertUtils.encodeX509Certificate((X509Certificate)cert));
        FoxResponse resp = this.sendSync(req);
        return resp.getString("alias", null);
    }

    private FoxResponse keyStoreFindCertificate(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminRead);
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        X509Certificate match = CertUtils.decodeX509Certificate((String)req.getString("certificate"));
        String alias = keyStore.findCertificate(match);
        if (alias != null) {
            resp.add("alias", alias);
        }
        return resp;
    }

    public void keyStoreDeleteEntries(CryptoStoreId id, String[] aliases) throws Exception {
        KeyStorePermission.checkWrite((String)id.getValue());
        FoxRequest req = this.makeRequest("keystore.deleteEntries");
        req.add("cryptoStoreId", id.toString());
        HashMap<String, SecretChars> aliasesAndPasswords = new HashMap<String, SecretChars>();
        for (String alias : aliases) {
            aliasesAndPasswords.put(alias, null);
        }
        this.keyStoreDeleteEntries(id, aliasesAndPasswords);
    }

    public void keyStoreDeleteEntries(CryptoStoreId id, Map<String, SecretChars> aliasesAndPasswords) throws Exception {
        KeyStorePermission.checkWrite((String)id.getValue());
        FoxRequest req = this.makeRequest("keystore.deleteEntries");
        req.add("cryptoStoreId", id.toString());
        Version remoteVersion = new Version(this.getConnection().session().getRemoteHello().getString("app.version", ""));
        if (remoteVersion.compareTo(VER_4_13) < 0) {
            for (String alias : aliasesAndPasswords.keySet()) {
                req.add("alias", alias);
            }
        } else {
            req.add("version", 2);
            req.add("size", aliasesAndPasswords.size());
            int index = 0;
            for (Map.Entry<String, SecretChars> entry : aliasesAndPasswords.entrySet()) {
                req.add("alias." + index, entry.getKey());
                if (entry.getValue() != null) {
                    req.add("password." + index, this.encrypt(entry.getValue().asSecretBytes(StandardCharsets.UTF_8, false), this.makeEncodingContext(null)));
                }
                ++index;
            }
        }
        this.sendSync(req);
    }

    private FoxResponse keyStoreDeleteEntries(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminInvoke);
        CryptoStoreId id = CryptoStoreId.getEnum((String)req.getString("cryptoStoreId"));
        if (id == CryptoStoreId.USER_EXEMPTION_STORE) {
            throw new IllegalArgumentException("Invalid store id passed to keyStoreDeleteEntry: " + id);
        }
        if (id == CryptoStoreId.USER_TRUST_STORE) {
            this.checkSuperUser(LEX.getText("cert.userTrustStore.deleteCommand", this.getSessionContext()));
        } else {
            BCryptoChannel.checkUserPermissions(BPermissions.adminInvoke);
        }
        if (id == CryptoStoreId.USER_KEY_STORE) {
            return this.keyStoreDeleteEntriesForKeyStore(req);
        }
        return this.keyStoreDeleteEntriesForTrustStore(req);
    }

    private FoxResponse keyStoreDeleteEntriesForTrustStore(FoxRequest req) throws Exception {
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        if (req.getInt("version", 1) == 2) {
            ArrayList<String> aliases = new ArrayList<String>();
            int size = req.getInt("size");
            for (int i = 0; i < size; ++i) {
                String alias = req.getString(("alias." + i).intern());
                aliases.add(alias);
            }
            keyStore.deleteEntries(aliases.toArray(new String[0]));
        } else {
            keyStore.deleteEntries(req.listStrings("alias"));
        }
        return new FoxResponse(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FoxResponse keyStoreDeleteEntriesForKeyStore(FoxRequest req) throws Exception {
        block24: {
            ICoreKeyStore keyStore = (ICoreKeyStore)this.getCorrectCryptoStore(req);
            CryptoStoreId id = CryptoStoreId.getEnum((String)req.getString("cryptoStoreId"));
            if (id != CryptoStoreId.USER_KEY_STORE) {
                throw new IllegalArgumentException("Invalid keystore id provided");
            }
            HashMap<String, SecretChars> aliasesAndPasswords = new HashMap<String, SecretChars>();
            try {
                if (req.getInt("version", 1) == 2) {
                    int size = req.getInt("size");
                    for (int i = 0; i < size; ++i) {
                        String alias = req.getString(("alias." + i).intern());
                        try (SecretBytes password = this.decrypt(req.getString(("password." + i).intern(), null), this.makeDecodingContext(null));){
                            aliasesAndPasswords.put(alias, SecretChars.fromSecretBytes((SecretBytes)password, (Charset)StandardCharsets.UTF_8, (boolean)true));
                            continue;
                        }
                    }
                } else {
                    for (String alias : req.listStrings("alias")) {
                        aliasesAndPasswords.put(alias, null);
                    }
                }
                ArrayList aliases = new ArrayList();
                ArrayList badAliases = new ArrayList();
                for (Map.Entry entry : aliasesAndPasswords.entrySet()) {
                    if (BCryptoChannel.isAllowedToDeleteKeyStoreEntry((String)entry.getKey(), (SecretChars)entry.getValue(), keyStore)) {
                        aliases.add(entry.getKey());
                        continue;
                    }
                    badAliases.add(entry.getKey());
                }
                if (badAliases.isEmpty()) {
                    keyStore.deleteEntries(aliases.toArray(new String[0]));
                    break block24;
                }
                throw new UnrecoverableKeyException(DELETE_ERROR_MESSAGE + String.join((CharSequence)", ", badAliases));
            }
            finally {
                for (Map.Entry aliasesEntry : aliasesAndPasswords.entrySet()) {
                    SecretChars passwordChars = (SecretChars)aliasesEntry.getValue();
                    if (passwordChars == null) continue;
                    passwordChars.close();
                }
            }
        }
        return new FoxResponse(req);
    }

    private static boolean isAllowedToDeleteKeyStoreEntry(String alias, SecretChars password, ICoreKeyStore keyStore) {
        try {
            BUser authenticatedUser = BUser.getCurrentAuthenticatedUser();
            if (authenticatedUser != null && authenticatedUser.getPermissions().isSuperUser()) {
                return true;
            }
            return CertUtils.checkHasMatchingPrivateKey((String)alias, (SecretChars)password, (ICoreKeyStore)keyStore);
        }
        catch (Exception e) {
            return false;
        }
    }

    public int mgrGenerateSelfSignedCert(NCertificateParameters certParams) throws Exception {
        KeyStorePermission.checkWrite((String)CryptoStoreId.USER_KEY_STORE.getValue());
        FoxRequest req = this.makeRequest("mgr.generateSelfSignedCert");
        String certParamString = this.encrypt(certParams.encodeToString(), this.makeEncodingContext(null));
        req.add("certParams", certParamString);
        FoxResponse resp = this.sendSync(req);
        return resp.getInt("requestId", -1);
    }

    public int mgrGenerateSelfSignedCert(NX509CertificateBuilder builder, NKeyPairGenerator generator, SecretChars existingPassword, SecretChars newPassword) throws Exception {
        KeyStorePermission.checkWrite((String)CryptoStoreId.USER_KEY_STORE.getValue());
        FoxRequest req = this.makeRequest("mgr.generateSelfSignedCert");
        NX509CertificateBuilderBundle bundle = new NX509CertificateBuilderBundle(builder, generator, newPassword);
        String certBuilderStr = this.encrypt(bundle.encodeToString(), this.makeEncodingContext(null));
        req.add("certBuilder", certBuilderStr);
        if (existingPassword != null) {
            String existingPwdStr = this.encrypt(existingPassword.asString(false), this.makeEncodingContext(null));
            req.add("existingCertPwd", existingPwdStr);
        }
        FoxResponse resp = this.sendSync(req);
        return resp.getInt("requestId", -1);
    }

    private FoxResponse mgrGenerateSelfSignedCert(FoxRequest req) throws Exception {
        NX509CertificateBuilderBundle bundle;
        FoxResponse resp;
        block18: {
            BCryptoChannel.checkUserPermissions(BPermissions.adminInvoke);
            resp = new FoxResponse(req);
            bundle = null;
            String certStr = req.getString("certBuilder", null);
            if (certStr != null) {
                certStr = this.decryptToString(certStr, this.makeDecodingContext(null));
                bundle = NX509CertificateBuilderBundle.decodeFromString((String)certStr);
            } else {
                certStr = req.getString("certParams", null);
                if (certStr != null) {
                    certStr = this.decryptToString(certStr, this.makeDecodingContext(null));
                    NCertificateParameters params = new NCertificateParameters(certStr);
                    NX509CertificateBuilder builder = CertUtils.createCertBuilderFromParameters((NCertificateParameters)params);
                    NRsaKeyPairGenerator generator = new NRsaKeyPairGenerator(params.getKeySize());
                    SecretChars password = null;
                    if (params.getPassword() != null) {
                        password = new SecretChars(params.getPassword().toCharArray(), true);
                    }
                    bundle = new NX509CertificateBuilderBundle(builder, (NKeyPairGenerator)generator, password);
                }
            }
            String alias = bundle.getBuilder().getAlias();
            if (this.service.getKeyStore().containsAlias(alias)) {
                try (SecretBytes password = this.decrypt(req.getString("existingCertPwd", null), this.makeDecodingContext(null));){
                    if (BCryptoChannel.isAllowedToDeleteKeyStoreEntry(alias, SecretChars.fromSecretBytes((SecretBytes)password, (Charset)StandardCharsets.UTF_8, (boolean)true), this.service.getKeyStore())) {
                        this.service.getKeyStore().deleteEntry(alias);
                        break block18;
                    }
                    throw new UnrecoverableKeyException(REPLACE_ERROR_MESSAGE + bundle.getBuilder().getAlias());
                }
            }
        }
        int requestId = this.service.generateSelfSignedCert(bundle.getBuilder(), bundle.getGenerator(), bundle.getPassword());
        resp.add("requestId", requestId);
        return resp;
    }

    public int mgrResetUserKeyStore() throws Exception {
        KeyStorePermission.checkWrite((String)CryptoStoreId.USER_KEY_STORE.getValue());
        FoxRequest req = this.makeRequest("mgr.resetUserKeyStore");
        FoxResponse resp = this.sendSync(req);
        return resp.getInt("requestId", -1);
    }

    private FoxResponse mgrResetUserKeyStore(FoxRequest req) throws Exception {
        if (!BUser.getCurrentAuthenticatedUser().getPermissions().isSuperUser()) {
            throw new PermissionException("insufficient permissions: super user required");
        }
        FoxResponse resp = new FoxResponse(req);
        int requestId = this.service.resetUserKeyStore();
        resp.add("requestId", requestId);
        return resp;
    }

    public int mgrGetCertGenerationStatus(int requestId) throws Exception {
        FoxRequest req = this.makeRequest("mgr.getCertGenerationStatus");
        req.add("requestId", requestId);
        FoxResponse resp = this.sendSync(req);
        return resp.getInt("status", -1);
    }

    private FoxResponse mgrGetCertGenerationStatus(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminRead);
        FoxResponse resp = new FoxResponse(req);
        int requestId = req.getInt("requestId", -1);
        int status = this.service.getCertGenerationStatus(requestId);
        resp.add("requestId", requestId);
        resp.add("status", status);
        return resp;
    }

    public NPKCS10CertificationRequest keyStoreGenerateCSR(String alias, String passwd) throws Exception {
        KeyStorePermission.checkRead((String)CryptoStoreId.USER_KEY_STORE.getValue());
        FoxRequest req = this.makeRequest("keystore.generateCSR");
        req.add("alias", alias);
        if (passwd != null) {
            req.add("passwd", this.encrypt(passwd, this.makeEncodingContext(null)));
        }
        FoxResponse resp = this.sendSync(req);
        return NPKCS10CertificationRequest.make((String)resp.getString("csr"));
    }

    private FoxResponse keyStoreGenerateCSR(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminInvoke);
        FoxResponse resp = new FoxResponse(req);
        String alias = req.getString("alias");
        String passwd = this.decryptToString(req.getString("passwd", null), this.makeDecodingContext(null));
        NPKCS10CertificationRequest csr = this.service.generateCSR(alias, passwd);
        resp.add("csr", csr.encodeToString());
        return resp;
    }

    public Enumeration<NProvider> providerProviders() throws Exception {
        String[] tproviders;
        FoxRequest req = this.makeRequest("provider.Providers");
        FoxResponse resp = this.sendSync(req);
        Vector<NProvider> providers = new Vector<NProvider>();
        for (String tprovider : tproviders = resp.listStrings("provider")) {
            providers.add(NProvider.decodeFromString((String)tprovider));
        }
        return providers.elements();
    }

    private FoxResponse providerProviders(FoxRequest req) throws Exception {
        NProvider[] providers;
        FoxResponse resp = new FoxResponse(req);
        for (NProvider provider : providers = NProvider.getProviders()) {
            resp.add("provider", provider.encodeToString());
        }
        return resp;
    }

    public IProvider providerGetProvider(String name) throws Exception {
        FoxRequest req = this.makeRequest("provider.getProvider");
        req.add("name", name);
        FoxResponse resp = this.sendSync(req);
        return NProvider.decodeFromString((String)resp.getString("provider"));
    }

    private FoxResponse providerGetProvider(FoxRequest req) throws Exception {
        NProvider[] providers;
        FoxResponse resp = new FoxResponse(req);
        for (NProvider provider : providers = NProvider.getProviders()) {
            resp.add("provider", provider.encodeToString());
        }
        return resp;
    }

    public Enumeration<NHostExemption> exemptionExemptions() throws Exception {
        KeyStorePermission.checkRead((String)CryptoStoreId.USER_EXEMPTION_STORE.getValue());
        FoxRequest req = this.makeRequest("exemption.exemptions");
        FoxResponse resp = this.sendSync(req);
        String[] exemptionStrings = resp.listStrings("exemption");
        Array exemptions = new Array(NHostExemption.class);
        for (String exemptionString : exemptionStrings) {
            exemptions.push((Object)NHostExemption.decodeFromString((String)exemptionString));
        }
        return Collections.enumeration(exemptions.list());
    }

    private FoxResponse exemptionExemptions(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminRead);
        FoxResponse resp = new FoxResponse(req);
        ICoreExemptionStore mgr = this.service.getExemptionStore();
        Enumeration e = mgr.exemptions();
        while (e.hasMoreElements()) {
            NHostExemption exemption = (NHostExemption)e.nextElement();
            resp.add("exemption", exemption.encodeToString());
        }
        return resp;
    }

    public void exemptionSetExemption(NHostExemption exemption) throws Exception {
        KeyStorePermission.checkWrite((String)CryptoStoreId.USER_EXEMPTION_STORE.getValue());
        FoxRequest req = this.makeRequest("exemption.setExemption");
        req.add("exemption", exemption.encodeToString());
        this.sendSync(req);
    }

    private FoxResponse exemptionSetExemption(FoxRequest req) throws Exception {
        NHostExemption exemption = NHostExemption.make((String)req.getString("exemption"));
        if (exemption.getApproved()) {
            this.checkSuperUser(LEX.getText("cert.exemptionStore.approveCommand", this.getSessionContext()));
        } else {
            this.checkSuperUser(LEX.getText("cert.exemptionStore.unapproveCommand", this.getSessionContext()));
        }
        FoxResponse resp = new FoxResponse(req);
        ICoreExemptionStore mgr = this.service.getExemptionStore();
        mgr.setExemption(exemption);
        return resp;
    }

    public void exemptionDeleteExemption(String host) throws Exception {
        KeyStorePermission.checkWrite((String)CryptoStoreId.USER_EXEMPTION_STORE.getValue());
        FoxRequest req = this.makeRequest("exemption.deleteExemption");
        req.add("host", host);
        this.sendSync(req);
    }

    private FoxResponse exemptionDeleteExemption(FoxRequest req) throws Exception {
        this.checkSuperUser(LEX.getText("cert.exemptionStore.deleteCommand", this.getSessionContext()));
        FoxResponse resp = new FoxResponse(req);
        ICoreExemptionStore mgr = this.service.getExemptionStore();
        String host = req.getString("host");
        mgr.deleteExemption(host);
        return resp;
    }

    public NHostExemption exemptionGetExemption(String host) throws Exception {
        KeyStorePermission.checkRead((String)CryptoStoreId.USER_EXEMPTION_STORE.getValue());
        FoxRequest req = this.makeRequest("exemption.getExemption");
        req.add("host", host);
        FoxResponse resp = this.sendSync(req);
        String exemptString = resp.getString("exemption");
        return NHostExemption.make((String)exemptString);
    }

    private FoxResponse exemptionGetExemption(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminRead);
        FoxResponse resp = new FoxResponse(req);
        ICoreExemptionStore mgr = this.service.getExemptionStore();
        String host = req.getString("host");
        NHostExemption exemption = mgr.getExemption(host);
        resp.add("exemption", exemption.encodeToString());
        return resp;
    }

    public void exemptionSave() throws Exception {
        KeyStorePermission.checkWrite((String)CryptoStoreId.USER_EXEMPTION_STORE.getValue());
        FoxRequest req = this.makeRequest("exemption.save");
        this.sendSync(req);
    }

    private FoxResponse exemptionSave(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminInvoke);
        FoxResponse resp = new FoxResponse(req);
        ICoreExemptionStore mgr = this.service.getExemptionStore();
        mgr.save();
        return resp;
    }

    public boolean storeIsReadOnly(CryptoStoreId id) throws Exception {
        FoxRequest req = this.makeRequest("store.isReadOnly");
        req.add("cryptoStoreId", id.toString());
        FoxResponse resp = this.sendSync(req);
        return resp.getBoolean("isReadOnly", true);
    }

    private FoxResponse storeIsReadOnly(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminRead);
        FoxResponse resp = new FoxResponse(req);
        ICoreStore store = this.getCorrectCryptoStore(req);
        resp.add("isReadOnly", store.isReadOnly());
        return resp;
    }

    private ICoreStore getCorrectCryptoStore(FoxRequest req) throws Exception {
        CryptoStoreId id = CryptoStoreId.getEnum((String)req.getString("cryptoStoreId"));
        switch (id) {
            case USER_KEY_STORE: {
                return this.service.getKeyStore();
            }
            case USER_TRUST_STORE: {
                return this.service.getUserTrustStore();
            }
            case USER_UNTRUSTED_STORE: {
                return this.service.getUserUntrustedStore();
            }
            case SYSTEM_TRUST_STORE: {
                return this.service.getSystemTrustStore();
            }
            case USER_EXEMPTION_STORE: {
                return this.service.getExemptionStore();
            }
        }
        throw new IllegalArgumentException("Invalid key store location provided");
    }

    public File getBaseDir() {
        try {
            return new File(BCryptoChannel.getFilePath(BOrd.make((String)"file:~")));
        }
        catch (Exception e) {
            return Nre.getNiagaraHome();
        }
    }

    private static String getFilePath(BOrd ord) throws IOException {
        OrdQuery[] o = ord.parse();
        FilePath p = (FilePath)o[o.length - 1];
        File f = BFileSystem.INSTANCE.pathToLocalFile(p);
        return f.getPath();
    }

    private String encrypt(String secret, Context cx) throws Exception {
        if (secret == null) {
            return null;
        }
        return this.encrypt(SecretBytes.fromString((String)secret), cx);
    }

    private String encrypt(SecretBytes secret, Context cx) throws Exception {
        PasswordEncodingContext pContext = PasswordEncodingContext.from((Context)cx);
        if (pContext.getDecryptionKeySource() == EncryptionKeySource.none) {
            pContext.close();
            throw new MissingEncodingKeyException();
        }
        return AccessController.doPrivileged(() -> {
            try {
                if (!(this.encryptionAlgorithmBundle instanceof AesAlgorithmBundle)) {
                    throw new SecurityException("Invalid algorithm bundle: " + this.encryptionAlgorithmBundle.getAlgorithmName());
                }
                AesAlgorithmBundle bundle = this.encryptionAlgorithmBundle.getAlgorithmVersion().equals("1") ? AesAlgorithmBundle.make((int)256, (String)"1") : (AesAlgorithmBundle)this.encryptionAlgorithmBundle;
                byte[] iv = new byte[16];
                new SecureRandom().nextBytes(iv);
                String aesTransformation = bundle.getAesTransformation();
                byte[] key = ((SecretBytes)((ISecretBytesSupplier)pContext.getEncryptionKey().get()).get()).get();
                byte[] cipher = Aes256PasswordManager.encrypt((byte[])secret.get(), (byte[])iv, (byte[])key, (String)aesTransformation);
                String[] data = new String[]{ByteArrayUtil.toHexString((byte[])iv), ByteArrayUtil.toHexString((byte[])cipher)};
                return bundle.encode(data);
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    private String decryptToString(String encrypted, Context cx) throws Exception {
        SecretBytes decrypted = this.decrypt(encrypted, cx);
        if (decrypted == null) {
            return null;
        }
        return decrypted.asString(true, StandardCharsets.UTF_8);
    }

    private SecretBytes decrypt(String encrypted, Context cx) throws Exception {
        if (encrypted == null) {
            return null;
        }
        PasswordEncodingContext pContext = PasswordEncodingContext.from((Context)cx);
        if (pContext.getDecryptionKeySource() == EncryptionKeySource.none) {
            pContext.close();
            throw new MissingEncodingKeyException();
        }
        return AccessController.doPrivileged(() -> {
            try {
                CryptographicAlgorithmBundle algorithmBundle = CryptographicAlgorithmBundle.getInstanceFor((String)encrypted);
                if (!(algorithmBundle instanceof AesAlgorithmBundle)) {
                    throw new SecurityException("Invalid algorithm bundle: " + algorithmBundle.getAlgorithmName());
                }
                String[] data = algorithmBundle.decode(encrypted);
                Objects.requireNonNull(data);
                String iv = data[0];
                byte[] ivBytes = ByteArrayUtil.hexStringToBytes((String)iv);
                String cipher = data[1];
                byte[] cipherBytes = ByteArrayUtil.hexStringToBytes((String)cipher);
                return Aes256PasswordManager.decryptSecret((byte[])((SecretBytes)((ISecretBytesSupplier)pContext.getDecryptionKey().get()).get()).get(), (byte[])cipherBytes, (byte[])ivBytes, (String)((AesAlgorithmBundle)algorithmBundle).getAesTransformation());
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    private static void checkUserPermissions(BPermissions requiredPermissions) {
        BCertManagerService cms = (BCertManagerService)Sys.getService((Type)BCertManagerService.TYPE);
        BPermissions perms = BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)cms);
        if (!perms.has(requiredPermissions)) {
            throw new PermissionException("insufficient permissions " + perms.toString(null) + " < " + requiredPermissions.toString(null));
        }
    }

    private void checkSuperUser(String commandName) {
        BUser authenticatedUser = BUser.getCurrentAuthenticatedUser();
        if (authenticatedUser != null && authenticatedUser.getPermissions().isSuperUser()) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(LEX.getText("cert.userTrustStore.superUserPermissionException", null, new Object[]{commandName}));
        }
        throw new PermissionException(LEX.getText("cert.userTrustStore.superUserPermissionException", this.getSessionContext(), new Object[]{commandName}));
    }
}

