/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.daemon;

import com.tridium.platcrypto.daemon.messages.CryptoServletMessage;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType
public abstract class BPlatCryptoBase
extends BComponent {
    @Generated
    public static final Type TYPE = Sys.loadType(BPlatCryptoBase.class);
    private final BDaemonSession session;
    protected static final Logger LOGGER = Logger.getLogger("platCrypto.daemon");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPlatCryptoBase() {
        this.session = null;
    }

    public BPlatCryptoBase(BDaemonSession newSession) {
        this.session = newSession;
    }

    public XElem send(CryptoServletMessage message) throws ConnectException, AuthenticationException {
        try {
            if ("POST".equals(message.getMethod())) {
                return this.getDaemonSession().post((DaemonMessage)message);
            }
            InputStream in = this.getDaemonSession().getInputStream((DaemonMessage)message);
            XParser parser = XParser.make((InputStream)in);
            if (parser != null) {
                return parser.parse();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "failed to send crypto servlet message '" + TextUtil.truncate((String)message.getMessageString(), (int)64) + "'", e);
        }
        return null;
    }

    public XElem[] send(CryptoServletMessage message, String elementName) throws Exception {
        XElem root;
        InputStream in = this.getDaemonSession().getInputStream((DaemonMessage)message);
        XParser parser = XParser.make((InputStream)in);
        if (parser != null && (root = parser.parse()) != null) {
            return root.elems(elementName);
        }
        return new XElem[0];
    }

    public BDaemonSession getDaemonSession() {
        return this.session;
    }
}

