/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.alarm.ui.BIAlarmServiceView;
import com.tridium.alarm.ui.ConsoleTableModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.BUuid;

public class ConsoleColumns {
    protected List<Column> columns;
    protected List<ConsoleTableModel> models = new ArrayList<ConsoleTableModel>();
    protected BIAlarmServiceView alarmServiceView;
    protected Map<AlarmClassKey, String> alarmClassDisplayNames = new HashMap<AlarmClassKey, String>();
    private boolean inited = false;
    Context cx;
    public static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BAlarmConsole.class);

    public ConsoleColumns() {
        BAlarmRecord prototype = new BAlarmRecord(BUuid.DEFAULT);
        Property[] props = prototype.getPropertiesArray();
        this.columns = new ArrayList<Column>(props.length);
        for (Property prop : props) {
            if (prop.getType() == BAbsTime.TYPE) {
                this.columns.add(new TimeColumn(prop));
                continue;
            }
            this.columns.add(new PropertyColumn(prop));
        }
    }

    public void init(BIAlarmServiceView alarmServiceView, Context cx) {
        this.alarmServiceView = alarmServiceView;
        this.cx = cx;
        this.inited = true;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Column getColumn(int index) {
        return this.columns.get(index);
    }

    public void addDataColumn(String name, String key) {
        this.columns.add(new DataColumn(name, SlotPath.escape((String)key)));
    }

    public int removeDataColumn(String key) {
        int index = this.dataColumnIndex(key);
        if (index != -1) {
            this.columns.remove(index);
        }
        return index;
    }

    public int dataColumnIndex(String key) {
        int count = this.columns.size();
        for (int i = 0; i < count; ++i) {
            Column c = this.columns.get(i);
            if (!(c instanceof DataColumn) || !((DataColumn)c).key.equals(SlotPath.escape((String)key))) continue;
            return i;
        }
        return -1;
    }

    public void addModel(ConsoleTableModel model) {
        this.models.add(model);
    }

    public void removeModel(ConsoleTableModel model) {
        this.models.remove((Object)model);
    }

    public void fireModified() {
        int count = this.models.size();
        for (int i = 0; i < count; ++i) {
            this.models.get(i).columnsModified();
        }
    }

    protected String getAlarmClassDisplayName(BAlarmRecord rec) {
        String alarmClass = rec.getAlarmClass();
        if (this.inited) {
            AlarmClassKey key;
            String displayName;
            BOrdList almSrc = rec.getSource();
            BOrd almOrd = almSrc.get(almSrc.size() - 1);
            String station = almOrd.toString();
            if (station.indexOf("|station:|") >= 0) {
                station = station.substring(0, station.indexOf("|station:|"));
            }
            if ((displayName = this.alarmClassDisplayNames.get(key = new AlarmClassKey(station, alarmClass))) == null) {
                BAlarmService alarmSvc = this.alarmServiceView.getAlarmService(rec);
                if (alarmSvc == null) {
                    displayName = alarmClass;
                } else {
                    displayName = alarmSvc.getAlarmClassDisplayName((Object)BString.make((String)alarmClass), this.cx).toString();
                    this.alarmClassDisplayNames.put(key, displayName);
                }
            }
            return displayName;
        }
        return alarmClass;
    }

    private class AlarmClassKey {
        String station;
        String alarmClass;

        public AlarmClassKey(String station, String alarmClass) {
            this.station = station;
            this.alarmClass = alarmClass;
        }

        public boolean equals(Object o) {
            if (o instanceof AlarmClassKey) {
                AlarmClassKey key = (AlarmClassKey)o;
                return key.station.equals(this.station) && key.alarmClass.equals(this.alarmClass);
            }
            return false;
        }

        public int hashCode() {
            return new String(this.station + "|" + this.alarmClass).hashCode();
        }
    }

    public class DataColumn
    extends Column {
        private String name;
        private String key;

        public DataColumn(String name, String key) {
            this.name = name;
            this.key = key;
        }

        @Override
        public String getName() {
            if (this.name == null) {
                this.name = lexicon.get("alarmData." + this.key, null);
            }
            if (this.name == null) {
                this.name = TextUtil.toFriendly((String)this.key);
            }
            return SlotPath.unescape((String)this.name);
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue(BAlarmRecord rec) {
            if (this.key.equals("sourceOrd")) {
                return rec.getSource();
            }
            return rec.getFormattedAlarmDataValue(this.key, null);
        }

        @Override
        public String getQueryName() {
            return "alarmData." + this.key;
        }
    }

    public class TimeColumn
    extends PropertyColumn {
        public TimeColumn(Property prop) {
            super(prop);
        }

        @Override
        public Object getValue(BAlarmRecord rec) {
            BAbsTime t = (BAbsTime)super.getValue(rec);
            return t;
        }
    }

    public class PropertyColumn
    extends Column {
        private Property prop;

        public PropertyColumn(Property prop) {
            this.prop = prop;
        }

        @Override
        public String getName() {
            return this.prop.getDefaultDisplayName(null);
        }

        @Override
        public Object getValue(BAlarmRecord rec) {
            return this.getValue(rec, null);
        }

        @Override
        public Object getValue(BAlarmRecord rec, Context cx) {
            if (this.prop.equals(BAlarmRecord.source)) {
                BString sourceName = (BString)rec.getAlarmData().get("sourceName");
                if (sourceName != null && sourceName != BString.DEFAULT) {
                    return BFormat.make((String)sourceName.toString(cx)).format((Object)rec);
                }
                return rec.get(this.prop);
            }
            if (this.prop.equals(BAlarmRecord.alarmClass)) {
                return ConsoleColumns.this.getAlarmClassDisplayName(rec);
            }
            return rec.get(this.prop);
        }

        @Override
        public String getQueryName() {
            return this.prop.getName();
        }
    }

    public static abstract class Column {
        public abstract String getName();

        public abstract String getQueryName();

        public abstract Object getValue(BAlarmRecord var1);

        public Object getValue(BAlarmRecord rec, Context cx) {
            return this.getValue(rec);
        }
    }
}

