/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.ui.BAlarmDbView;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.NiagaraStation;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFolder;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BRemoteStationFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BRemoteStationFE.class);
    private static UiLexicon lex = UiLexicon.makeUiLexicon(BAlarmDbView.class);
    private BTextDropDown remoteStation;
    private boolean loaded = false;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected void doSetReadonly(boolean readonly) {
        if (readonly) {
            this.setContent((BWidget)new BTextField("", 45, false));
        }
    }

    protected void doLoadValue(BObject value, Context cx) {
        if (this.loaded) {
            return;
        }
        this.init();
        BString b = (BString)value;
        if (b == null || b.isNull() || b.toString().equals("")) {
            ((BTextDropDown)this.getContent()).setText(lex.getText("stationRecipient.selectStation"));
        } else {
            ((BTextDropDown)this.getContent()).setText(b.toString());
        }
        try {
            BWbShell shell = this.getWbShell();
            OrdTarget target = shell.getActiveOrdTarget();
            BFoxSession session = (BFoxSession)BOrd.toSession((BObject)target.get());
            BOrd ord = BOrd.make((BOrd)shell.getActiveOrd(), (String)"service:niagaraDriver:NiagaraNetwork");
            BComponent niagaraNetwork = (BComponent)ord.get();
            BList list = this.remoteStation.getList();
            this.loadStations(niagaraNetwork, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loaded = true;
    }

    private void loadStations(BComponent comp, BList list) {
        comp.lease();
        BComponent[] c = comp.getChildComponents();
        for (int i = 0; i < c.length; ++i) {
            BComponent nc = c[i];
            if (nc instanceof NiagaraStation) {
                list.addItem((Object)nc.getName());
                continue;
            }
            if (!(nc instanceof BFolder)) continue;
            this.loadStations(nc, list);
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        if (this.remoteStation.getText().equals(lex.getText("stationRecipient.selectStation"))) {
            return BString.make((String)"");
        }
        return BString.make((String)this.remoteStation.getText());
    }

    private void init() {
        this.remoteStation = new BTextDropDown();
        this.setContent((BWidget)this.remoteStation);
        this.linkTo("l0", (BComponent)this.remoteStation, (Slot)BTextDropDown.valueModified, (Slot)setModified);
    }
}

