/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.rpc.BFormatRpc;
import com.tridium.rpc.FormatRpcInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.baja.alarm.BAlarmInstructions;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.fox.BFoxProxySession;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"alarm:AlarmService"})})
public class BAlarmInstructionsManager
extends BWbComponentView {
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmInstructionsManager.class);
    protected BAlarmService alarmService;
    protected Context cx;
    protected Model model;
    protected BTable table;
    protected BList instructionList;
    protected BList masterList;
    Command addCmd;
    Command removeCmd;
    Command editCmd;
    Command saveCmd;
    Command moveUpCmd;
    Command moveDownCmd;
    Command addFromMasterCmd;
    Command mAddCmd;
    Command mRemoveCmd;
    Command mEditCmd;
    Command mSaveCmd;
    Command mMoveUpCmd;
    Command mMoveDownCmd;
    public static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BAlarmInstructionsManager.class);
    private static final String SOURCE_NAME = "/sourceName";
    private static final String FORMAT_RPC_CALL = "formatRpc";

    @Generated
    public Type getType() {
        return TYPE;
    }

    private void setDisabledOnRemove(boolean isMaster) {
        if (isMaster) {
            this.mMoveUpCmd.setEnabled(false);
            this.mMoveDownCmd.setEnabled(false);
            this.mEditCmd.setEnabled(false);
            this.mRemoveCmd.setEnabled(false);
        } else {
            this.moveUpCmd.setEnabled(false);
            this.moveDownCmd.setEnabled(false);
            this.editCmd.setEnabled(false);
            this.removeCmd.setEnabled(false);
        }
    }

    public BAlarmInstructionsManager() {
        this.addCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.addMsg"){

            public CommandArtifact doInvoke() {
                String str = BDialog.prompt((BWidget)BAlarmInstructionsManager.this, (String)"Add", (String)"", (int)40);
                if (str != null) {
                    BAlarmInstructionsManager.this.instructionList.addItem((Object)BString.make((String)str));
                    BAlarmInstructionsManager.this.saveCmd.setEnabled(true);
                }
                return null;
            }
        };
        this.addCmd.setEnabled(false);
        this.removeCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.removeMsg"){

            public CommandArtifact doInvoke() {
                if (BAlarmInstructionsManager.this.instructionList.getSelection().getItemCount() > 0) {
                    BAlarmInstructionsManager.this.instructionList.removeSelectedItems();
                    BAlarmInstructionsManager.this.saveCmd.setEnabled(true);
                    BAlarmInstructionsManager.this.setDisabledOnRemove(false);
                }
                return null;
            }
        };
        this.removeCmd.setEnabled(false);
        this.editCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.editMsg"){

            public CommandArtifact doInvoke() {
                if (BAlarmInstructionsManager.this.instructionList.getSelectedItem() == null) {
                    return null;
                }
                String str = BDialog.prompt((BWidget)BAlarmInstructionsManager.this, (String)"Edit", (String)BAlarmInstructionsManager.this.instructionList.getSelectedItem().toString(), (int)40);
                if (str != null) {
                    BAlarmInstructionsManager.this.instructionList.setItem(BAlarmInstructionsManager.this.instructionList.getSelectedIndex(), (Object)BString.make((String)str));
                    BAlarmInstructionsManager.this.saveCmd.setEnabled(true);
                }
                return null;
            }
        };
        this.editCmd.setEnabled(false);
        this.moveUpCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.moveUp"){

            public CommandArtifact doInvoke() {
                int row = BAlarmInstructionsManager.this.instructionList.getSelectedIndex();
                if (row > 0) {
                    Object val = BAlarmInstructionsManager.this.instructionList.getItem(row);
                    Object swapVal = BAlarmInstructionsManager.this.instructionList.getItem(row - 1);
                    BAlarmInstructionsManager.this.instructionList.setItem(row, swapVal);
                    BAlarmInstructionsManager.this.instructionList.setItem(row - 1, val);
                    BAlarmInstructionsManager.this.instructionList.getSelection().deselectAll();
                    BAlarmInstructionsManager.this.instructionList.getSelection().select(row - 1);
                    BAlarmInstructionsManager.this.saveCmd.setEnabled(true);
                }
                return null;
            }
        };
        this.moveUpCmd.setEnabled(false);
        this.moveDownCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.moveDown"){

            public CommandArtifact doInvoke() {
                int row = BAlarmInstructionsManager.this.instructionList.getSelectedIndex();
                if (row >= 0 && row < BAlarmInstructionsManager.this.instructionList.getItemCount() - 1) {
                    Object val = BAlarmInstructionsManager.this.instructionList.getItem(row);
                    Object swapVal = BAlarmInstructionsManager.this.instructionList.getItem(row + 1);
                    BAlarmInstructionsManager.this.instructionList.setItem(row, swapVal);
                    BAlarmInstructionsManager.this.instructionList.setItem(row + 1, val);
                    BAlarmInstructionsManager.this.instructionList.getSelection().deselectAll();
                    BAlarmInstructionsManager.this.instructionList.getSelection().select(row + 1);
                    BAlarmInstructionsManager.this.saveCmd.setEnabled(true);
                }
                return null;
            }
        };
        this.moveDownCmd.setEnabled(false);
        this.saveCmd = new Command((BWidget)this, UiLexicon.bajaui().module, "commands.save"){

            public CommandArtifact doInvoke() {
                int[] rows = BAlarmInstructionsManager.this.table.getSelection().getRows();
                for (int r = 0; r < rows.length; ++r) {
                    BAlarmInstructions v = ((Controller)BAlarmInstructionsManager.this.table.getController()).getInstructions(rows[r]);
                    BFormat[] f = new BFormat[BAlarmInstructionsManager.this.instructionList.getItemCount()];
                    for (int i = 0; i < BAlarmInstructionsManager.this.instructionList.getItemCount(); ++i) {
                        f[i] = BFormat.make((String)BAlarmInstructionsManager.this.instructionList.getItem(i).toString());
                    }
                    v = BAlarmInstructions.make((BFormat[])f);
                    ((Controller)BAlarmInstructionsManager.this.table.getController()).setInstructions(rows[r], v);
                }
                BAlarmInstructionsManager.this.saveCmd.setEnabled(false);
                return null;
            }
        };
        this.saveCmd.setEnabled(false);
        this.addFromMasterCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.addFromMaster"){

            public CommandArtifact doInvoke() {
                Object[] items = BAlarmInstructionsManager.this.masterList.getSelectedItems();
                for (int i = 0; i < items.length; ++i) {
                    BAlarmInstructionsManager.this.instructionList.addItem(items[i]);
                    BAlarmInstructionsManager.this.saveCmd.setEnabled(true);
                }
                return null;
            }
        };
        this.addFromMasterCmd.setEnabled(false);
        this.mAddCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.addMsg"){

            public CommandArtifact doInvoke() {
                String str = BDialog.prompt((BWidget)BAlarmInstructionsManager.this, (String)"Add", (String)"", (int)40);
                if (str != null) {
                    BAlarmInstructionsManager.this.masterList.addItem((Object)BFormat.make((String)str));
                    BAlarmInstructionsManager.this.setModified();
                    BAlarmInstructionsManager.this.mSaveCmd.setEnabled(true);
                }
                return null;
            }
        };
        this.mRemoveCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.removeMsg"){

            public CommandArtifact doInvoke() {
                if (BAlarmInstructionsManager.this.masterList.getSelection().getItemCount() > 0) {
                    BAlarmInstructionsManager.this.masterList.removeSelectedItems();
                    BAlarmInstructionsManager.this.setModified();
                    BAlarmInstructionsManager.this.mSaveCmd.setEnabled(true);
                    BAlarmInstructionsManager.this.setDisabledOnRemove(true);
                    if (BAlarmInstructionsManager.this.masterList.getSelection().getItemCount() == 0) {
                        BAlarmInstructionsManager.this.addFromMasterCmd.setEnabled(false);
                    }
                }
                return null;
            }
        };
        this.mRemoveCmd.setEnabled(false);
        this.mEditCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.editMsg"){

            public CommandArtifact doInvoke() {
                if (BAlarmInstructionsManager.this.masterList.getSelectedItem() == null) {
                    return null;
                }
                String str = BDialog.prompt((BWidget)BAlarmInstructionsManager.this, (String)"Edit", (String)BAlarmInstructionsManager.this.masterList.getSelectedItem().toString(), (int)40);
                if (str != null) {
                    BAlarmInstructionsManager.this.masterList.setItem(BAlarmInstructionsManager.this.masterList.getSelectedIndex(), (Object)BFormat.make((String)str));
                    BAlarmInstructionsManager.this.setModified();
                    BAlarmInstructionsManager.this.mSaveCmd.setEnabled(true);
                }
                return null;
            }
        };
        this.mEditCmd.setEnabled(false);
        this.mSaveCmd = new Command((BWidget)this, UiLexicon.bajaui().module, "commands.save"){

            public CommandArtifact doInvoke() throws Exception {
                BAlarmInstructionsManager.this.saveValue();
                BAlarmInstructionsManager.this.mSaveCmd.setEnabled(false);
                return null;
            }
        };
        this.mSaveCmd.setEnabled(false);
        this.mMoveUpCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.moveUp"){

            public CommandArtifact doInvoke() {
                int row = BAlarmInstructionsManager.this.masterList.getSelectedIndex();
                if (row > 0) {
                    Object val = BAlarmInstructionsManager.this.masterList.getItem(row);
                    Object swapVal = BAlarmInstructionsManager.this.masterList.getItem(row - 1);
                    BAlarmInstructionsManager.this.masterList.setItem(row, swapVal);
                    BAlarmInstructionsManager.this.masterList.setItem(row - 1, val);
                    BAlarmInstructionsManager.this.masterList.getSelection().deselectAll();
                    BAlarmInstructionsManager.this.masterList.getSelection().select(row - 1);
                    BAlarmInstructionsManager.this.setModified();
                    BAlarmInstructionsManager.this.mSaveCmd.setEnabled(true);
                }
                return null;
            }
        };
        this.mMoveUpCmd.setEnabled(false);
        this.mMoveDownCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.moveDown"){

            public CommandArtifact doInvoke() {
                int row = BAlarmInstructionsManager.this.masterList.getSelectedIndex();
                if (row >= 0 && row < BAlarmInstructionsManager.this.masterList.getItemCount() - 1) {
                    Object val = BAlarmInstructionsManager.this.masterList.getItem(row);
                    Object swapVal = BAlarmInstructionsManager.this.masterList.getItem(row + 1);
                    BAlarmInstructionsManager.this.masterList.setItem(row, swapVal);
                    BAlarmInstructionsManager.this.masterList.setItem(row + 1, val);
                    BAlarmInstructionsManager.this.masterList.getSelection().deselectAll();
                    BAlarmInstructionsManager.this.masterList.getSelection().select(row + 1);
                    BAlarmInstructionsManager.this.setModified();
                    BAlarmInstructionsManager.this.mSaveCmd.setEnabled(true);
                }
                return null;
            }
        };
        this.mMoveDownCmd.setEnabled(false);
        BSplitPane instPane = new BSplitPane(BOrientation.vertical, 50.0);
        BEdgePane pointPane = new BEdgePane();
        this.instructionList = new BList();
        this.instructionList.setController((ListController)new InstListController());
        BGridPane pointCmds = new BGridPane(1);
        pointCmds.setColumnAlign(BHalign.fill);
        pointCmds.setValign(BValign.top);
        pointCmds.add(null, (BValue)new BButton(this.addCmd));
        pointCmds.add(null, (BValue)new BButton(this.removeCmd));
        pointCmds.add(null, (BValue)new BButton(this.editCmd));
        pointCmds.add(null, (BValue)new BButton(this.saveCmd));
        pointCmds.add(null, (BValue)new BLabel(""));
        pointCmds.add(null, (BValue)new BButton(this.moveUpCmd));
        pointCmds.add(null, (BValue)new BButton(this.moveDownCmd));
        pointPane.setCenter((BWidget)this.instructionList);
        pointPane.setRight((BWidget)pointCmds);
        BGridPane gp = new BGridPane(1);
        gp.add(null, (BValue)new BButton(this.addFromMasterCmd));
        pointPane.setBottom((BWidget)gp);
        instPane.setWidget1((BWidget)new BTitlePane("Point Instructions", (BWidget)pointPane));
        BEdgePane masterPane = new BEdgePane();
        this.masterList = new BList();
        this.masterList.setController((ListController)new MasterListController());
        BGridPane masterCmds = new BGridPane(1);
        masterCmds.setColumnAlign(BHalign.fill);
        masterCmds.setValign(BValign.top);
        masterCmds.add(null, (BValue)new BButton(this.mAddCmd));
        masterCmds.add(null, (BValue)new BButton(this.mRemoveCmd));
        masterCmds.add(null, (BValue)new BButton(this.mEditCmd));
        masterCmds.add(null, (BValue)new BButton(this.mSaveCmd));
        masterCmds.add(null, (BValue)new BButton(this.mMoveUpCmd));
        masterCmds.add(null, (BValue)new BButton(this.mMoveDownCmd));
        masterPane.setCenter((BWidget)this.masterList);
        masterPane.setRight((BWidget)masterCmds);
        instPane.setWidget2((BWidget)new BTitlePane("Master Instructions List", (BWidget)masterPane));
        this.table = new BTable();
        this.table.setController((TableController)new Controller());
        BSplitPane sp = new BSplitPane(BOrientation.horizontal, 35.0);
        sp.setWidget1((BWidget)new BTitlePane("Points", (BWidget)this.table));
        sp.setWidget2((BWidget)instPane);
        this.setContent((BWidget)new BBorderPane((BWidget)sp));
    }

    public void doLoadValue(BObject value, Context cx) {
        this.alarmService = (BAlarmService)value;
        this.cx = cx;
        this.model = new Model();
        this.table.setModel((TableModel)new DynamicTableModel((TableModel)this.model, new int[]{0, 1}));
        this.table.setController((TableController)new Controller());
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BAlarmInstructionsManager.this.enterBusy();
                try {
                    BAlarmInstructionsManager.this.alarmService.lease();
                    BAlarmInstructions inst = BAlarmInstructionsManager.this.alarmService.getMasterAlarmInstructions();
                    for (int i = 0; i < inst.size(); ++i) {
                        BAlarmInstructionsManager.this.masterList.addItem((Object)inst.get(i));
                    }
                    BObject[] crtlrs = BAlarmInstructionsManager.this.queryPoints();
                    for (int i = 0; i < crtlrs.length; ++i) {
                        try {
                            BComponent crtlr = (BComponent)crtlrs[i];
                            crtlr.lease();
                            Property[] props = crtlr.getPropertiesArray();
                            for (int j = 0; j < props.length; ++j) {
                                Property p = props[j];
                                if (p.getType().equals(BAlarmInstructions.TYPE)) {
                                    BAlarmInstructionsManager.this.model.addRow(crtlr, p);
                                    continue;
                                }
                                if (!p.getType().equals(BAlarmSourceInfo.TYPE)) continue;
                                BAlarmInstructionsManager.this.model.addRow(crtlr, p);
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    BAlarmInstructionsManager.this.exitBusy();
                    BAlarmInstructionsManager.this.table.sizeColumnsToFit();
                }
            }
        }.start();
    }

    protected BObject[] queryPoints() {
        BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd bqlOrd = BOrd.make((BOrd)authority, (String)"station:|slot:/|bql:select slotPath from alarm:IAlarmSource").normalize();
        BITable tab = (BITable)bqlOrd.resolve().get();
        Column spCol = tab.getColumns().get(0);
        ArrayList<BObject> crtlrs = new ArrayList<BObject>();
        try (TableCursor cursor = tab.cursor();){
            while (cursor.next()) {
                BOrd ord = BOrd.make((String)cursor.cell(spCol).toString());
                crtlrs.add(ord.resolve((BObject)this.alarmService).get());
            }
        }
        return crtlrs.toArray(new BObject[0]);
    }

    public BObject doSaveValue(BObject value, Context cx) {
        BAlarmService as = (BAlarmService)value;
        BFormat[] insts = new BFormat[this.masterList.getItemCount()];
        for (int i = 0; i < this.masterList.getItemCount(); ++i) {
            insts[i] = BFormat.make((String)this.masterList.getItem(i).toString());
        }
        as.setMasterAlarmInstructions(BAlarmInstructions.make((BFormat[])insts));
        return as;
    }

    private int getNumberOfPointsSelected() {
        return this.table.getSelection().getRowCount();
    }

    class MasterListController
    extends ListController {
        MasterListController() {
        }

        public void keyReleased(BKeyEvent event) {
            super.keyReleased(event);
            this.enabledCommands();
        }

        public void mouseReleased(BMouseEvent event) {
            super.mouseReleased(event);
            this.enabledCommands();
        }

        public int selectionCount() {
            return this.getList().getSelection().getItemCount();
        }

        protected void enabledCommands() {
            int selectionItemCount = this.getList().getSelection().getItemCount();
            BAlarmInstructionsManager.this.addFromMasterCmd.setEnabled(selectionItemCount > 0 && (BAlarmInstructionsManager.this.getNumberOfPointsSelected() == 1 || ((Controller)BAlarmInstructionsManager.this.table.getController()).loadIfMoreThanTwoPointsSelected()));
            if (selectionItemCount == 1) {
                BAlarmInstructionsManager.this.mRemoveCmd.setEnabled(true);
                BAlarmInstructionsManager.this.mEditCmd.setEnabled(true);
                if (this.getList().getItemCount() > 1) {
                    BAlarmInstructionsManager.this.mMoveUpCmd.setEnabled(true);
                    BAlarmInstructionsManager.this.mMoveDownCmd.setEnabled(true);
                } else {
                    BAlarmInstructionsManager.this.mMoveUpCmd.setEnabled(false);
                    BAlarmInstructionsManager.this.mMoveDownCmd.setEnabled(false);
                }
            } else if (selectionItemCount > 1) {
                BAlarmInstructionsManager.this.mMoveUpCmd.setEnabled(false);
                BAlarmInstructionsManager.this.mMoveDownCmd.setEnabled(false);
                BAlarmInstructionsManager.this.mEditCmd.setEnabled(false);
                BAlarmInstructionsManager.this.mRemoveCmd.setEnabled(true);
            } else {
                BAlarmInstructionsManager.this.addFromMasterCmd.setEnabled(false);
                BAlarmInstructionsManager.this.mRemoveCmd.setEnabled(false);
                BAlarmInstructionsManager.this.mEditCmd.setEnabled(false);
                BAlarmInstructionsManager.this.mMoveUpCmd.setEnabled(false);
                BAlarmInstructionsManager.this.mMoveDownCmd.setEnabled(false);
            }
        }
    }

    class InstListController
    extends ListController {
        InstListController() {
        }

        public void keyReleased(BKeyEvent event) {
            super.keyReleased(event);
            this.enabledCommands();
        }

        public void mouseReleased(BMouseEvent event) {
            super.mouseReleased(event);
            this.enabledCommands();
        }

        protected void enabledCommands() {
            int selectionItemCount = BAlarmInstructionsManager.this.instructionList.getSelection().getItemCount();
            if (selectionItemCount == 1) {
                BAlarmInstructionsManager.this.removeCmd.setEnabled(true);
                BAlarmInstructionsManager.this.editCmd.setEnabled(true);
                if (this.getList().getItemCount() > 1) {
                    BAlarmInstructionsManager.this.moveUpCmd.setEnabled(true);
                    BAlarmInstructionsManager.this.moveDownCmd.setEnabled(true);
                } else {
                    BAlarmInstructionsManager.this.moveUpCmd.setEnabled(false);
                    BAlarmInstructionsManager.this.moveDownCmd.setEnabled(false);
                }
            } else if (selectionItemCount > 1) {
                BAlarmInstructionsManager.this.editCmd.setEnabled(false);
                BAlarmInstructionsManager.this.moveUpCmd.setEnabled(false);
                BAlarmInstructionsManager.this.moveDownCmd.setEnabled(false);
                BAlarmInstructionsManager.this.removeCmd.setEnabled(true);
            } else {
                BAlarmInstructionsManager.this.removeCmd.setEnabled(false);
                BAlarmInstructionsManager.this.editCmd.setEnabled(false);
                BAlarmInstructionsManager.this.moveUpCmd.setEnabled(false);
                BAlarmInstructionsManager.this.moveDownCmd.setEnabled(false);
            }
        }
    }

    protected class Controller
    extends TableController {
        protected Controller() {
        }

        public void keyReleased(BKeyEvent event) {
            super.keyReleased(event);
            this.showInstructions();
        }

        public void mouseReleased(BMouseEvent event) {
            super.mouseReleased(event);
            this.showInstructions();
        }

        protected void setInstructions(int row, BAlarmInstructions inst) {
            BComponent c = BAlarmInstructionsManager.this.model.getComponent(row);
            c.lease();
            Property p = BAlarmInstructionsManager.this.model.getProperty(row);
            if (p.getType() == BAlarmInstructions.TYPE) {
                c.set(BAlarmInstructionsManager.this.model.getProperty(row), (BValue)inst);
            } else {
                BAlarmSourceInfo asi = (BAlarmSourceInfo)c.get(BAlarmInstructionsManager.this.model.getProperty(row));
                asi.lease();
                asi.setAlarmInstructions(inst);
            }
        }

        protected BAlarmInstructions getInstructions(int row) {
            BComponent c = BAlarmInstructionsManager.this.model.getComponent(row);
            c.lease();
            Property p = BAlarmInstructionsManager.this.model.getProperty(row);
            if (p.getType() == BAlarmInstructions.TYPE) {
                return (BAlarmInstructions)c.get(p);
            }
            BAlarmSourceInfo asi = (BAlarmSourceInfo)c.get(BAlarmInstructionsManager.this.model.getProperty(row));
            asi.lease();
            return asi.getAlarmInstructions();
        }

        protected void showInstructions() {
            TableSelection sel = this.getTable().getSelection();
            BAlarmInstructionsManager.this.instructionList.getSelection().deselectAll();
            int masterInstructionCount = ((MasterListController)BAlarmInstructionsManager.this.masterList.getController()).selectionCount();
            if (sel.getRowCount() == 0) {
                BAlarmInstructionsManager.this.instructionList.removeAllItems();
                BAlarmInstructionsManager.this.addCmd.setEnabled(false);
                BAlarmInstructionsManager.this.addFromMasterCmd.setEnabled(false);
            } else if (sel.getRowCount() == 1) {
                BAlarmInstructionsManager.this.addCmd.setEnabled(true);
                if (masterInstructionCount > 0) {
                    BAlarmInstructionsManager.this.addFromMasterCmd.setEnabled(true);
                }
                BAlarmInstructions inst = this.getInstructions(sel.getRow());
                BAlarmInstructionsManager.this.instructionList.removeAllItems();
                for (int i = 0; i < inst.size(); ++i) {
                    BAlarmInstructionsManager.this.instructionList.addItem((Object)inst.get(i));
                }
            } else if (sel.getRowCount() > 1) {
                int i;
                int[] rows = this.getTable().getSelection().getRows();
                BAlarmInstructionsManager.this.addCmd.setEnabled(false);
                BAlarmInstructionsManager.this.instructionList.removeAllItems();
                BAlarmInstructions test = null;
                boolean load = true;
                for (i = 0; i < rows.length; ++i) {
                    BAlarmInstructions inst = this.getInstructions(rows[i]);
                    if (test == null) {
                        test = (BAlarmInstructions)inst.newCopy();
                        continue;
                    }
                    if (test.equivalent((Object)inst)) continue;
                    load = false;
                    break;
                }
                if (load) {
                    BAlarmInstructionsManager.this.addCmd.setEnabled(true);
                    if (masterInstructionCount > 0) {
                        BAlarmInstructionsManager.this.addFromMasterCmd.setEnabled(true);
                    }
                    for (i = 0; i < test.size(); ++i) {
                        BAlarmInstructionsManager.this.instructionList.addItem((Object)test.get(i));
                    }
                } else {
                    BAlarmInstructionsManager.this.addFromMasterCmd.setEnabled(false);
                }
            } else {
                return;
            }
            ((InstListController)BAlarmInstructionsManager.this.instructionList.getController()).enabledCommands();
            BAlarmInstructionsManager.this.saveCmd.setEnabled(false);
        }

        public boolean loadIfMoreThanTwoPointsSelected() {
            int[] rows = this.getTable().getSelection().getRows();
            BAlarmInstructions test = null;
            boolean load = rows.length != 0;
            for (int i = 0; i < rows.length; ++i) {
                BAlarmInstructions inst = this.getInstructions(rows[i]);
                if (test == null) {
                    test = (BAlarmInstructions)inst.newCopy();
                    continue;
                }
                if (test.equivalent((Object)inst)) continue;
                load = false;
                break;
            }
            return load;
        }
    }

    protected class Model
    extends DefaultTableModel {
        private String[] sourceNames;

        public Model() {
            super(new String[]{"Point", "Condition", "Path"});
            this.sourceNames = null;
        }

        public BComponent getComponent(int row) {
            return (BComponent)super.getValueAt(row, 0);
        }

        public Property getProperty(int row) {
            return (Property)super.getValueAt(row, 1);
        }

        public Object getValueAt(int row, int col) {
            if (col == 2) {
                try {
                    BComponent comp = this.getComponent(row);
                    return comp.toPathString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                if (col == 1) {
                    return ((Property)super.getValueAt(row, col)).getDefaultDisplayName(BAlarmInstructionsManager.this.cx);
                }
                if (col == 0) {
                    return this.getSourceName(row);
                }
            }
            return "???";
        }

        public void addRow(BComponent crtlr, Property p) {
            BComponent comp = crtlr;
            this.addRow(new Object[]{comp, p, null});
        }

        public void updateTable() {
            super.updateTable();
            this.sourceNames = null;
        }

        public void updateTable(boolean resizeColumns) {
            super.updateTable(resizeColumns);
            this.sourceNames = null;
        }

        private String getSourceName(int row) {
            if (this.sourceNames == null) {
                this.resolveSourceNames();
            }
            return this.sourceNames[row];
        }

        private void resolveSourceNames() {
            BFoxProxySession session = (BFoxProxySession)BAlarmInstructionsManager.this.alarmService.getSession();
            ArrayList<Integer> rpcToRow = new ArrayList<Integer>();
            ArrayList<FormatRpcInfo> formatRpcInfos = new ArrayList<FormatRpcInfo>();
            this.sourceNames = new String[this.getRowCount()];
            for (int row = 0; row < this.getRowCount(); ++row) {
                BComponent comp = this.getComponent(row);
                comp.lease();
                this.sourceNames[row] = comp.getDisplayName(BAlarmInstructionsManager.this.cx);
                BComponent alarmInfoComponent = comp;
                if (comp instanceof BAlarmSourceExt) {
                    this.sourceNames[row] = ((BAlarmSourceExt)comp).getSourceName().format((Object)comp);
                } else {
                    BAlarmSourceInfo[] infos = (BAlarmSourceInfo[])comp.getChildren(BAlarmSourceInfo.class);
                    if (infos.length > 0) {
                        infos[0].lease();
                        this.sourceNames[row] = infos[0].getSourceName().format((Object)infos[0]);
                        alarmInfoComponent = infos[0];
                    }
                }
                if (session == null || !this.sourceNames[row].contains("%err:")) continue;
                BOrd componentOrd = alarmInfoComponent.getAbsoluteOrd();
                BOrd sourceNameOrd = BOrd.make((String)(alarmInfoComponent.getNavOrd() + BAlarmInstructionsManager.SOURCE_NAME));
                formatRpcInfos.add(new FormatRpcInfo(sourceNameOrd.toString(), componentOrd.toString()));
                rpcToRow.add(row);
            }
            if (session != null && !formatRpcInfos.isEmpty()) {
                try {
                    Optional rpcNames = session.rpc(BOrd.make((String)"type:baja:FormatRpc"), BAlarmInstructionsManager.FORMAT_RPC_CALL, new Object[]{formatRpcInfos});
                    if (rpcNames.isPresent()) {
                        List rpcNameList = (List)rpcNames.get();
                        for (int i = 0; i < rpcNameList.size(); ++i) {
                            if (BFormatRpc.ERROR.equals(rpcNameList.get(i))) continue;
                            this.sourceNames[((Integer)rpcToRow.get((int)i)).intValue()] = (String)rpcNameList.get(i);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

