/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.ui.AlarmDbTableModel;
import com.tridium.alarm.ui.BAlarmConsoleOptions;
import com.tridium.alarm.ui.BAlarmDetailsDialog;
import com.tridium.alarm.ui.BIAlarmServiceView;
import com.tridium.alarm.ui.BNotesDialog;
import com.tridium.alarm.ui.BTimeZoneDisplay;
import com.tridium.alarm.ui.ConsoleColumns;
import com.tridium.alarm.ui.ConsoleTableModel;
import com.tridium.bql.filter.BAbsTimeFilter;
import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.workbench.bql.filter.BFilterSetEditor;
import com.tridium.workbench.fieldeditors.BDynamicTimeRangeFE;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BArchiveAlarmProvider;
import javax.baja.bql.BIBqlFilter;
import javax.baja.bql.BqlQuery;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataValue;
import javax.baja.file.types.text.BPxFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BUuid;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"alarm:AlarmService", "alarm:AlarmDatabase", "alarm:ArchiveAlarmProvider"}, requiredPermissions="r")})
@NiagaraProperties(value={@NiagaraProperty(name="defaultTimeRange", type="BDynamicTimeRange", defaultValue="BDynamicTimeRange.DEFAULT"), @NiagaraProperty(name="timeZoneDisplay", type="BTimeZoneDisplay", defaultValue="BTimeZoneDisplay.console")})
@NiagaraAction(name="query", flags=16)
public class BAlarmDbView
extends BWbComponentView
implements BIAlarmServiceView {
    @Generated
    public static final Property defaultTimeRange = BAlarmDbView.newProperty((int)0, (BValue)BDynamicTimeRange.DEFAULT, null);
    @Generated
    public static final Property timeZoneDisplay = BAlarmDbView.newProperty((int)0, (BValue)BTimeZoneDisplay.console, null);
    @Generated
    public static final Action query = BAlarmDbView.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmDbView.class);
    private static UiLexicon lex = UiLexicon.makeUiLexicon(BAlarmDbView.class);
    public static final BFacets TIME_FACETS = BFacets.make((String)"showSeconds", (boolean)true);
    BTable table;
    AlarmDbTableModel model;
    BAlarmDatabase alarmDb;
    BAlarmService alarmService;
    Context context;
    private BFilterSet filterSet;
    private BDynamicTimeRangeFE timeRangeEd;
    private Command filterCmd;
    private Command notesCmd;
    private Command tzCmd;
    private Command addColumnCommand;
    private Command removeColumnCommand;

    @Generated
    public BDynamicTimeRange getDefaultTimeRange() {
        return (BDynamicTimeRange)this.get(defaultTimeRange);
    }

    @Generated
    public void setDefaultTimeRange(BDynamicTimeRange v) {
        this.set(defaultTimeRange, (BValue)v, null);
    }

    @Generated
    public BTimeZoneDisplay getTimeZoneDisplay() {
        return (BTimeZoneDisplay)this.get(timeZoneDisplay);
    }

    @Generated
    public void setTimeZoneDisplay(BTimeZoneDisplay v) {
        this.set(timeZoneDisplay, (BValue)v, null);
    }

    @Generated
    public void query() {
        this.invoke(query, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public ConsoleColumns getConsoleColumns() {
        BString[] dataCols;
        if (this.model != null) {
            return this.model.getColumns();
        }
        ConsoleColumns columns = new ConsoleColumns();
        for (BString dataCol : dataCols = (BString[])BAlarmConsoleOptions.getDefault().getAlarmDataCols().getChildren(BString.class)) {
            columns.addDataColumn(null, dataCol.toString());
        }
        return columns;
    }

    public int[] getDefaultColumns() {
        String str = BAlarmConsoleOptions.getDefault().getDisplayColumns();
        StringTokenizer tok = new StringTokenizer(str, ",");
        Array arr = new Array(Integer.class);
        while (tok.hasMoreTokens()) {
            String st = tok.nextToken();
            arr.add((Object)Integer.valueOf(st));
        }
        int[] cols = new int[arr.size()];
        for (int i = 0; i < arr.size(); ++i) {
            cols[i] = (Integer)arr.get(i);
        }
        return cols;
    }

    public int getSortColumn() {
        return BAlarmConsoleOptions.getDefault().getSortColumn();
    }

    public boolean getSortDirection() {
        return BAlarmConsoleOptions.getDefault().getSortAscending();
    }

    public BTable getTable() {
        return this.table;
    }

    @Override
    public BAlarmService getAlarmService(BAlarmRecord rec) {
        return this.alarmService;
    }

    public void doLoadValue(BObject value, Context cx) {
        this.filterSet = this.buildFilterSet();
        if (value instanceof BAlarmService) {
            this.alarmService = (BAlarmService)value;
            this.alarmDb = (BAlarmDatabase)BOrd.make((BOrd)this.alarmService.getAbsoluteOrd(), (BOrd)BOrd.make((String)"alarm:")).get();
        } else if (value instanceof BAlarmDatabase) {
            this.alarmDb = (BAlarmDatabase)value;
            this.alarmService = this.getAlarmService();
        } else if (value instanceof BArchiveAlarmProvider) {
            this.alarmService = this.getAlarmService();
            try {
                this.alarmDb = (BAlarmDatabase)BOrd.make((String)"alarm:archive").get((BObject)this.alarmService);
            }
            catch (UnresolvedException e) {
                BStatus providerStatus = ((BArchiveAlarmProvider)value).getStatus();
                throw new LocalizableRuntimeException("alarm", "alarmArchive.notFound", new Object[]{providerStatus.toString(cx)}, (Throwable)e);
            }
        }
        this.context = cx;
        this.model = new AlarmDbTableModel(this.getConsoleColumns());
        this.model.init(this, cx);
        this.table = new BTable((TableModel)new DynamicTableModel((TableModel)this.model, this.getDefaultColumns()), (TableController)new Controller());
        this.table.setMultipleSelection(false);
        this.model.options.setTimeZoneDisplay(this.getTimeZoneDisplay());
        this.filterCmd = new Command((BWidget)this, BAlarmDbView.lex.module, "commands.filter"){

            public CommandArtifact doInvoke() {
                BAlarmDbView.this.configFilters();
                BAlarmDbView.this.query();
                return null;
            }
        };
        this.notesCmd = new Command((BWidget)this, BAlarmDbView.lex.module, "commands.notes"){

            public CommandArtifact doInvoke() {
                int row = BAlarmDbView.this.table.getSelection().getRow();
                if (row != -1) {
                    BAlarmRecord rec = BAlarmDbView.this.model.getRecord(row);
                    BAlarmDbView.this.showNotes(rec);
                }
                return null;
            }
        };
        this.tzCmd = new Command((BWidget)this, BAlarmDbView.lex.module, "commands.timeZoneDisplay"){

            public CommandArtifact doInvoke() {
                BFrozenEnumFE tzEd = new BFrozenEnumFE();
                tzEd.loadValue((BObject)BAlarmDbView.this.getTimeZoneDisplay());
                int retVal = BDialog.open((BWidget)BAlarmDbView.this, (String)lex.getText("commands.timeZoneDisplay.label"), (Object)tzEd, (int)3);
                if (retVal == 2) {
                    return null;
                }
                try {
                    BTimeZoneDisplay tz = (BTimeZoneDisplay)tzEd.saveValue();
                    BAlarmDbView.this.setTimeZoneDisplay(tz);
                    BAlarmDbView.this.model.options.setTimeZoneDisplay(tz);
                    BAlarmDbView.this.model.options.save();
                    BAlarmDbView.this.repaint();
                }
                catch (Exception e) {
                    BDialog.error((BWidget)BAlarmDbView.this, (String)"Cannot Save", (Object)e.getMessage(), (Throwable)e);
                }
                return null;
            }
        };
        this.addColumnCommand = new Command((BWidget)this, BAlarmDbView.lex.module, "commands.addColumn"){

            public CommandArtifact doInvoke() {
                BGridPane pane = new BGridPane(2);
                pane.add("lbl", (BValue)new BLabel("AlarmData."));
                BTextField tf = new BTextField("");
                pane.add("tf", (BValue)tf);
                int retVal = BDialog.open((BWidget)BAlarmDbView.this, (String)lex.getText("commands.addColumn.label"), (Object)pane, (int)3, null);
                if (retVal == 1) {
                    try {
                        BAlarmDbView.this.getConsoleColumns().addDataColumn(null, tf.getText());
                        for (int i = 0; i < 2; ++i) {
                            DynamicTableModel tm = (DynamicTableModel)BAlarmDbView.this.table.getModel();
                            tm.setColumnShowable(BAlarmDbView.this.getConsoleColumns().getColumnCount() - 1, true);
                            tm.setShowColumn(BAlarmDbView.this.getConsoleColumns().getColumnCount() - 1, true);
                            tm.updateTable();
                        }
                        BAlarmDbView.this.model.options.getAlarmDataCols().add(SlotPath.escape((String)tf.getText()), (BValue)BString.make((String)tf.getText()));
                        BAlarmDbView.this.model.options.save();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        };
        this.removeColumnCommand = new Command((BWidget)this, BAlarmDbView.lex.module, "commands.removeColumn"){

            public CommandArtifact doInvoke() {
                BString[] addCols;
                BGridPane pane = new BGridPane(2);
                pane.add("lbl", (BValue)new BLabel("AlarmData."));
                ArrayList<String> arr = new ArrayList<String>();
                for (BString addCol : addCols = (BString[])BAlarmDbView.this.model.options.getAlarmDataCols().getChildren(BString.class)) {
                    arr.add(addCol.toString());
                }
                BTextDropDown tf = new BTextDropDown(arr, 20, false);
                pane.add("tf", (BValue)tf);
                int retVal = BDialog.open((BWidget)BAlarmDbView.this, (String)lex.getText("commands.removeColumn.label"), (Object)pane, (int)3, null);
                if (retVal == 1) {
                    String removeKey = tf.getText();
                    int rootIndex = BAlarmDbView.this.getConsoleColumns().dataColumnIndex(removeKey);
                    if (rootIndex == -1) {
                        return null;
                    }
                    for (int t = 0; t < 2; ++t) {
                        int i;
                        DynamicTableModel tm = (DynamicTableModel)BAlarmDbView.this.table.getModel();
                        boolean[] showing = new boolean[BAlarmDbView.this.getConsoleColumns().getColumnCount()];
                        for (i = 0; i < showing.length; ++i) {
                            showing[i] = tm.showColumn(i);
                        }
                        for (i = rootIndex; i < showing.length - 1; ++i) {
                            showing[i] = showing[i + 1];
                        }
                        showing[showing.length - 1] = false;
                        for (i = 0; i < showing.length; ++i) {
                            tm.setShowColumn(i, showing[i]);
                        }
                    }
                    BAlarmDbView.this.getConsoleColumns().removeDataColumn(removeKey);
                    BAlarmDbView.this.model.options.getAlarmDataCols().remove(SlotPath.escape((String)tf.getText()));
                    BAlarmDbView.this.model.options.save();
                    BAlarmDbView.this.model.updateTable();
                }
                return null;
            }
        };
        BGridPane queryPane = new BGridPane(3);
        queryPane.setHalign(BHalign.left);
        this.timeRangeEd = new BDynamicTimeRangeFE();
        this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.TODAY);
        queryPane.add("timeRangeQuery", (BValue)this.timeRangeEd);
        BDynamicTimeRange defRange = this.getDefaultTimeRange();
        if (!defRange.equals((Object)BDynamicTimeRange.DEFAULT)) {
            this.timeRangeEd.loadValue((BObject)defRange, cx);
        }
        this.linkTo("rangeLink", (BComponent)this.timeRangeEd, (Slot)BWbFieldEditor.setModified, (Slot)query);
        BEdgePane pane = new BEdgePane();
        pane.setTop((BWidget)new BBorderPane((BWidget)queryPane));
        pane.setCenter((BWidget)BTitlePane.makePane((String)lex.getText("alarm.alarmHistory"), (BTable)this.table, (String)lex.getText("alarm.alarms")));
        this.setContent((BWidget)pane);
        if (this.onPxPage(cx)) {
            this.doQuery();
        } else {
            this.query();
        }
    }

    private boolean onPxPage(Context cx) {
        OrdTarget target;
        BObject obj;
        return cx != null && cx.getBase() != null && (obj = (target = (OrdTarget)cx.getBase().getBase()).get()) instanceof BPxFile;
    }

    public BToolBar getViewToolBar() {
        BToolBar tb = new BToolBar();
        tb.addButton("filter", this.filterCmd);
        tb.addButton("notes", this.notesCmd);
        tb.addButton("timezone", this.tzCmd);
        return tb;
    }

    public void stopped() throws Exception {
        super.stopped();
        DynamicTableModel dtm = (DynamicTableModel)this.table.getModel();
        StringBuilder colStr = new StringBuilder();
        for (int i = 0; i < dtm.getRootColumnCount(); ++i) {
            if (!dtm.showColumn(i)) continue;
            colStr.append(i + ",");
        }
        if (dtm.getRootColumnCount() > 0) {
            this.model.options.setDisplayColumns(colStr.toString());
        }
        this.model.options.setSortColumn(this.model.getLastSortColumn());
        this.model.options.setSortAscending(this.model.getLastSortAscending());
        if (this.model != null) {
            this.model.options.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doQuery() {
        this.enterBusy();
        try {
            block29: {
                StringBuilder ordText = new StringBuilder("select * ");
                if (this.filterSet != null) {
                    BDynamicTimeRange timeRange;
                    StringBuilder predicate = new StringBuilder(64);
                    String filterQual = this.filterSet.getPredicate();
                    if (filterQual != null && filterQual.length() > 0) {
                        if (predicate.length() != 0) {
                            predicate.append(" and ");
                        }
                        predicate.append(filterQual);
                    }
                    if (!(timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue()).equals((Object)BDynamicTimeRange.DEFAULT)) {
                        BAbsTimeFilter timeFilter = new BAbsTimeFilter();
                        timeFilter.initFromDynamicTimeRange(timeRange);
                        String timeRangePredicate = timeFilter.getPredicate(BAlarmRecord.timestamp.getName());
                        if (predicate.length() != 0) {
                            predicate.append(" and ");
                        }
                        predicate.append(timeRangePredicate.toString());
                    }
                    if (predicate.length() != 0) {
                        ordText.append(" where ").append(predicate.toString());
                    }
                }
                try (AlarmDbConnection conn = this.alarmDb.getDbConnection(null);){
                    Cursor recs;
                    try {
                        recs = conn.doBqlQuery(BqlQuery.make((String)ordText.toString()));
                    }
                    catch (Exception e) {
                        BOrd ord = BOrd.make((BOrd)((BWbShell)this.getShell()).getActiveOrd(), (BOrd)BOrd.make((BOrd)this.alarmDb.getOrdInSession(), (String)("bql:" + ordText.toString())));
                        BITable result = (BITable)ord.resolve(this.getCurrentValue()).get();
                        recs = result.cursor();
                    }
                    this.model.clear();
                    if (recs == null) break block29;
                    try {
                        while (recs.next()) {
                            BAlarmRecord record = (BAlarmRecord)((BAlarmRecord)recs.get()).newCopy();
                            if (!this.filterSet.accept((BComplex)record)) continue;
                            this.model.add(record);
                        }
                    }
                    finally {
                        recs.close();
                    }
                }
            }
            this.model.sortByColumn(this.getSortColumn(), this.getSortDirection());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.exitBusy();
            this.table.sizeColumnsToFit();
        }
        this.table.fireTableModified(null);
    }

    public BAlarmService getAlarmService() {
        if (this.alarmService == null) {
            BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
            try {
                BOrd serviceOrd = BOrd.make((BOrd)authority, (String)"service:alarm:AlarmService");
                this.alarmService = (BAlarmService)serviceOrd.resolve().get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.alarmService;
    }

    public void configFilters() {
        BFilterSetEditor setEditor = new BFilterSetEditor();
        setEditor.loadValue((BObject)this.filterSet);
        BBorderPane borderPane = new BBorderPane((BWidget)setEditor);
        if (BDialog.open((BWidget)this, (String)"Filters", (Object)borderPane, (int)3) != 2) {
            try {
                if (setEditor.isModified()) {
                    this.filterSet = (BFilterSet)setEditor.saveValue();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private BFilterSet buildFilterSet() {
        BAlarmRecord rec = new BAlarmRecord(BUuid.DEFAULT);
        BFilterSet set = new BFilterSet();
        Property[] props = rec.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            BValue value;
            AgentList agents;
            if (props[i].equals(BAlarmRecord.timestamp) || (agents = (value = rec.get(props[i])).getAgents().filter(AgentFilter.is((Type)BIBqlFilter.TYPE))).size() == 0) continue;
            BIBqlFilter filter = (BIBqlFilter)agents.getDefault().getInstance();
            filter.init((BObject)value);
            BFilterEntry entry = new BFilterEntry(false, props[i].getDefaultDisplayName(this.getCurrentContext()), filter);
            set.add(props[i].getName(), (BValue)entry, 0, rec.getSlotFacets((Slot)props[i]), null);
        }
        return set;
    }

    public void showDetailsDialog(BAlarmRecord alarm) {
        BAlarmDetailsDialog detailsDlg = new BAlarmDetailsDialog((BWidget)this, this.getAlarmService(), this.getTimeZoneDisplay(), alarm, (ConsoleTableModel)((DynamicTableModel)this.table.getModel()).getRootModel(), this.context, this.getUsername(alarm), this.alarmDb.getDbConnection(null));
        detailsDlg.setBoundsCenteredOnOwner();
        detailsDlg.open();
    }

    public void showNotes(BAlarmRecord record) {
        String notes = "";
        try {
            notes = ((BString)record.getAlarmData().getFacet("notes")).getString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        BNotesDialog dlg = new BNotesDialog((BWidget)this, notes, this.getUsername(record), true);
        dlg.setBoundsCenteredOnOwner();
        dlg.open();
        String newText = dlg.getNewNotes();
        if (newText != null) {
            String[] keys;
            notes = newText + notes;
            BFacets alarmData = record.getAlarmData();
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : keys = alarmData.list()) {
                if (key.equals("notes")) continue;
                BIDataValue value = (BIDataValue)alarmData.get(key);
                map.put(key, value);
            }
            map.put("notes", BString.make((String)notes));
            BFacets f = BFacets.make(map);
            record.setAlarmData(f);
            try (AlarmDbConnection conn = this.alarmDb.getDbConnection(null);){
                conn.update(record);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected String getUsername(BAlarmRecord alarm) {
        BFoxSession session = (BFoxSession)this.getCurrentValueSession();
        BFoxClientConnection conn = session.getConnection();
        return conn.getFoxSession().getUsername();
    }

    public BDynamicTimeRange getRange() throws Exception {
        return (BDynamicTimeRange)this.timeRangeEd.saveValue();
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void cellReleased(BMouseEvent event, int row, int column) {
            super.cellReleased(event, row, column);
            if (event.getClickCount() == 2) {
                BAlarmDbView.this.showDetailsDialog(BAlarmDbView.this.model.getRecord(row));
            }
        }

        public BMenu makeOptionsMenu() {
            BMenu menu = super.makeOptionsMenu();
            menu.add("acSep", (BValue)new BSeparator());
            menu.add("addColumn", BAlarmDbView.this.addColumnCommand);
            menu.add("removeColumn", BAlarmDbView.this.removeColumnCommand);
            return menu;
        }
    }
}

