/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.bql.filter.ColumnNameTableModel;
import com.tridium.workbench.util.CollectionTableModel;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Tables;
import javax.baja.gx.BBrush;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"alarm:AlarmService"})})
@NiagaraAction(name="updateCommands", flags=4)
public class BAlarmClassSummary
extends BWbComponentView {
    @Generated
    public static final Action updateCommands = BAlarmClassSummary.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmClassSummary.class);
    private static final String[] ATTRS = new String[]{"displayName", "totalAlarmCount", "openAlarmCount", "inAlarmCount", "unackedAlarmCount", "timeOfLastAlarm", "ackRequired", "priority", "toPathString"};
    private static final int[] DISPLAY = new int[]{0, 1, 2, 3, 4, 5};
    private static Lexicon lex = Lexicon.make((String)"alarm");
    private BTable table = new BTable();
    private BIRandomAccessTable<? extends BIObject> itable;
    private CollectionTableModel collectionModel;
    private ToggleCommand enableToOffnormal;
    private ToggleCommand enableToFault;
    private Command editAlarmClass;
    private IntHashMap nameMap;

    @Generated
    public void updateCommands() {
        this.invoke(updateCommands, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAlarmClassSummary() {
        this.table.setController((TableController)new Controller());
        this.table.setCellRenderer((TableCellRenderer)new CellRenderer());
        this.setContent((BWidget)BTitlePane.makePane((String)TYPE.getDisplayName(null), (BTable)this.table, (String)lex.getText("alarm.alarmClasses")));
        this.add("selectionLink", (BValue)new BLink((BComponent)this.table, (Slot)BTable.selectionModified, (Slot)updateCommands));
        this.nameMap = new IntHashMap();
        this.nameMap.put(0, (Object)"alarmClass.name");
        this.nameMap.put(1, (Object)"alarmClass.totalAlarmCount");
        this.nameMap.put(2, (Object)"alarmClass.openAlarmCount");
        this.nameMap.put(3, (Object)"alarmClass.inAlarmCount");
        this.nameMap.put(4, (Object)"alarmClass.unackedAlarmCount");
        this.nameMap.put(5, (Object)"alarmClass.timeOfLastAlarm");
        this.nameMap.put(6, (Object)"alarmClass.ackRequired");
        this.nameMap.put(7, (Object)"alarmClass.priority");
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.updateTable();
        this.table.fireTableModified(null);
    }

    private void updateTable() {
        BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd bqlOrd = BOrd.make((BOrd)authority, (String)this.query()).normalize();
        this.itable = Tables.slurp((BITable)((BITable)bqlOrd.resolve().get()));
        boolean prevSorted = false;
        int sortCol = -1;
        boolean sortAsc = true;
        if (this.table.getModel() instanceof AlarmClassSummaryTableModel) {
            prevSorted = true;
            sortCol = ((AlarmClassSummaryTableModel)this.table.getModel()).sortCol;
            sortAsc = ((AlarmClassSummaryTableModel)this.table.getModel()).sortAsc;
        }
        this.collectionModel = new CollectionTableModel(this.itable, this.getCurrentContext());
        ColumnNameTableModel renameModel = new ColumnNameTableModel((TableModel)this.collectionModel, this.nameMap, lex);
        AlarmClassSummaryTableModel hideModel = new AlarmClassSummaryTableModel((TableModel)renameModel, DISPLAY);
        hideModel.setColumnShowable(1, false);
        hideModel.setColumnShowable(6, false);
        if (prevSorted && sortCol != -1) {
            hideModel.sortByColumn(sortCol, sortAsc);
        }
        this.table.setModel((TableModel)hideModel);
        this.table.relayout();
    }

    private String query() {
        StringBuilder s = new StringBuilder(128);
        s.append("station:|slot:/|bql:select ");
        for (int i = 0; i < ATTRS.length; ++i) {
            if (i != 0) {
                s.append(", ");
            }
            s.append(ATTRS[i]);
        }
        s.append(" from alarm:AlarmClass");
        return s.toString();
    }

    public void doUpdateCommands() {
    }

    private class CellRenderer
    extends TableCellRenderer {
        private CellRenderer() {
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            if (cell.row == this.getTable().getModel().getRowCount() - 2) {
                return Theme.table().getGridBrush();
            }
            return null;
        }
    }

    public class AlarmClassSummaryTableModel
    extends DynamicTableModel {
        public int sortCol;
        public boolean sortAsc;

        public AlarmClassSummaryTableModel(TableModel root, int[] showColumns) {
            super(root, showColumns);
            this.sortCol = -1;
            this.sortAsc = true;
        }

        public AlarmClassSummaryTableModel(TableModel root) {
            super(root);
            this.sortCol = -1;
            this.sortAsc = true;
        }

        public void sortByColumn(int col, boolean ascending) {
            this.sortCol = col;
            this.sortAsc = ascending;
            super.sortByColumn(col, ascending);
        }

        public Object getValueAt(int row, int col) {
            if (row < super.getRowCount()) {
                return super.getValueAt(row, col);
            }
            if (row == super.getRowCount()) {
                return "";
            }
            switch (col) {
                case 0: {
                    return lex.getText("alarmClass.total");
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    int total = 0;
                    for (int i = 0; i < super.getRowCount(); ++i) {
                        total += Integer.parseInt((String)this.getValueAt(i, col));
                    }
                    return "" + total;
                }
            }
            return "";
        }

        public int getRowCount() {
            return super.getRowCount() + 2;
        }
    }

    public class GotoPoint
    extends Goto {
        public GotoPoint(int row, BITable<? extends BIObject> itable) {
            super("alarmClass.goto.alarmClass", row, itable);
        }

        @Override
        public BOrd getTargetOrd() {
            return BOrd.make((String)("slot:" + BAlarmClassSummary.this.itable.get(this.row).cell(BAlarmClassSummary.this.itable.getColumns().get("toPathString")).toString()));
        }
    }

    public abstract class Goto
    extends Command {
        int row;
        BITable<? extends BIObject> itable;

        public Goto(String key, int row, BITable<? extends BIObject> itable) {
            super((BWidget)BAlarmClassSummary.this, Sys.getModuleForClass(BAlarmClassSummary.class), key);
            this.row = row;
            this.itable = itable;
        }

        public abstract BOrd getTargetOrd();

        public CommandArtifact doInvoke() {
            BOrd targetOrd = this.getTargetOrd();
            if (targetOrd == null) {
                return null;
            }
            BOrd authority = ((BWbShell)BAlarmClassSummary.this.getShell()).getActiveOrd();
            BOrd hyperlinkOrd = BOrd.make((BOrd)authority, (BOrd)targetOrd).normalize();
            ((BWbShell)this.getShell()).hyperlink(hyperlinkOrd);
            return null;
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            if (row >= this.getTable().getModel().getRowCount() - 2) {
                return;
            }
            ColumnList columns = BAlarmClassSummary.this.itable.getColumns();
            BOrd targetOrd = null;
            String path = BAlarmClassSummary.this.itable.get(row).cell(columns.get("toPathString")).toString();
            BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
            targetOrd = BOrd.make((BOrd)authority, (String)("slot:" + path)).normalize();
            if (targetOrd != null) {
                ((BWbShell)this.getShell()).hyperlink(targetOrd);
            }
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            if (row >= this.getTable().getModel().getRowCount() - 2) {
                return;
            }
            ColumnList columns = BAlarmClassSummary.this.itable.getColumns();
            String path = BAlarmClassSummary.this.itable.get(row).cell(columns.get("toPathString")).toString();
            BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
            BOrd targetOrd = BOrd.make((BOrd)authority, (String)("slot:" + path)).normalize();
            BComponent target = (BComponent)targetOrd.get();
            BMenu menu = new BMenu();
            menu.add(null, (Command)new GotoPoint(row, (BITable<? extends BIObject>)BAlarmClassSummary.this.itable));
            menu.open((BWidget)this.getTable(), event.getX(), event.getY());
        }
    }
}

