/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.gx.ISize;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BSize
extends BSimple
implements ISize {
    public static final BSize DEFAULT = new BSize(0.0, 0.0);
    public static final BSize NULL = new BSize(0.0, 0.0);
    public static final Type TYPE = Sys.loadType(BSize.class);
    public final double width;
    public final double height;

    public static BSize make(double width, double height) {
        return new BSize(width, height);
    }

    public static BSize make(ISize d) {
        if (d instanceof BSize) {
            return (BSize)d;
        }
        return BSize.make(d.width(), d.height());
    }

    private BSize(double width, double height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public double width() {
        return this.width;
    }

    @Override
    public double height() {
        return this.height;
    }

    public boolean isNull() {
        return this == NULL;
    }

    public int hashCode() {
        long hash = 23L + Double.doubleToRawLongBits(this.width);
        hash = hash * 37L + Double.doubleToRawLongBits(this.height);
        return (int)(hash >>> 32) ^ (int)hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BSize) {
            BSize r = (BSize)obj;
            return this.width == r.width && this.height == r.height;
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() throws IOException {
        if (this.isNull()) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.width).append(',').append(this.height);
        return sb.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        if (s.equals("null")) {
            return NULL;
        }
        int c = s.indexOf(44);
        return BSize.make(BDouble.decode((String)s.substring(0, c)), BDouble.decode((String)s.substring(c + 1)));
    }

    public Type getType() {
        return TYPE;
    }
}

