/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.parser;

import com.tridium.gx.parser.ParseException;
import com.tridium.gx.parser.Token;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BDouble;

public class Tokenizer {
    static final byte[] ctypes;
    static final int IDCHAR = 1;
    static final int IDSTART = 3;
    static final int NUMBER = 4;
    static final int HEX = 8;
    static final int SPACE = 16;
    private String buf;
    private int pos;
    private int len;
    private int cur;
    private int curType;
    private int peek;
    private int peekType;
    private boolean pathGeom;

    public Tokenizer(String buf, boolean pathGeom) {
        this.pathGeom = pathGeom;
        this.initRead(buf, 0);
    }

    public Token next(Token token) {
        token.pos = this.pos - 1;
        while (true) {
            if (this.cur < 0) {
                return token.set(22);
            }
            if ((this.curType & 0x10) == 0) break;
            this.read();
        }
        boolean negative = false;
        if (this.cur == 45 && (this.peekType & 4) != 0) {
            this.read();
            negative = true;
        }
        if ((this.curType & 4) != 0) {
            return this.parseNumber(token, negative);
        }
        if ((this.curType & 3) != 0) {
            return this.parseId(token);
        }
        if (this.cur == 35) {
            return this.parseHash(token);
        }
        if (this.cur == 34 || this.cur == 39) {
            return this.parseString(token);
        }
        return this.parseSymbol(token);
    }

    Token parseId(Token token) {
        if (this.pathGeom) {
            token.set(21);
            token.pathcmd = this.cur;
            this.read();
            return token;
        }
        token.set(15);
        token.str = this.parseIdStr();
        if (this.cur == 40) {
            this.read();
            token.type = 18;
        }
        return token;
    }

    Token parseHash(Token token) {
        token.set(17);
        this.read();
        token.str = (this.curType & 1) != 0 ? this.parseIdStr() : "";
        return token;
    }

    String parseIdStr() {
        StringBuilder buf = new StringBuilder(32);
        do {
            buf.append(TextUtil.toLowerCase((char)((char)this.cur)));
            this.read();
        } while ((this.curType & 1) != 0);
        return buf.toString();
    }

    Token parseNumber(Token token, boolean negative) {
        token.set(19);
        StringBuilder buf = new StringBuilder(32);
        buf.append((char)this.cur);
        while (true) {
            this.read();
            if (this.cur != 46 && (this.curType & 4) == 0) {
                if (this.cur != 101 && this.cur != 69) break;
                buf.append((char)this.cur);
                this.parseExponent(buf);
                break;
            }
            buf.append((char)this.cur);
        }
        double num = BDouble.decode((String)buf.toString());
        if (negative) {
            num = -num;
        }
        token.num = num;
        if (this.pathGeom) {
            return token;
        }
        if (this.cur == 37) {
            this.read();
            token.type = 20;
            token.str = "%";
        } else if ((this.curType & 3) != 0) {
            token.type = 20;
            token.str = this.parseIdStr();
        }
        return token;
    }

    private void parseExponent(StringBuilder buf) {
        if (this.peek == 43 || this.peek == 45) {
            this.read();
            buf.append((char)this.cur);
        }
        if ((this.peekType & 4) == 0) {
            this.error("exponent " + (char)this.cur);
        }
        this.read();
        while ((this.curType & 4) != 0) {
            buf.append((char)this.cur);
            this.read();
        }
    }

    Token parseString(Token token) {
        StringBuilder buf;
        block3: {
            token.set(16);
            int delimeter = this.cur;
            if (delimeter != 34 && delimeter != 39) {
                throw this.error("string " + (char)delimeter);
            }
            this.read();
            buf = new StringBuilder(32);
            while (true) {
                int c = this.cur;
                if (this.cur == delimeter) break block3;
                if (this.cur == 92) {
                    this.unescape(buf);
                    continue;
                }
                buf.append((char)c);
                this.read();
                if (this.cur == -1) break;
            }
            throw this.error("String literal not terminated");
        }
        this.read();
        token.str = buf.toString();
        return token;
    }

    void unescape(StringBuilder buf) {
        if (this.cur != 92) {
            throw this.error("IllegalState");
        }
        this.read();
        if (this.cur == 110) {
            this.read();
            buf.append('\n');
            return;
        }
        if (this.cur == 39) {
            this.read();
            buf.append('\'');
            return;
        }
        if (this.cur == 34) {
            this.read();
            buf.append('\"');
            return;
        }
        if ((this.curType & 8) == 0) {
            throw this.error("Invalid escape sequence");
        }
        int hex = 0;
        while (true) {
            if (this.cur == 59) break;
            if ((this.curType & 8) == 0) {
                throw this.error("Unterminated escape sequence");
            }
            hex = hex << 4 | TextUtil.hexCharToInt((char)((char)this.cur));
            this.read();
        }
        this.read();
        buf.append((char)hex);
    }

    Token parseSymbol(Token token) {
        int c = this.cur;
        this.read();
        switch (c) {
            case 46: {
                return token.set(1);
            }
            case 44: {
                return token.set(2);
            }
            case 59: {
                return token.set(3);
            }
            case 58: {
                return token.set(4);
            }
            case 40: {
                return token.set(7);
            }
            case 41: {
                return token.set(8);
            }
            case 123: {
                return token.set(5);
            }
            case 125: {
                return token.set(6);
            }
            case 91: {
                return token.set(9);
            }
            case 93: {
                return token.set(10);
            }
            case 47: {
                return token.set(11);
            }
            case 42: {
                return token.set(12);
            }
            case 43: {
                return token.set(13);
            }
            case 61: {
                return token.set(14);
            }
            case 35: {
                return token.set(17);
            }
        }
        token.set(0);
        token.str = String.valueOf((char)c);
        return token;
    }

    ParseException error(String msg) {
        return new ParseException(msg);
    }

    void initRead(String buf, int p) {
        this.buf = buf;
        this.pos = p;
        this.len = buf.length();
        try {
            this.cur = buf.charAt(this.pos++);
        }
        catch (Exception e) {
            this.cur = -1;
        }
        this.curType = Tokenizer.ctype(this.cur);
        try {
            this.peek = buf.charAt(this.pos++);
        }
        catch (Exception e) {
            this.peek = -1;
        }
        this.peekType = Tokenizer.ctype(this.peek);
    }

    char charAt(int pos) {
        return this.buf.charAt(pos);
    }

    void read() {
        this.cur = this.peek;
        this.curType = this.peekType;
        this.peek = this.pos >= this.len ? -1 : (int)this.buf.charAt(this.pos++);
        this.peekType = Tokenizer.ctype(this.peek);
    }

    String eat(int offset) {
        this.pos = this.buf.length();
        this.peek = -1;
        this.cur = -1;
        return this.buf.substring(offset);
    }

    String eatToRParen(int pos) {
        StringBuilder s = new StringBuilder();
        this.initRead(this.buf, pos - 1);
        int depth = 0;
        while (this.cur > 0) {
            if (this.cur == 40) {
                ++depth;
            }
            if (this.cur == 41) {
                if (depth == 0) break;
                --depth;
            }
            s.append((char)this.cur);
            this.read();
        }
        return s.toString();
    }

    public static void main(String[] args) {
        Tokenizer t = new Tokenizer(args[0], false);
        Token tok = new Token();
        while (t.next((Token)tok).type != 22) {
            System.out.println(tok);
        }
    }

    static int ctype(int c) {
        if (c < 0) {
            return 0;
        }
        if (c < 128) {
            return ctypes[c];
        }
        return 1;
    }

    static {
        int i;
        ctypes = new byte[128];
        for (i = 97; i <= 122; ++i) {
            Tokenizer.ctypes[i] = 3;
        }
        for (i = 65; i <= 90; ++i) {
            Tokenizer.ctypes[i] = 3;
        }
        for (i = 48; i <= 57; ++i) {
            Tokenizer.ctypes[i] = 13;
        }
        i = 97;
        while (i <= 102) {
            int n = i++;
            ctypes[n] = (byte)(ctypes[n] | 8);
        }
        i = 65;
        while (i <= 70) {
            int n = i++;
            ctypes[n] = (byte)(ctypes[n] | 8);
        }
        Tokenizer.ctypes[32] = 16;
        Tokenizer.ctypes[10] = 16;
        Tokenizer.ctypes[13] = 16;
        Tokenizer.ctypes[9] = 16;
        Tokenizer.ctypes[12] = 16;
    }
}

