/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx;

import com.tridium.gx.GeomPeer;
import java.util.logging.Logger;
import javax.baja.gx.IEllipseGeom;
import javax.baja.gx.IGeom;
import javax.baja.gx.ILineGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.IPolygonGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BDouble;

public abstract class DefaultGeomPeer
implements GeomPeer,
IRectGeom {
    private static final Logger LOGGER = Logger.getLogger("gx");

    public static DefaultGeomPeer make(IGeom geom) {
        switch (geom.getGeomCase()) {
            case 1: {
                return new Line((ILineGeom)geom);
            }
            case 2: {
                return new Rect((IRectGeom)geom);
            }
            case 3: {
                return new Ellipse((IEllipseGeom)geom);
            }
            case 4: {
                return new Polygon((IPolygonGeom)geom);
            }
            case 5: {
                return new Path((IPathGeom)geom);
            }
        }
        throw new UnsupportedOperationException("No GeomPeer support for " + geom.getClass().getName());
    }

    @Override
    public int getGeomCase() {
        return 2;
    }

    @Override
    public abstract double x();

    @Override
    public abstract double y();

    @Override
    public abstract double width();

    @Override
    public abstract double height();

    public abstract IGeom geom();

    @Override
    public IRectGeom bounds() {
        return this;
    }

    @Override
    public boolean contains(double x, double y) {
        double x1 = this.x();
        double y1 = this.y();
        double x2 = x1 + this.width();
        double y2 = y1 + this.height();
        return x1 <= x && y1 <= y && x <= x2 && y <= y2;
    }

    @Override
    public boolean contains(IGeom geom) {
        IRectGeom r = DefaultGeomPeer.toRect(geom);
        return this.contains(r.x(), r.y(), r.width(), r.height());
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        double x1 = this.x();
        double y1 = this.y();
        double x2 = x1 + this.width();
        double y2 = y1 + this.height();
        boolean a = x1 <= x && y1 <= y && x <= x2 && y <= y2;
        boolean b = x1 <= (x += w) && y1 <= (y += h) && x <= x2 && y <= y2;
        return a && b;
    }

    @Override
    public boolean intersects(IGeom geom) {
        IRectGeom r = DefaultGeomPeer.toRect(geom);
        return this.intersects(r.x(), r.y(), r.width(), r.height());
    }

    @Override
    public boolean intersects(double bx, double by, double bw, double bh) {
        double ax = this.x();
        double ay = this.y();
        double ax2 = ax + this.width();
        double ay2 = ay + this.height();
        double bx2 = bx + bw;
        double by2 = by + bh;
        if (ax < bx) {
            ax = bx;
        }
        if (ay < by) {
            ay = by;
        }
        if (ax2 > bx2) {
            ax2 = bx2;
        }
        if (ay2 > by2) {
            ay2 = by2;
        }
        return (ax2 -= ax) > 0.0 && (ay2 -= ay) > 0.0;
    }

    @Override
    public IGeom intersection(IGeom geom) {
        return this.intersection(DefaultGeomPeer.toRect(geom));
    }

    public IGeom intersection(IRectGeom r) {
        return RectGeom.intersection(this, r, null);
    }

    @Override
    public IGeom intersection(double rx, double ry, double rw, double rh) {
        return RectGeom.intersection(this.x(), this.y(), this.width(), this.height(), rx, ry, rw, rh, null);
    }

    @Override
    public Object fw(int id, Object a, Object b, Object c, Object d) {
        return this;
    }

    public String toString() {
        return "GeomPeer[" + BDouble.encode((double)this.x()) + "," + BDouble.encode((double)this.y()) + "," + BDouble.encode((double)this.width()) + "," + BDouble.encode((double)this.height()) + "]";
    }

    public static IRectGeom toRect(IGeom geom) {
        if (geom instanceof IRectGeom) {
            return (IRectGeom)geom;
        }
        return geom.bounds();
    }

    public static class Path
    extends DefaultGeomPeer {
        IPathGeom geom;
        double x;
        double y;
        double w;
        double h;

        Path(IPathGeom geom) {
            this.geom = geom;
            this.computeBounds();
        }

        @Override
        public final IGeom geom() {
            return this.geom;
        }

        @Override
        public double x() {
            return this.x;
        }

        @Override
        public double y() {
            return this.y;
        }

        @Override
        public double width() {
            return this.w;
        }

        @Override
        public double height() {
            return this.h;
        }

        protected void computeBounds() {
            boolean smoothQuadFound = false;
            double cursorX = 0.0;
            double cursorY = 0.0;
            double minX = Double.NaN;
            double maxX = Double.NaN;
            double minY = Double.NaN;
            double maxY = Double.NaN;
            for (int i = 0; i < this.geom.segments().length; ++i) {
                IPathGeom.Segment curve;
                IPathGeom.Segment line;
                IPathGeom.Segment segment = this.geom.segment(i);
                if (segment instanceof IPathGeom.ClosePath) continue;
                if (segment instanceof IPathGeom.MoveTo) {
                    IPathGeom.MoveTo move = (IPathGeom.MoveTo)segment;
                    if (move.isAbsolute()) {
                        cursorX = move.getX();
                        cursorY = move.getY();
                    } else {
                        cursorX += move.getX();
                        cursorY += move.getY();
                    }
                    minX = Double.isNaN(minX) ? cursorX : Math.min(minX, cursorX);
                    maxX = Double.isNaN(maxX) ? cursorX : Math.max(maxX, cursorX);
                    minY = Double.isNaN(minY) ? cursorY : Math.min(minY, cursorY);
                    maxY = Double.isNaN(maxY) ? cursorY : Math.max(maxY, cursorY);
                    continue;
                }
                if (segment instanceof IPathGeom.LineTo) {
                    line = (IPathGeom.LineTo)segment;
                    if (line.isAbsolute()) {
                        cursorX = ((IPathGeom.LineTo)line).getX();
                        cursorY = ((IPathGeom.LineTo)line).getY();
                    } else {
                        cursorX += ((IPathGeom.LineTo)line).getX();
                        cursorY += ((IPathGeom.LineTo)line).getY();
                    }
                    minX = Double.isNaN(minX) ? cursorX : Math.min(minX, cursorX);
                    maxX = Double.isNaN(maxX) ? cursorX : Math.max(maxX, cursorX);
                    minY = Double.isNaN(minY) ? cursorY : Math.min(minY, cursorY);
                    maxY = Double.isNaN(maxY) ? cursorY : Math.max(maxY, cursorY);
                    continue;
                }
                if (segment instanceof IPathGeom.HLineTo) {
                    line = (IPathGeom.HLineTo)segment;
                    cursorX = line.isAbsolute() ? ((IPathGeom.HLineTo)line).getX() : (cursorX += ((IPathGeom.HLineTo)line).getX());
                    minX = Double.isNaN(minX) ? cursorX : Math.min(minX, cursorX);
                    maxX = Double.isNaN(maxX) ? cursorX : Math.max(maxX, cursorX);
                    continue;
                }
                if (segment instanceof IPathGeom.VLineTo) {
                    line = (IPathGeom.VLineTo)segment;
                    cursorY = line.isAbsolute() ? ((IPathGeom.VLineTo)line).getY() : (cursorY += ((IPathGeom.VLineTo)line).getY());
                    minY = Double.isNaN(minY) ? cursorY : Math.min(minY, cursorY);
                    maxY = Double.isNaN(maxY) ? cursorY : Math.max(maxY, cursorY);
                    continue;
                }
                if (segment instanceof IPathGeom.CurveTo) {
                    curve = (IPathGeom.CurveTo)segment;
                    if (curve.isAbsolute()) {
                        minX = Double.isNaN(minX) ? ((IPathGeom.CurveTo)curve).getX1() : Math.min(minX, ((IPathGeom.CurveTo)curve).getX1());
                        maxX = Double.isNaN(maxX) ? ((IPathGeom.CurveTo)curve).getX1() : Math.max(maxX, ((IPathGeom.CurveTo)curve).getX1());
                        minY = Double.isNaN(minY) ? ((IPathGeom.CurveTo)curve).getY1() : Math.min(minY, ((IPathGeom.CurveTo)curve).getY1());
                        maxY = Double.isNaN(maxY) ? ((IPathGeom.CurveTo)curve).getY1() : Math.max(maxY, ((IPathGeom.CurveTo)curve).getY1());
                        minX = Double.isNaN(minX) ? ((IPathGeom.CurveTo)curve).getX2() : Math.min(minX, ((IPathGeom.CurveTo)curve).getX2());
                        maxX = Double.isNaN(maxX) ? ((IPathGeom.CurveTo)curve).getX2() : Math.max(maxX, ((IPathGeom.CurveTo)curve).getX2());
                        minY = Double.isNaN(minY) ? ((IPathGeom.CurveTo)curve).getY2() : Math.min(minY, ((IPathGeom.CurveTo)curve).getY2());
                        maxY = Double.isNaN(maxY) ? ((IPathGeom.CurveTo)curve).getY2() : Math.max(maxY, ((IPathGeom.CurveTo)curve).getY2());
                    } else {
                        minX = Double.isNaN(minX) ? cursorX + ((IPathGeom.CurveTo)curve).getX1() : Math.min(minX, cursorX + ((IPathGeom.CurveTo)curve).getX1());
                        maxX = Double.isNaN(maxX) ? cursorX + ((IPathGeom.CurveTo)curve).getX1() : Math.max(maxX, cursorX + ((IPathGeom.CurveTo)curve).getX1());
                        minY = Double.isNaN(minY) ? cursorY + ((IPathGeom.CurveTo)curve).getY1() : Math.min(minY, cursorY + ((IPathGeom.CurveTo)curve).getY1());
                        maxY = Double.isNaN(maxY) ? cursorY + ((IPathGeom.CurveTo)curve).getY1() : Math.max(maxY, cursorY + ((IPathGeom.CurveTo)curve).getY1());
                        minX = Double.isNaN(minX) ? cursorX + ((IPathGeom.CurveTo)curve).getX2() : Math.min(minX, cursorX + ((IPathGeom.CurveTo)curve).getX2());
                        maxX = Double.isNaN(maxX) ? cursorX + ((IPathGeom.CurveTo)curve).getX2() : Math.max(maxX, cursorX + ((IPathGeom.CurveTo)curve).getX2());
                        minY = Double.isNaN(minY) ? cursorY + ((IPathGeom.CurveTo)curve).getY2() : Math.min(minY, cursorY + ((IPathGeom.CurveTo)curve).getY2());
                        double d = maxY = Double.isNaN(maxY) ? cursorY + ((IPathGeom.CurveTo)curve).getY2() : Math.max(maxY, cursorY + ((IPathGeom.CurveTo)curve).getY2());
                    }
                    if (curve.isAbsolute()) {
                        cursorX = ((IPathGeom.CurveTo)curve).getX();
                        cursorY = ((IPathGeom.CurveTo)curve).getY();
                    } else {
                        cursorX += ((IPathGeom.CurveTo)curve).getX();
                        cursorY += ((IPathGeom.CurveTo)curve).getY();
                    }
                    minX = Double.isNaN(minX) ? cursorX : Math.min(minX, cursorX);
                    maxX = Double.isNaN(maxX) ? cursorX : Math.max(maxX, cursorX);
                    minY = Double.isNaN(minY) ? cursorY : Math.min(minY, cursorY);
                    maxY = Double.isNaN(maxY) ? cursorY : Math.max(maxY, cursorY);
                    continue;
                }
                if (segment instanceof IPathGeom.SmoothCurveTo) {
                    curve = (IPathGeom.SmoothCurveTo)segment;
                    if (curve.isAbsolute()) {
                        minX = Double.isNaN(minX) ? ((IPathGeom.SmoothCurveTo)curve).getX2() : Math.min(minX, ((IPathGeom.SmoothCurveTo)curve).getX2());
                        maxX = Double.isNaN(maxX) ? ((IPathGeom.SmoothCurveTo)curve).getX2() : Math.max(maxX, ((IPathGeom.SmoothCurveTo)curve).getX2());
                        minY = Double.isNaN(minY) ? ((IPathGeom.SmoothCurveTo)curve).getY2() : Math.min(minY, ((IPathGeom.SmoothCurveTo)curve).getY2());
                        maxY = Double.isNaN(maxY) ? ((IPathGeom.SmoothCurveTo)curve).getY2() : Math.max(maxY, ((IPathGeom.SmoothCurveTo)curve).getY2());
                    } else {
                        minX = Double.isNaN(minX) ? cursorX + ((IPathGeom.SmoothCurveTo)curve).getX2() : Math.min(minX, cursorX + ((IPathGeom.SmoothCurveTo)curve).getX2());
                        maxX = Double.isNaN(maxX) ? cursorX + ((IPathGeom.SmoothCurveTo)curve).getX2() : Math.max(maxX, cursorX + ((IPathGeom.SmoothCurveTo)curve).getX2());
                        minY = Double.isNaN(minY) ? cursorY + ((IPathGeom.SmoothCurveTo)curve).getY2() : Math.min(minY, cursorY + ((IPathGeom.SmoothCurveTo)curve).getY2());
                        double d = maxY = Double.isNaN(maxY) ? cursorY + ((IPathGeom.SmoothCurveTo)curve).getY2() : Math.max(maxY, cursorY + ((IPathGeom.SmoothCurveTo)curve).getY2());
                    }
                    if (curve.isAbsolute()) {
                        cursorX = ((IPathGeom.SmoothCurveTo)curve).getX();
                        cursorY = ((IPathGeom.SmoothCurveTo)curve).getY();
                    } else {
                        cursorX += ((IPathGeom.SmoothCurveTo)curve).getX();
                        cursorY += ((IPathGeom.SmoothCurveTo)curve).getY();
                    }
                    minX = Double.isNaN(minX) ? cursorX : Math.min(minX, cursorX);
                    maxX = Double.isNaN(maxX) ? cursorX : Math.max(maxX, cursorX);
                    minY = Double.isNaN(minY) ? cursorY : Math.min(minY, cursorY);
                    maxY = Double.isNaN(maxY) ? cursorY : Math.max(maxY, cursorY);
                    continue;
                }
                if (segment instanceof IPathGeom.QuadTo) {
                    curve = (IPathGeom.QuadTo)segment;
                    if (curve.isAbsolute()) {
                        minX = Double.isNaN(minX) ? ((IPathGeom.QuadTo)curve).getX1() : Math.min(minX, ((IPathGeom.QuadTo)curve).getX1());
                        maxX = Double.isNaN(maxX) ? ((IPathGeom.QuadTo)curve).getX1() : Math.max(maxX, ((IPathGeom.QuadTo)curve).getX1());
                        minY = Double.isNaN(minY) ? ((IPathGeom.QuadTo)curve).getY1() : Math.min(minY, ((IPathGeom.QuadTo)curve).getY1());
                        maxY = Double.isNaN(maxY) ? ((IPathGeom.QuadTo)curve).getY1() : Math.max(maxY, ((IPathGeom.QuadTo)curve).getY1());
                    } else {
                        minX = Double.isNaN(minX) ? cursorX + ((IPathGeom.QuadTo)curve).getX1() : Math.min(minX, cursorX + ((IPathGeom.QuadTo)curve).getX1());
                        maxX = Double.isNaN(maxX) ? cursorX + ((IPathGeom.QuadTo)curve).getX1() : Math.max(maxX, cursorX + ((IPathGeom.QuadTo)curve).getX1());
                        minY = Double.isNaN(minY) ? cursorY + ((IPathGeom.QuadTo)curve).getY1() : Math.min(minY, cursorY + ((IPathGeom.QuadTo)curve).getY1());
                        double d = maxY = Double.isNaN(maxY) ? cursorY + ((IPathGeom.QuadTo)curve).getY1() : Math.max(maxY, cursorY + ((IPathGeom.QuadTo)curve).getY1());
                    }
                    if (curve.isAbsolute()) {
                        cursorX = ((IPathGeom.QuadTo)curve).getX();
                        cursorY = ((IPathGeom.QuadTo)curve).getY();
                    } else {
                        cursorX += ((IPathGeom.QuadTo)curve).getX();
                        cursorY += ((IPathGeom.QuadTo)curve).getY();
                    }
                    minX = Double.isNaN(minX) ? cursorX : Math.min(minX, cursorX);
                    maxX = Double.isNaN(maxX) ? cursorX : Math.max(maxX, cursorX);
                    minY = Double.isNaN(minY) ? cursorY : Math.min(minY, cursorY);
                    maxY = Double.isNaN(maxY) ? cursorY : Math.max(maxY, cursorY);
                    continue;
                }
                if (segment instanceof IPathGeom.SmoothQuadTo) {
                    curve = (IPathGeom.SmoothQuadTo)segment;
                    if (curve.isAbsolute()) {
                        cursorX = ((IPathGeom.SmoothQuadTo)curve).getX();
                        cursorY = ((IPathGeom.SmoothQuadTo)curve).getY();
                    } else {
                        cursorX += ((IPathGeom.SmoothQuadTo)curve).getX();
                        cursorY += ((IPathGeom.SmoothQuadTo)curve).getY();
                    }
                    minX = Double.isNaN(minX) ? cursorX : Math.min(minX, cursorX);
                    maxX = Double.isNaN(maxX) ? cursorX : Math.max(maxX, cursorX);
                    minY = Double.isNaN(minY) ? cursorY : Math.min(minY, cursorY);
                    maxY = Double.isNaN(maxY) ? cursorY : Math.max(maxY, cursorY);
                    smoothQuadFound = true;
                    continue;
                }
                LOGGER.fine(() -> "Unhandled Segment:" + segment.getClass());
            }
            this.x = minX;
            this.y = minY;
            this.w = maxX - minX;
            this.h = maxY - minY;
            if (smoothQuadFound) {
                this.x -= this.w / 2.0;
                this.y -= this.h / 2.0;
                this.w *= 2.0;
                this.h *= 2.0;
            }
        }
    }

    public static class Polygon
    extends DefaultGeomPeer {
        public final IPolygonGeom geom;
        double x;
        double y;
        double w;
        double h;

        Polygon(IPolygonGeom geom) {
            this.geom = geom;
            this.computeBounds();
        }

        @Override
        public final IGeom geom() {
            return this.geom;
        }

        @Override
        public double x() {
            return this.x;
        }

        @Override
        public double y() {
            return this.y;
        }

        @Override
        public double width() {
            return this.w;
        }

        @Override
        public double height() {
            return this.h;
        }

        protected void computeBounds() {
            int size = this.geom.size();
            if (size == 0) {
                return;
            }
            this.x = Double.POSITIVE_INFINITY;
            this.y = Double.POSITIVE_INFINITY;
            this.w = Double.NEGATIVE_INFINITY;
            this.h = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < size; ++i) {
                double px = this.geom.x(i);
                double py = this.geom.y(i);
                this.x = Math.min(this.x, px);
                this.y = Math.min(this.y, py);
                this.w = Math.max(this.w, px);
                this.h = Math.max(this.h, py);
            }
            this.w -= this.x;
            this.h -= this.y;
        }
    }

    public static class Ellipse
    extends DefaultGeomPeer {
        public final IEllipseGeom geom;

        Ellipse(IEllipseGeom geom) {
            this.geom = geom;
        }

        @Override
        public final IGeom geom() {
            return this.geom;
        }

        @Override
        public final double x() {
            return this.geom.x();
        }

        @Override
        public final double y() {
            return this.geom.y();
        }

        @Override
        public final double width() {
            return this.geom.width();
        }

        @Override
        public final double height() {
            return this.geom.height();
        }
    }

    public static class Rect
    extends DefaultGeomPeer {
        public final IRectGeom geom;

        Rect(IRectGeom geom) {
            this.geom = geom;
        }

        @Override
        public final IGeom geom() {
            return this.geom;
        }

        @Override
        public final double x() {
            return this.geom.x();
        }

        @Override
        public final double y() {
            return this.geom.y();
        }

        @Override
        public final double width() {
            return this.geom.width();
        }

        @Override
        public final double height() {
            return this.geom.height();
        }
    }

    public static class Line
    extends DefaultGeomPeer {
        public final ILineGeom geom;

        Line(ILineGeom geom) {
            this.geom = geom;
        }

        @Override
        public final IGeom geom() {
            return this.geom;
        }

        @Override
        public final double x() {
            return Math.min(this.geom.x1(), this.geom.x2());
        }

        @Override
        public final double y() {
            return Math.min(this.geom.y1(), this.geom.y2());
        }

        @Override
        public final double width() {
            return Math.max(this.geom.x1(), this.geom.x2()) - this.x();
        }

        @Override
        public final double height() {
            return Math.max(this.geom.y1(), this.geom.y2()) - this.y();
        }
    }
}

