/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui.sysdef;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BNiagaraSysDefDeviceExt;
import com.tridium.nd.sysdef.BSysDefProvider;
import com.tridium.nd.ui.sysdef.BBox;
import com.tridium.nd.ui.sysdef.ICancelHint;
import com.tridium.nd.ui.sysdef.TaskDetailPane;
import com.tridium.ui.theme.Theme;
import java.util.Comparator;
import javax.baja.driver.BDevice;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Size;
import javax.baja.job.BJobState;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;

public class ChangeProviderWizard
extends WizardModel {
    TypeInfo[] providerTypes;
    BListDropDown providerList;
    BCheckBox niceShutdown;
    public static UiLexicon lex = UiLexicon.makeUiLexicon(ChangeProviderWizard.class);
    public static BImage banner = BImage.make((String)"module://icons/x32/cloud.png");
    BWidget owner;
    BNiagaraNetwork network;
    int currentStep = 0;
    BWidget step0;
    Size preferredSize = new Size(450.0, 200.0);

    public static void kickIt(BWidget owner, BNiagaraNetwork network) {
        ChangeProviderWizard model = new ChangeProviderWizard(owner, network);
        BWizard.open((BWidget)owner, (WizardModel)model);
    }

    public ChangeProviderWizard(BWidget owner, BNiagaraNetwork network) {
        this.owner = owner;
        this.network = network;
        this.buildStep0();
    }

    private void buildStep0() {
        this.providerList = new BListDropDown();
        this.loadProviders();
        this.providerList.setSelectedIndex(0);
        BGridPane a = new BGridPane(2);
        a.add(null, (BValue)new BLabel(lex.getText("changeProvider.newProvider")));
        a.add(null, (BValue)this.providerList);
        this.niceShutdown = new BCheckBox(lex.getText("changeProvider.wait"), false);
        BGridPane b = new BGridPane(1);
        b.add(null, (BValue)this.niceShutdown);
        BGridPane main = new BGridPane(1);
        main.setHalign(BHalign.left);
        main.setValign(BValign.top);
        main.setRowGap(10.0);
        main.add(null, (BValue)a);
        main.add(null, (BValue)b);
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BWizardHeader(banner, this.getTitle(), lex.getText("changeProvider.desc")));
        edge.setCenter((BWidget)new BBorderPane((BWidget)main, 10.0, 10.0, 10.0, 10.0));
        this.step0 = edge;
    }

    private void loadProviders() {
        Object[] allProviders = Sys.getRegistry().getConcreteTypes(BSysDefProvider.TYPE.getTypeInfo());
        this.providerTypes = new TypeInfo[allProviders.length - 1];
        SortUtil.sort((Object[])allProviders, (Object[])allProviders, (Comparator)new Comparator<TypeInfo>(){

            @Override
            public int compare(TypeInfo o1, TypeInfo o2) {
                return o1.getDisplayName(null).compareTo(o2.getDisplayName(null));
            }
        });
        int p = 0;
        for (int i = 0; i < allProviders.length; ++i) {
            if (allProviders[i].equals(this.network.getSysDefProvider().getType().getTypeInfo())) continue;
            this.providerTypes[p++] = allProviders[i];
            this.providerList.getList().addItem((Object)allProviders[i].getDisplayName(null));
        }
    }

    public String getTitle() {
        return lex.getText("changeProvider.title");
    }

    public Size getPreferredSizeOfSteps() {
        return this.preferredSize;
    }

    public void back() {
    }

    public void init() {
        this.updateTo0();
    }

    public void next() {
    }

    private void updateTo0() {
        this.update(this.step0, 4);
        this.currentStep = 0;
    }

    public boolean finish() {
        this.preferredSize = new Size(640.0, 380.0);
        this.getWizard().setBoundsCenteredOnOwner();
        ExecutionPane execPane = new ExecutionPane();
        this.update(execPane.getExecutionPane(), 0);
        new Thread(execPane).start();
        this.getWizard().getCancelButton().setEnabled(false);
        this.getWizard().getCancelButton().setText(UiLexicon.bajaui().getText("commands.exit.label"));
        return false;
    }

    class StartupTask
    extends ExecutableTask
    implements Runnable {
        public StartupTask() {
            super(lex.getText("Execute.items.startup"));
        }

        @Override
        public void doExecute() throws Exception {
            this.pane.getLog().append(this.description + "\n");
            ChangeProviderWizard.this.network.getSysDefProvider().startup();
            Thread monitor = new Thread(this);
            monitor.start();
            monitor.join();
        }

        @Override
        public void run() {
            int i = 0;
            int SLEEP = 500;
            int TIMEOUT_SECS = 31;
            int CANCEL_SECS = 5;
            int NOTIFY_SECS = 10;
            int MAX_WAIT_I = 62;
            int CHECK_CANCEL = 10;
            int NOTIFY = 20;
            BSysDefProvider provider = ChangeProviderWizard.this.network.getSysDefProvider();
            try {
                Thread.sleep(500L);
                while (!provider.getState().isRunning()) {
                    if (provider.getState().isUnrecoverable()) {
                        this.pane.updateCurrentItemState(BJobState.failed);
                        StringBuilder reason = new StringBuilder().append("[").append(provider.getState().toString()).append("] ").append(provider.getFaultCause());
                        this.pane.getLog().append(lex.getText("Execute.items.startup.failed", new Object[]{reason.toString()}));
                        return;
                    }
                    if (i > 62) {
                        this.pane.updateCurrentItemState(BJobState.failed);
                        this.pane.getLog().append(lex.getText("Execute.items.startup.failed", new Object[]{lex.getText("Execute.items.startup.timeout", new Object[]{31})}));
                    }
                    if (i % 10 == 0) {
                        this.pane.checkCanceled();
                    }
                    if (i++ % 20 == 0) {
                        this.pane.getLog().append(lex.getText("Execute.items.startup.monitor") + "\n");
                    }
                    Thread.sleep(500L);
                }
                this.pane.checkCanceled();
            }
            catch (ICancelHint.CanceledException cancel) {
                this.pane.updateCurrentItemState(BJobState.canceled);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class PostInstallTask
    extends ExecutableTask {
        public PostInstallTask() {
            super(lex.getText("Execute.items.postInstall"));
        }

        @Override
        public void doExecute() throws Exception {
            this.pane.getLog().append(this.description + "\n");
            BDevice[] devices = ChangeProviderWizard.this.network.getDevices();
            for (int i = 0; i < devices.length; ++i) {
                BNiagaraStation ns = (BNiagaraStation)devices[i];
                BNiagaraSysDefDeviceExt ext = ns.getSysDef();
                ext.lease(3);
                if (!ext.getRole().isPeer()) {
                    this.pane.getLog().append("Sync'ing: ").append(ns.getStationName()).append(" [").append(ext.getRole().toString()).append("]");
                    ext.getSyncTask().setRequestReciprocatedSync(true);
                } else {
                    this.pane.getLog().append("Skipping peer: " + ns.getStationName());
                }
                this.pane.getLog().append("\n");
            }
            this.pane.getLog().append("\n");
        }
    }

    class InstallTask
    extends ExecutableTask {
        public InstallTask() {
            super(lex.getText("Execute.items.install"));
        }

        @Override
        public void doExecute() throws Exception {
            TypeInfo newType = ChangeProviderWizard.this.providerTypes[ChangeProviderWizard.this.providerList.getSelectedIndex()];
            this.pane.getLog().append(this.description).append(" [").append(newType.toString()).append("].\n");
            BSysDefProvider newProvider = (BSysDefProvider)newType.getInstance();
            ChangeProviderWizard.this.network.setSysDefProvider(newProvider);
            this.pane.getLog().append(lex.getText("Execute.items.install.installed", new Object[]{newType.toString()}) + "\n");
        }
    }

    class ShutdownTask
    extends ExecutableTask
    implements Runnable {
        Exception failX;
        boolean immediate;
        BSysDefProvider provider;

        public ShutdownTask() {
            super(lex.getText("Execute.items.shutdown"));
            this.failX = null;
        }

        @Override
        public void doExecute() throws Exception {
            this.provider = ChangeProviderWizard.this.network.getSysDefProvider();
            boolean bl = this.immediate = !ChangeProviderWizard.this.niceShutdown.getSelected();
            if (this.immediate) {
                this.pane.getLog().append(lex.getText("Execute.items.shutdown.immediate"));
            } else {
                this.pane.getLog().append(lex.getText("Execute.items.shutdown.wait"));
            }
            this.pane.getLog().append("\n");
            this.provider.shutdown(BBoolean.make((boolean)this.immediate));
            Thread monitor = new Thread(this);
            monitor.start();
            monitor.join();
            this.pane.checkCanceled();
            if (this.failX != null) {
                throw this.failX;
            }
        }

        @Override
        public void run() {
            long i = 0L;
            try {
                Thread.sleep(500L);
                while (!this.provider.getState().isStopped() && !this.provider.getState().isUnrecoverable()) {
                    if (i % 10L == 0L) {
                        this.pane.checkCanceled();
                    }
                    if (i++ % 20L == 0L) {
                        this.pane.getLog().append(lex.getText("Execute.items.shutdown.monitor"));
                        if (!this.immediate) {
                            this.pane.getLog().append(" " + lex.getText("Execute.items.shutdown.wait"));
                        }
                        this.pane.getLog().append("\n");
                    }
                    Thread.sleep(500L);
                }
            }
            catch (Exception x) {
                this.failX = x;
            }
        }
    }

    abstract class ExecutableTask
    extends TaskDetailPane.TaskItem {
        protected ExecutionPane pane;

        public ExecutableTask(String description) {
            super(description);
        }

        public final void execute(ExecutionPane pane) throws Exception {
            this.pane = pane;
            this.doExecute();
            pane.updateCurrentItemState(BJobState.success);
        }

        protected abstract void doExecute() throws Exception;
    }

    class ExecutionPane
    extends TaskDetailPane {
        private BEdgePane executionPane;
        private BButton controlButton;
        private Command controlCommand;
        private Array<TaskDetailPane.TaskItem> tasks;
        private ExecutableTask shutdownTask;
        private ExecutableTask installTask;
        private ExecutableTask postInstallTask;
        private ExecutableTask startupTask;

        public ExecutionPane() {
            this.shutdownTask = new ShutdownTask();
            this.installTask = new InstallTask();
            this.postInstallTask = new PostInstallTask();
            this.startupTask = new StartupTask();
            this.init();
        }

        public BImage getHeadingIcon() {
            return banner;
        }

        public String getHeadingTitle() {
            return lex.getText("changeProvider.title");
        }

        public String getHeadingDescription() {
            return null;
        }

        @Override
        public String getItemListHeading() {
            return lex.getText("Execute.itemHeading");
        }

        public BWidget getExecutionPane() {
            return this.executionPane;
        }

        @Override
        public TaskDetailPane.TaskItem[] makeTaskItems() {
            this.tasks = new Array(TaskDetailPane.TaskItem.class);
            this.tasks.add((Object)this.shutdownTask);
            this.tasks.add((Object)this.installTask);
            this.tasks.add((Object)this.postInstallTask);
            this.tasks.add((Object)this.startupTask);
            return (TaskDetailPane.TaskItem[])this.tasks.trim();
        }

        @Override
        public void init() {
            super.init();
            BGridPane headingGrid = new BGridPane(2);
            headingGrid.setHalign(BHalign.left);
            headingGrid.setColumnAlign(BHalign.fill);
            headingGrid.setValign(BValign.top);
            headingGrid.setStretchColumn(1);
            if (this.getHeadingIcon() == null) {
                headingGrid.add(null, (BValue)new BNullWidget());
            } else {
                headingGrid.add(null, (BValue)new BLabel(this.getHeadingIcon()));
            }
            BGridPane headingRight = new BGridPane(1);
            headingRight.setHalign(BHalign.left);
            headingRight.setColumnAlign(BHalign.fill);
            headingRight.setValign(BValign.top);
            headingRight.setStretchColumn(0);
            BLabel headingLabel = new BLabel(this.getHeadingTitle(), BHalign.left);
            headingRight.add(null, (BValue)headingLabel);
            headingLabel.setFont(Theme.widget().getLargeBoldFont());
            if (this.getHeadingDescription() != null) {
                headingLabel = new BLabel(this.getHeadingDescription(), BHalign.left);
                headingRight.add(null, (BValue)headingLabel);
            }
            headingGrid.add(null, (BValue)headingRight);
            BBorderPane headingBorder = new BBorderPane((BWidget)headingGrid, BBorder.make((String)"bottom(solid)"));
            headingBorder.setFill(BColor.make((int)170, (int)170, (int)170).toBrush());
            BGridPane buttons = new BGridPane(1);
            buttons.setUniformColumnWidth(true);
            buttons.setColumnAlign(BHalign.fill);
            this.controlButton = new BButton();
            buttons.add(null, (BValue)this.controlButton);
            this.executionPane = new BEdgePane((BWidget)headingBorder, (BWidget)new BEdgePane((BWidget)new BBox(660.0, 0.0), null, null, null, (BWidget)new BBorderPane((BWidget)buttons, 0.0, 10.0, 10.0, 10.0)), (BWidget)new BBox(0.0, 480.0), null, (BWidget)new BBorderPane(this.getPane(), 10.0, 10.0, 10.0, 10.0));
            this.controlCommand = new ExecCancel();
            this.controlButton.setCommand(this.controlCommand, true, false);
        }

        @Override
        public void run() {
            try {
                this.getLog().append(lex.getText("Execute.itemHeading"));
                this.getLog().append("\n");
                for (int i = 0; i < this.tasks.size(); ++i) {
                    ExecutableTask task = (ExecutableTask)this.tasks.get(i);
                    this.setCurrentItem(task, BJobState.running);
                    task.execute(this);
                    this.getLog().append("\n");
                }
                this.getLog().append(lex.getText("Execute.finished"));
                this.getLog().append("\n");
                this.setBottomLabelText(lex.getText("Execute.finished"));
            }
            catch (ICancelHint.CanceledException cancel) {
                this.updateCurrentItemState(BJobState.canceled);
                this.getLog().append(lex.getText("Execute.canceled"));
                this.getLog().append("\n");
                this.setBottomLabelText(lex.getText("Execute.canceled"));
            }
            catch (Throwable t) {
                this.setCancelEnabled(true);
                this.cancel(false);
                this.updateCurrentItemState(BJobState.failed);
                this.getLog().append(t);
                this.setBottomLabelText(lex.getText("Execute.failed"));
            }
            finally {
                ChangeProviderWizard.this.getWizard().getCancelButton().setEnabled(true);
            }
        }

        @Override
        public void setCancelEnabled(boolean value) {
            super.setCancelEnabled(value);
            this.controlCommand.setEnabled(value);
        }

        @Override
        protected BJobState update() {
            BJobState result = super.update();
            if (result == BJobState.failed || result == BJobState.canceled || result == BJobState.success) {
                this.controlButton.setEnabled(false);
            }
            return result;
        }

        class ExecCancel
        extends Command {
            public ExecCancel() {
                super((BWidget)ExecutionPane.this.executionPane, UiLexicon.bajaui().getText("action.cancel"));
            }

            public CommandArtifact doInvoke() throws Exception {
                ExecutionPane.this.getLog().append("\n");
                ExecutionPane.this.getLog().append(lex.getText("Execute.cancelPending"));
                ExecutionPane.this.getLog().append("\n");
                ExecutionPane.this.cancel();
                return null;
            }
        }
    }
}

