/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui.history;

import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.discover.HistoryDeviceLearnNodeInfo;
import com.tridium.nd.discover.HistoryLearnNodeInfo;
import com.tridium.nd.discover.NiagaraLearnUtil;
import com.tridium.nd.history.BNiagaraHistoryImport;
import com.tridium.nd.history.BNiagaraSystemHistoryImport;
import com.tridium.nd.ui.history.BNiagaraHistoryImportManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.history.BArchiveDescriptor;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.driver.history.BIArchiveFolder;
import javax.baja.driver.ui.history.ArchiveModel;
import javax.baja.driver.ui.history.BArchiveManager;
import javax.baja.driver.ui.history.BHistoryImportManager;
import javax.baja.driver.ui.history.HistoryLearn;
import javax.baja.gx.BImage;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class NiagaraImportLearn
extends HistoryLearn {
    static final Logger LOG = Logger.getLogger("niagaraDriver");
    static Lexicon lex = Lexicon.make(BNiagaraHistoryImportManager.class);
    static String lexRemote = lex.getText("historyImportManager.remote");
    static final BImage historyIcon = BImage.make((BIcon)BIcon.std((String)"history.png"));
    static final BImage deviceIcon = BImage.make((BIcon)BIcon.std((String)"device.png"));
    BNiagaraStation station;

    public NiagaraImportLearn(BHistoryImportManager manager) {
        super((BArchiveManager)manager);
    }

    static BNiagaraStation getStation(BComponent target) {
        return NiagaraLearnUtil.getNiagaraStation((BComponent)target);
    }

    public void load(BComponent target) {
        super.load(target);
        this.station = NiagaraImportLearn.getStation(target);
    }

    public Object[] getDiscovery(BComponent target) {
        try {
            return NiagaraLearnUtil.discoverHistoriesViaProxyExt((BDeviceExt)((BIArchiveFolder)target).getDeviceExt(), null);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not discover remote histories", e);
            return new HistoryDeviceLearnNodeInfo[0];
        }
    }

    public MgrTypeInfo[] toTypes(Object discovery) {
        if (this.isHistory(discovery)) {
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BNiagaraHistoryImport.TYPE)};
        }
        return super.toTypes(discovery);
    }

    public boolean isExisting(Object discovery, BComponent component) {
        BHistoryId impId;
        if (!this.isHistory(discovery)) {
            return false;
        }
        if (!(component instanceof BHistoryImport)) {
            return false;
        }
        HistoryLearnNodeInfo h = (HistoryLearnNodeInfo)discovery;
        if (component instanceof BNiagaraSystemHistoryImport) {
            BHistoryConfig config = new BHistoryConfig();
            config.setId(h.getHistoryId());
            config.setSystemTags(h.getSystemTags());
            String list = ((BNiagaraSystemHistoryImport)component).getSystemTagPatterns();
            if (list == null || list.length() < 1) {
                return false;
            }
            PatternFilter[] patterns = PatternFilter.parseList((String)list);
            return patterns.length > 0 && BLocalHistoryDatabase.acceptSystemTags((BHistoryConfig)config, (PatternFilter[])patterns);
        }
        BHistoryImport imp = (BHistoryImport)component;
        BHistoryId id = h.getHistoryId();
        return id.equals((Object)(impId = imp.getHistoryId())) || impId.equals((Object)id.toShorthand(this.station.getStationName()));
    }

    protected MgrColumn[] makeColumns() {
        MgrColumn[] cols = super.makeColumns();
        int size = cols != null ? cols.length : 0;
        MgrColumn[] newCols = new MgrColumn[size + 1];
        for (int i = 0; i < size; ++i) {
            newCols[i] = cols[i];
        }
        newCols[size] = new SystemTagColumn();
        return newCols;
    }

    public void toRow(Object discovery, MgrEditRow row) throws Exception {
        HistoryLearnNodeInfo history = (HistoryLearnNodeInfo)discovery;
        BHistoryId shorthandId = history.getHistoryId().toShorthand(this.station.getStationName());
        String name = shorthandId.toString();
        name = name.startsWith("^", 0) ? lexRemote + "_" + name.substring(1) : name.substring(1);
        name = name.replace('/', '_');
        row.setDefaultName(name);
        row.setCell(((ArchiveModel)this.getManager().getModel()).idCol, (BValue)shorthandId);
    }

    public BImage getIcon(Object discovery) {
        if (this.isHistory(discovery)) {
            return historyIcon;
        }
        if (this.isHistoryDevice(discovery)) {
            return deviceIcon;
        }
        return null;
    }

    public boolean isGroup(Object discovery) {
        return this.isHistoryDevice(discovery);
    }

    public Object[] getChildren(Object discovery) {
        if (this.isHistoryDevice(discovery)) {
            return ((HistoryDeviceLearnNodeInfo)discovery).getHistories();
        }
        return super.getChildren(discovery);
    }

    public boolean isMatchable(Object discovery, BComponent database) {
        if (this.isHistoryDevice(discovery)) {
            return false;
        }
        return this.isHistory(discovery) && database instanceof BArchiveDescriptor;
    }

    private boolean isHistory(Object discovery) {
        return discovery instanceof HistoryLearnNodeInfo;
    }

    private boolean isHistoryDevice(Object discovery) {
        return discovery instanceof HistoryDeviceLearnNodeInfo;
    }

    static class SystemTagColumn
    extends MgrColumn {
        SystemTagColumn(String name) {
            super(name, 1);
        }

        SystemTagColumn() {
            this(HistoryLearn.histLex.getText("historyExtManager.systemTags"));
        }

        public Object get(Object row) {
            if (row instanceof HistoryLearnNodeInfo) {
                return ((HistoryLearnNodeInfo)row).getSystemTags();
            }
            if (row instanceof BIHistory) {
                return ((BIHistory)row).getConfig().getSystemTags();
            }
            return "";
        }
    }
}

