/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.version3.securityModel.usm.privacy;

import com.tridium.nSnmp.version3.securityModel.usm.privacy.Salt;
import com.tridium.nSnmp.version3.securityModel.usm.privacy.UsmPrivacy;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class AESPrivacy
implements UsmPrivacy {
    private static final int ENCRYPT_PARAMS_LENGTH = 8;
    private int lengthOfKey;
    private Salt salt;
    private byte[] privacyParameter;

    AESPrivacy(int lengthOfKey) {
        if (lengthOfKey != 16 && lengthOfKey != 24 && lengthOfKey != 32) {
            throw new IllegalArgumentException("Only 128, 192 and 256 bit AES is allowed Requested (" + 8 * lengthOfKey + ")");
        }
        this.lengthOfKey = lengthOfKey;
        this.salt = Salt.getInstance();
    }

    @Override
    public byte[] encryptMsg(byte[] unencryptedMsg, byte[] encryptionKey, int engineBootTime, int engineTime, byte[] privacyParam) {
        byte[] initialVector = new byte[16];
        long my_salt = this.salt.getNext();
        if (encryptionKey.length < this.lengthOfKey) {
            throw new IllegalArgumentException("invalid keylength");
        }
        if (privacyParam == null || privacyParam.length < 8) {
            privacyParam = new byte[8];
        }
        initialVector[0] = (byte)(engineBootTime >> 24 & 0xFF);
        initialVector[1] = (byte)(engineBootTime >> 16 & 0xFF);
        initialVector[2] = (byte)(engineBootTime >> 8 & 0xFF);
        initialVector[3] = (byte)(engineBootTime >> 0 & 0xFF);
        initialVector[4] = (byte)(engineTime >> 24 & 0xFF);
        initialVector[5] = (byte)(engineTime >> 16 & 0xFF);
        initialVector[6] = (byte)(engineTime >> 8 & 0xFF);
        initialVector[7] = (byte)(engineTime >> 0 & 0xFF);
        int i = 56;
        int j = 8;
        while (i >= 0) {
            initialVector[j] = (byte)(my_salt >> i & 0xFFL);
            i -= 8;
            ++j;
        }
        privacyParam = new byte[8];
        for (i = 0; i < 8; ++i) {
            privacyParam[i] = initialVector[i + 8];
        }
        byte[] encryptedData = null;
        try {
            Cipher algorithm = Cipher.getInstance("AES/CFB/NoPadding");
            SecretKeySpec key = new SecretKeySpec(encryptionKey, 0, this.lengthOfKey, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(initialVector);
            algorithm.init(1, (Key)key, ivSpec);
            encryptedData = algorithm.doFinal(unencryptedMsg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.privacyParameter = privacyParam;
        return encryptedData;
    }

    @Override
    public byte[] decryptMsg(byte[] encryptedMsg, byte[] decryptionKey, int engineBootTime, int engineTime, byte[] privacyParam) {
        byte[] initialVector = new byte[16];
        if (decryptionKey.length < this.lengthOfKey) {
            throw new IllegalArgumentException("invalid keylength");
        }
        if (privacyParam == null || privacyParam.length < 8) {
            privacyParam = new byte[8];
        }
        initialVector[0] = (byte)(engineBootTime >> 24 & 0xFF);
        initialVector[1] = (byte)(engineBootTime >> 16 & 0xFF);
        initialVector[2] = (byte)(engineBootTime >> 8 & 0xFF);
        initialVector[3] = (byte)(engineBootTime >> 0 & 0xFF);
        initialVector[4] = (byte)(engineTime >> 24 & 0xFF);
        initialVector[5] = (byte)(engineTime >> 16 & 0xFF);
        initialVector[6] = (byte)(engineTime >> 8 & 0xFF);
        initialVector[7] = (byte)(engineTime >> 0 & 0xFF);
        for (int i = 0; i < 8; ++i) {
            initialVector[i + 8] = privacyParam[i];
        }
        byte[] decryptedData = null;
        try {
            Cipher alg = Cipher.getInstance("AES/CFB/NoPadding");
            SecretKeySpec key = new SecretKeySpec(decryptionKey, 0, this.lengthOfKey, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(initialVector);
            alg.init(2, (Key)key, ivSpec);
            decryptedData = alg.doFinal(encryptedMsg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return decryptedData;
    }

    @Override
    public int getEncryptedMsgLength(byte[] scopedPDU) {
        return scopedPDU.length;
    }

    @Override
    public int getKeyLength() {
        return this.lengthOfKey;
    }

    @Override
    public byte[] getPrivacyParam() {
        return this.privacyParameter;
    }
}

