/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.services;

import com.tridium.nSnmp.BSnmpNetwork;
import com.tridium.nSnmp.datatypes.BNetworkManagerConfiguration;
import com.tridium.nSnmp.messages.AlarmTrap;
import com.tridium.nSnmp.messages.SnmpV3AlarmTrap;
import com.tridium.nSnmp.mib.table.AlarmEntry;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="networkManagerConfig", type="BNetworkManagerConfiguration", defaultValue="new BNetworkManagerConfiguration()"), @NiagaraProperty(name="snmpAlarmTable", type="boolean", defaultValue="true", facets={@Facet(value="BFacets.makeBoolean(lex.getText(\"recipient.strings.storeAlarms\"), lex.getText(\"recipient.strings.discardAlarms\"))")})})
public class BSnmpRecipient
extends BAlarmRecipient {
    public static Lexicon lex = Lexicon.make((String)"snmp");
    @Generated
    public static final Property networkManagerConfig = BSnmpRecipient.newProperty((int)0, (BValue)new BNetworkManagerConfiguration(), null);
    @Generated
    public static final Property snmpAlarmTable = BSnmpRecipient.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)lex.getText("recipient.strings.storeAlarms"), (String)lex.getText("recipient.strings.discardAlarms")));
    @Generated
    public static final Type TYPE = Sys.loadType(BSnmpRecipient.class);

    @Generated
    public BNetworkManagerConfiguration getNetworkManagerConfig() {
        return (BNetworkManagerConfiguration)this.get(networkManagerConfig);
    }

    @Generated
    public void setNetworkManagerConfig(BNetworkManagerConfiguration v) {
        this.set(networkManagerConfig, (BValue)v, null);
    }

    @Generated
    public boolean getSnmpAlarmTable() {
        return this.getBoolean(snmpAlarmTable);
    }

    @Generated
    public void setSnmpAlarmTable(boolean v) {
        this.setBoolean(snmpAlarmTable, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.initAlarmTable();
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!this.isRunning()) {
            return;
        }
        if (prop == snmpAlarmTable) {
            this.initAlarmTable();
        }
    }

    private void initAlarmTable() {
        if (!this.getSnmpAlarmTable()) {
            return;
        }
        String query = this.getInitialAlarmQuery();
        BOrd ord = BOrd.make((String)query.toString());
        BITable result = (BITable)ord.resolve().get();
        try (TableCursor cur = result.cursor();){
            while (cur.next()) {
                BAlarmRecord alarm = (BAlarmRecord)cur.get();
                if (!this.accept(alarm)) continue;
                this.snmp().alarms().addAlarmEntry((BAlarmRecord)alarm.newCopy());
            }
        }
    }

    public void handleAlarm(BAlarmRecord alarmRecord) {
        try {
            if (!alarmRecord.isAcknowledged()) {
                AlarmEntry entry = this.getSnmpAlarmTable() ? this.snmp().alarms().addAlarmEntry(alarmRecord) : new AlarmEntry(alarmRecord, 0);
                if (this.snmp().isCommActive() && this.getNetworkManagerConfig().getRouteAlarmsToNetworkManager()) {
                    if (this.getNetworkManagerConfig().getUseDefaultNetworkManager()) {
                        if (this.snmp().getDefaultNetworkManagerSnmpVersion() == 3) {
                            SnmpV3AlarmTrap.sendAlarmTrap(this.snmp(), entry);
                        } else {
                            AlarmTrap.sendAlarmTrap(this.snmp(), entry);
                        }
                    } else if (this.getNetworkManagerConfig().getNetworkManagerSnmpVersion() == 3) {
                        SnmpV3AlarmTrap.sendAlarmTrap(this, entry);
                    } else {
                        AlarmTrap.sendAlarmTrap(this, entry);
                    }
                }
            }
        }
        catch (Exception e) {
            if (this.snmp() == null) {
                if (this.snmp().log().isLoggable(Level.FINE)) {
                    this.snmp().log().log(Level.SEVERE, "Failed to send SNMP traps. BSnmpNetwork not found", e);
                } else {
                    this.snmp().log().log(Level.SEVERE, String.format("Failed to send SNMP traps. BSnmpNetwork not found %s", e.getLocalizedMessage()));
                }
            }
            if (this.snmp().log().isLoggable(Level.FINE)) {
                this.snmp().log().log(Level.SEVERE, "Failed to send SNMP traps", e);
            }
            this.snmp().log().log(Level.SEVERE, String.format("Failed to send SNMP traps %s", e.getLocalizedMessage()));
        }
    }

    public String getInitialAlarmQuery() {
        int i;
        String[] subscribedAlarmClasses = this.getSubscribedAlarmClasses();
        StringBuilder bqlQuery = new StringBuilder("alarm:|bql:select * from openAlarms");
        int count = 0;
        int parenth = 0;
        StringBuilder whereClause = new StringBuilder();
        for (i = 0; i < subscribedAlarmClasses.length; ++i) {
            String ac = subscribedAlarmClasses[i];
            if (count > 0) {
                whereClause.append(" or ");
                whereClause.append("(");
                ++parenth;
            }
            ++count;
            whereClause.append("alarmClass = '" + SlotPath.escape((String)ac) + "'");
        }
        for (i = 0; i < parenth; ++i) {
            whereClause.append(")");
        }
        if (whereClause.length() > 0) {
            bqlQuery.append(" where (");
            bqlQuery.append(whereClause.toString() + ")");
        } else {
            bqlQuery.append(" where alarmClass = 'null'");
        }
        return bqlQuery.toString();
    }

    public BSnmpNetwork snmp() {
        return (BSnmpNetwork)Sys.getService((Type)BSnmpNetwork.TYPE);
    }
}

