/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.point.agent;

import com.tridium.nSnmp.datatypes.BSnmpAgentNumericDefaultValue;
import com.tridium.nSnmp.point.agent.BSnmpAgentProxyExt;
import com.tridium.nSnmp.snmptypes.SnmpVar;
import com.tridium.nSnmp.util.SnmpUtil;
import javax.baja.control.BNumericPoint;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="defaultValue", type="BSnmpAgentNumericDefaultValue", defaultValue="new BSnmpAgentNumericDefaultValue()")
@NiagaraAction(name="resetPointToDefault")
public class BSnmpAgentNumericProxyExt
extends BSnmpAgentProxyExt {
    @Generated
    public static final Property defaultValue = BSnmpAgentNumericProxyExt.newProperty((int)0, (BValue)new BSnmpAgentNumericDefaultValue(), null);
    @Generated
    public static final Action resetPointToDefault = BSnmpAgentNumericProxyExt.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSnmpAgentNumericProxyExt.class);

    @Generated
    public BSnmpAgentNumericDefaultValue getDefaultValue() {
        return (BSnmpAgentNumericDefaultValue)this.get(defaultValue);
    }

    @Generated
    public void setDefaultValue(BSnmpAgentNumericDefaultValue v) {
        this.set(defaultValue, (BValue)v, null);
    }

    @Generated
    public void resetPointToDefault() {
        this.invoke(resetPointToDefault, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.getParentPoint().isWritablePoint()) {
            this.setFlags((Slot)defaultValue, 4);
            this.setFlags((Slot)resetPointToDefault, 4);
        } else {
            this.doResetPointToDefault();
        }
    }

    public void doResetPointToDefault() {
        this.readOk((BStatusValue)new BStatusNumeric(this.getDefaultValue().getDefaultValue()));
    }

    @Override
    public SnmpVar getValue() {
        BNumericPoint pnt = (BNumericPoint)this.getParentPoint();
        return SnmpUtil.getSnmpVar(pnt.getNumeric(), this.getVariableType());
    }

    @Override
    public void tryDecodeForSet(SnmpVar var) throws Exception {
        SnmpUtil.getNumeric(var);
    }

    @Override
    public SnmpVar setValue(SnmpVar var) {
        try {
            double dval = SnmpUtil.getNumeric(var);
            this.readOk((BStatusValue)new BStatusNumeric(dval));
            if (this.getDefaultValue().getAutoSet()) {
                this.getDefaultValue().setDefaultValue(dval);
            }
            this.getParentPoint().doExecute();
            return this.getValue();
        }
        catch (Exception e) {
            this.readFail(e.getMessage());
            return null;
        }
    }
}

