/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver;

import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BAccessReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"accessDriver:AccessNetwork"})})
public class BAccessNetworkSecurityDashboardProviderAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BAccessNetworkSecurityDashboardProviderAgent.class);
    private SecurityDashboardItemBuilder builder;
    private BAccessNetwork network;
    private final String SECTION_HEADER = "securityDashboard.accessNetwork.sectionHeader";
    private static final int SECURITY_DASHBOARD_ITEMS_VERSION = 1;
    private final String DIAGNOSTICMODE_ENABLED_SUMMARY = "securityDashboard.accessNetwork.diagnosticMode.enabled.summary";
    private final String DIAGNOSTICMODE_DISABLED_SUMMARY = "securityDashboard.accessNetwork.diagnosticMode.disabled.summary";
    private final String DIAGNOSTICMODE_DESCRIPTION = "securityDashboard.accessNetwork.diagnosticMode.description";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.network = (BAccessNetwork)object;
        this.builder = new SecurityDashboardItemBuilder((BIObject)this);
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context context) {
        return LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.accessNetwork.sectionHeader");
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.network.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        items.addAll(this.getDiagnosticModeStatus(cx));
        return Collections.unmodifiableList(items);
    }

    private List<SecurityDashboardItem> getDiagnosticModeStatus(Context cx) {
        BAccessReader[] readers;
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        ArrayList<String> readersEnabledDiagnosticMode = new ArrayList<String>();
        ArrayList<String> readersDisabledDiagnosticMode = new ArrayList<String>();
        for (BAccessReader reader : readers = this.network.getReaders()) {
            if (reader.getDiagnosticMode()) {
                readersEnabledDiagnosticMode.add(reader.getDisplayName(cx));
                continue;
            }
            readersDisabledDiagnosticMode.add(reader.getDisplayName(cx));
        }
        if (readersEnabledDiagnosticMode.size() > 0) {
            items.add(this.builder.makeWarning().withSummary("securityDashboard.accessNetwork.diagnosticMode.enabled.summary", new Object[]{String.join((CharSequence)", ", readersEnabledDiagnosticMode)}).withDescription("securityDashboard.accessNetwork.diagnosticMode.description", new Object[0]));
        }
        if (readersDisabledDiagnosticMode.size() > 0) {
            items.add(this.builder.makeOk().withSummary("securityDashboard.accessNetwork.diagnosticMode.disabled.summary", new Object[]{String.join((CharSequence)", ", readersDisabledDiagnosticMode)}).withDescription("securityDashboard.accessNetwork.diagnosticMode.description", new Object[0]));
        }
        return items;
    }
}

