/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver;

import com.tridium.nrio.BNrioDevice;
import com.tridiumx.accessDriver.BAccessDeviceFolder;
import com.tridiumx.accessDriver.BAccessDoor;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BBase2ReaderModule;
import com.tridiumx.accessDriver.BSecAlarmSourceInfo;
import com.tridiumx.accessDriver.points.BAccessProxyExt;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;

public abstract class AccessDeviceUtil {
    public static void started(BNrioDevice device) throws Exception {
        if (!(device.getAlarmSourceInfo() instanceof BSecAlarmSourceInfo)) {
            device.setAlarmSourceInfo((BAlarmSourceInfo)BSecAlarmSourceInfo.make(device.getAlarmSourceInfo()));
        }
        device.ping();
    }

    public static Type getNetworkType() {
        return BAccessNetwork.TYPE;
    }

    public static boolean isParentLegal(BComponent parent) {
        return parent instanceof BAccessDeviceFolder || parent instanceof BAccessNetwork;
    }

    public static void fixGeneralUsePoints(BNrioDevice device) {
        int i;
        BOrd[] ords = device.getUsedRelayArray();
        for (i = 0; i < ords.length; ++i) {
            AccessDeviceUtil.fixGeneralUsePoint(device, ords[i], false, true, i + 1);
        }
        ords = device.getUsedSdiArray();
        for (i = 0; i < ords.length; ++i) {
            AccessDeviceUtil.fixGeneralUsePoint(device, ords[i], true, false, i + 1);
        }
        ords = device.getUsedDiArray();
        for (i = 0; i < ords.length; ++i) {
            AccessDeviceUtil.fixGeneralUsePoint(device, ords[i], false, false, i + 1);
        }
    }

    public static void fixGeneralUsePoint(BNrioDevice device, BOrd ord, boolean sdi, boolean writable, int instance) {
        BControlPoint generalUse = AccessDeviceUtil.getGeneralUseInstance(device, sdi, writable, instance);
        if (generalUse == null) {
            return;
        }
        Property p = generalUse.getPropertyInParent();
        if (ord != null) {
            ord = BOrd.make((BOrd)BOrd.make((String)"station:"), (BOrd)ord);
            try {
                ord.get();
            }
            catch (UnresolvedException e) {
                ord = null;
            }
        }
        if (ord != null && ord.get().asComponent().getParent() instanceof BAccessDoor) {
            generalUse.getParent().setFlags((Slot)p, generalUse.getParent().getFlags((Slot)p) | 4);
        } else {
            generalUse.getParent().setFlags((Slot)p, generalUse.getParent().getFlags((Slot)p) & 0xFFFFFFFB);
        }
    }

    public static BControlPoint getGeneralUseInstance(BNrioDevice device, boolean sdi, boolean writable, int instance) {
        BControlPoint[] cps = device.getPoints().getPoints();
        for (int i = 0; i < cps.length; ++i) {
            BAccessProxyExt testProxy = (BAccessProxyExt)cps[i].getProxyExt();
            if (cps[i].getParent() instanceof BAccessDoor || testProxy.getInstance() != instance || testProxy.getIsSdi() != sdi || writable != cps[i].isWritablePoint()) continue;
            return cps[i];
        }
        return null;
    }

    public static boolean getIsRemote(BNrioDevice device) {
        return !(device instanceof BBase2ReaderModule);
    }

    public static BControlPoint checkForProxyExtConflicts(BNrioDevice device, BControlPoint sourcePoint) {
        if (!(sourcePoint.getProxyExt() instanceof BAccessProxyExt)) {
            return null;
        }
        BAccessProxyExt sourceProxy = (BAccessProxyExt)sourcePoint.getProxyExt();
        BControlPoint[] cps = device.getPoints().getPoints();
        for (int i = 0; i < cps.length; ++i) {
            BAccessProxyExt testProxy;
            if (cps[i].getHandle() != null && sourcePoint.getHandle() != null && cps[i].getHandle().equals(sourcePoint.getHandle()) || !(testProxy = (BAccessProxyExt)cps[i].getProxyExt()).getEnabled() || !sourceProxy.getEnabled() || testProxy.getInstance() != sourceProxy.getInstance() || testProxy.getIsSdi() != sourceProxy.getIsSdi() || sourcePoint.isWritablePoint() != cps[i].isWritablePoint()) continue;
            return cps[i];
        }
        return null;
    }
}

