/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.messages;

import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.enums.BIpLonCnFlagsEnum;
import com.tridium.lonIp.enums.BIpLonIpFlagsEnum;
import com.tridium.lonIp.enums.BIpLonNodeTypeEnum;
import com.tridium.lonIp.enums.BIpLonRouterTypeEnum;
import com.tridium.lonIp.messages.LonIpMessage;
import com.tridium.lonworks.util.LonByteArrayUtil;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public class DeviceRegistration
extends LonIpMessage {
    public BDateTime dateTime = BDateTime.DEFAULT;
    public BIpLonIpFlagsEnum ipFlags = NIAGARA_IP_FLAG;
    public BIpLonRouterTypeEnum routerType = NIAGARA_ROUTER_TYPE;
    public BIpLonCnFlagsEnum cnFlags = NIAGARA_FLAG;
    public BIpLonNodeTypeEnum nodeType = NIAGARA_NODE_TYPE;
    public int channelTimeout = 0;
    public int ucIpPort;
    public BIpAddress ucIpAdr = BIpAddress.DEFAULT;
    public BDateTime chanMembershipDt = BDateTime.DEFAULT;
    public BDateTime sendlistDt = BDateTime.DEFAULT;
    public BIpAddress configServerIp = BIpAddress.DEFAULT;
    public BIpAddress primaryTimeIp = BIpAddress.DEFAULT;
    public BIpAddress secondaryTimeIp = BIpAddress.DEFAULT;
    public int configServerPort;
    public int primaryTimePort = 0;
    public int secondaryTimePort = 0;
    public BIpAddress[] mcIps;
    public int[] mcPorts;
    public byte[] id;
    public String name;

    public DeviceRegistration() {
    }

    public DeviceRegistration(int typ) {
        this.packetType = typ;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("dateTime=").append((Object)this.dateTime).append("\n");
        sb.append((Object)this.ipFlags).append(":").append((Object)this.routerType).append(":").append((Object)this.cnFlags).append(":").append((Object)this.nodeType).append("\n");
        sb.append("ipAddress=").append((Object)this.ucIpAdr).append(":").append(this.ucIpPort).append("\n");
        if (!BIpAddress.DEFAULT.equals((Object)this.configServerIp)) {
            sb.append("configServer=").append((Object)this.configServerIp).append(":").append(this.configServerPort).append("\n");
        }
        if (!BIpAddress.DEFAULT.equals((Object)this.primaryTimeIp)) {
            sb.append("primaryTime=").append((Object)this.primaryTimeIp).append(":").append(this.primaryTimePort).append("\n");
        }
        if (!BIpAddress.DEFAULT.equals((Object)this.secondaryTimeIp)) {
            sb.append("secondaryTime=").append((Object)this.secondaryTimeIp).append(":").append(this.secondaryTimePort).append("\n");
        }
        sb.append("chanMembershipDt=").append((Object)this.chanMembershipDt).append("\n");
        sb.append("sendlistDt=").append((Object)this.sendlistDt).append("\n");
        sb.append("id=").append(LonByteArrayUtil.toString((byte[])this.id)).append("\n");
        return sb.toString();
    }

    @Override
    public void fromInputStream(LonInputStream in) throws LonException {
        this.dateTime = BDateTime.fromInputStream(in);
        this.ipFlags = BIpLonIpFlagsEnum.makeValid(in.readUnsigned8());
        this.routerType = BIpLonRouterTypeEnum.makeValid(in.readUnsigned8());
        this.cnFlags = BIpLonCnFlagsEnum.makeValid(in.readUnsigned8());
        this.nodeType = BIpLonNodeTypeEnum.makeValid(in.readUnsigned8());
        int mcAddressCnt = in.readUnsigned8();
        in.readUnsigned8();
        this.channelTimeout = in.readUnsigned16();
        int uniqueIds = in.readUnsigned16();
        this.ucIpPort = in.readUnsigned16();
        this.ucIpAdr = BIpAddress.fromInputStream(in);
        this.chanMembershipDt = BDateTime.fromInputStream(in);
        this.sendlistDt = BDateTime.fromInputStream(in);
        this.configServerIp = BIpAddress.fromInputStream(in);
        this.primaryTimeIp = BIpAddress.fromInputStream(in);
        this.secondaryTimeIp = BIpAddress.fromInputStream(in);
        this.configServerPort = in.readUnsigned16();
        this.primaryTimePort = in.readUnsigned16();
        this.secondaryTimePort = in.readUnsigned16();
        in.readUnsigned16();
        this.mcIps = new BIpAddress[mcAddressCnt];
        this.mcPorts = new int[mcAddressCnt];
        for (int i = 0; i < mcAddressCnt; ++i) {
            this.mcIps[i] = BIpAddress.fromInputStream(in);
            this.mcPorts[i] = in.readUnsigned16();
            in.readUnsigned16();
        }
        this.id = in.readByteArray(uniqueIds);
        int nameLen = in.readUnsigned8();
        this.name = in.readCharArray(nameLen);
    }

    @Override
    public void toOutputStream(LonOutputStream out) {
        int mcAddressCnt = this.mcIps.length;
        this.dateTime.toOutputStream(out);
        out.writeUnsigned8(this.ipFlags.getOrdinal());
        out.writeUnsigned8(this.routerType.getOrdinal());
        out.writeUnsigned8(this.cnFlags.getOrdinal());
        out.writeUnsigned8(this.nodeType.getOrdinal());
        out.writeUnsigned8(mcAddressCnt);
        out.writeUnsigned8(0);
        out.writeUnsigned16(this.channelTimeout);
        out.writeUnsigned16(this.id.length);
        out.writeUnsigned16(this.ucIpPort);
        this.ucIpAdr.toOutputStream(out);
        this.chanMembershipDt.toOutputStream(out);
        this.sendlistDt.toOutputStream(out);
        this.configServerIp.toOutputStream(out);
        this.primaryTimeIp.toOutputStream(out);
        this.secondaryTimeIp.toOutputStream(out);
        out.writeUnsigned16(this.configServerPort);
        out.writeUnsigned16(this.primaryTimePort);
        out.writeUnsigned16(this.secondaryTimePort);
        out.writeUnsigned16(0);
        for (int i = 0; i < mcAddressCnt; ++i) {
            this.mcIps[i].toOutputStream(out);
            out.writeUnsigned16(this.mcPorts[i]);
            out.writeUnsigned16(0);
        }
        out.writeByteArray(this.id);
        int nameLen = this.name.length() + 1;
        out.writeUnsigned8(nameLen);
        out.writeCharArray(this.name, nameLen);
    }
}

