/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.datatypes;

import com.tridium.lonIp.ChannelMonitor;
import com.tridium.lonIp.ConfigServer;
import com.tridium.lonIp.datatypes.BChannelMember;
import com.tridium.lonIp.datatypes.BIpLonNetworkConfig;
import com.tridium.lonIp.datatypes.BMemberTable;
import com.tridium.lonIp.util.LonIpAddressManager;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="networkConfig", type="BIpLonNetworkConfig", defaultValue="new BIpLonNetworkConfig()"), @NiagaraProperty(name="memberTable", type="BMemberTable", defaultValue="new BMemberTable()")})
@NiagaraAction(name="channelMonitorTimeout", flags=4)
@NiagaraTopic(name="statusResponse", eventType="BString")
public class BIpChannel
extends BComponent {
    @Generated
    public static final Property networkConfig = BIpChannel.newProperty((int)0, (BValue)new BIpLonNetworkConfig(), null);
    @Generated
    public static final Property memberTable = BIpChannel.newProperty((int)0, (BValue)new BMemberTable(), null);
    @Generated
    public static final Action channelMonitorTimeout = BIpChannel.newAction((int)4, null);
    @Generated
    public static final Topic statusResponse = BIpChannel.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BIpChannel.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"cloud.png"), (BIcon)BIcon.std((String)"badges/gear.png"));
    ChannelMonitor chanMon;
    ConfigServer cnfgSrv;
    LonIpAddressManager adrMan;

    @Generated
    public BIpLonNetworkConfig getNetworkConfig() {
        return (BIpLonNetworkConfig)this.get(networkConfig);
    }

    @Generated
    public void setNetworkConfig(BIpLonNetworkConfig v) {
        this.set(networkConfig, (BValue)v, null);
    }

    @Generated
    public BMemberTable getMemberTable() {
        return (BMemberTable)this.get(memberTable);
    }

    @Generated
    public void setMemberTable(BMemberTable v) {
        this.set(memberTable, (BValue)v, null);
    }

    @Generated
    public void channelMonitorTimeout() {
        this.invoke(channelMonitorTimeout, null, null);
    }

    @Generated
    public void fireStatusResponse(BString event) {
        this.fire(statusResponse, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(networkConfig) && cx != BMemberTable.internalChange) {
            this.chanMon.networkConfigChanged(cx);
            this.cnfgSrv.networkConfigChanged(cx);
        }
    }

    public void registerChannelMonitor(ChannelMonitor cm) {
        this.chanMon = cm;
    }

    public void registerConfigServer(ConfigServer cs) {
        this.cnfgSrv = cs;
    }

    public void registerAddressManager(LonIpAddressManager am) {
        this.adrMan = am;
    }

    public ChannelMonitor getChannelMonitor() {
        return this.chanMon;
    }

    public ConfigServer getConfigServer() {
        return this.cnfgSrv;
    }

    public LonIpAddressManager getAddressManager() {
        return this.adrMan;
    }

    public void doChannelMonitorTimeout() {
        if (this.chanMon != null) {
            this.chanMon.channelTimerCallback();
        }
    }

    public BChannelMember getLocalMember() {
        BChannelMember[] mems = this.getMemberTable().getChannelMembers();
        BIpLonNetworkConfig netCfg = this.getNetworkConfig();
        for (int i = 0; i < mems.length; ++i) {
            if (!netCfg.isLocal(mems[i])) continue;
            return mems[i];
        }
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        this.chanMon.spy(out);
    }
}

