/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp;

import com.tridium.lonIp.link.LonIpLinkLayer;
import com.tridium.lonworks.loncomm.NAppBuffer;
import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.QueryStatusResponse;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.enums.BLonNodeState;

public class NetMangementListener
implements NetMessages {
    private BLonNetwork lonworks;
    private LonComm lonComm;
    private BLocalLonDevice local;
    private LonIpLinkLayer link;

    public NetMangementListener(LonIpLinkLayer link, LonComm lonComm, BLonNetwork lonworks) {
        this.lonComm = lonComm;
        this.lonworks = lonworks;
        this.link = link;
        this.local = lonworks.getLocalLonDevice();
    }

    public boolean receiveLonMessage(NAppBuffer ab) {
        switch (ab.getMessageCode()) {
            case 81: {
                this.respondToQueryStatus(ab);
                return true;
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 108: {
                this.sendSuccessResponse(ab);
                return true;
            }
            case 82: 
            case 83: 
            case 84: 
            case 97: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 125: {
                this.sendFailedResponse(ab);
                return true;
            }
        }
        return false;
    }

    private void respondToQueryStatus(NAppBuffer ab) {
        QueryStatusResponse rsp = new QueryStatusResponse();
        rsp.nodeState = this.getNodeState(this.local.getDeviceData().getNodeState());
        this.link.sendResponse(ab, (LonMessage)rsp);
    }

    private int getNodeState(BLonNodeState nodeState) {
        switch (nodeState.getOrdinal()) {
            case 0: 
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 6;
            }
        }
        return 0;
    }

    private void sendSuccessResponse(NAppBuffer ab) {
        LonMessage rsp = new LonMessage();
        rsp.setMessageCode(ab.getMessageCode() - 64);
        this.link.sendResponse(ab, rsp);
    }

    private void sendFailedResponse(NAppBuffer ab) {
        LonMessage rsp = new LonMessage();
        rsp.setMessageCode(ab.getMessageCode() - 96);
        this.link.sendResponse(ab, rsp);
    }
}

