/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemDb.orient;

import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.tridium.systemDb.BSystemDb;
import com.tridium.systemDb.BSystemDbService;
import com.tridium.systemDb.orient.BOrientSystemDb;
import com.tridium.systemDb.orient.OrientSystemDbConnection;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.baja.naming.SlotPath;
import javax.baja.spy.ISpyDir;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.owasp.encoder.Encode;

public class OrientSystemDbSpy
extends Spy
implements ISpyDir {
    private static final String INFO_PREFIX = "info_";
    private static final String NAV = "nav";
    private static final String NONE_FOUND = "None found";
    private static final int SHOW_TAGS = 1;
    private static final int SHOW_RELATIONS = 2;
    private static final int SHOW_SCOPED_EDGES = 4;
    private static final int HIDE_ANCESTOR_DESCENDANT_ENTITIES = 8;
    private final Object object;
    private final int showInfoMask;

    public OrientSystemDbSpy(Object object, int showInfoMask) {
        this.object = object;
        this.showInfoMask = showInfoMask;
    }

    public String[] list() {
        return OrientSystemDbConnection.EMPTY_STRING_ARRAY;
    }

    public Spy find(String name) {
        try {
            if (this.object instanceof BOrientSystemDb && NAV.equals(name)) {
                return new OrientSystemDbSpy(null, 0);
            }
            if (this.object instanceof ORecordId && name.startsWith(INFO_PREFIX)) {
                return new OrientSystemDbSpy(this.object, Integer.parseInt(name.substring(INFO_PREFIX.length())));
            }
            return new OrientSystemDbSpy(new ORecordId(SlotPath.unescape((String)name)), 0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void write(SpyWriter out) throws Exception {
        block56: {
            int linkBackupDepth;
            int n = linkBackupDepth = this.showInfoMask != 0 ? 1 : 0;
            if (this.object == null) {
                BSystemDbService systemDbService = (BSystemDbService)Sys.getService((Type)BSystemDbService.TYPE);
                BSystemDb systemDb = systemDbService.getSystemDatabase();
                try (OrientSystemDbConnection conn = (OrientSystemDbConnection)systemDb.makeConnection(null);
                     OResultSet query = conn.getGraph().query("SELECT FROM V WHERE in_scopedEdge IS NULL", (Object[])OrientSystemDbConnection.EMPTY_STRING_ARRAY);
                     Stream<OVertex> roots = StreamSupport.stream(query.vertexStream().spliterator(), false);){
                    OrientSystemDbSpy.createTableForEntities(out, roots, "Root Entities (Vertices) in Orient", true, linkBackupDepth);
                    break block56;
                }
            }
            if (this.object instanceof BOrientSystemDb) {
                ((BOrientSystemDb)((Object)this.object)).spyOrientTotals(out, false);
                out.startProps();
                out.propValueLink((Object)"Orient Graph", (Object)NAV, (Object)"Navigate (this link could take time to load)");
                out.endProps();
            } else if (this.object instanceof ORecordId) {
                BSystemDbService systemDbService = (BSystemDbService)Sys.getService((Type)BSystemDbService.TYPE);
                BSystemDb systemDb = systemDbService.getSystemDatabase();
                try (OrientSystemDbConnection conn = (OrientSystemDbConnection)systemDb.makeConnection(null);){
                    OElement element = (OElement)conn.getGraph().load((ORID)((ORecordId)this.object));
                    if (element == null) {
                        out.startProps();
                        out.prop((Object)"No record found for Orient ID (perhaps a reindex occurred)", this.object);
                        out.endProps();
                    }
                    if (element instanceof OEdge) {
                        OrientSystemDbSpy.createSpyForEdge(out, (OEdge)element);
                    }
                    if (element instanceof OVertex) {
                        this.createSpyForVertex(out, (OVertex)element, linkBackupDepth);
                    }
                    out.startProps();
                    out.prop((Object)("Unexpected Orient Type for Orient ID " + this.object), element.getClass());
                    out.endProps();
                }
            } else {
                out.startProps();
                out.prop((Object)("Unexpected Spy Object " + this.object), this.object.getClass());
                out.endProps();
            }
        }
    }

    private void createSpyForVertex(SpyWriter out, OVertex vertex, int linkBackupDepth) {
        out.startProps();
        out.trTitle((Object)"Orient Vertex Info", 2);
        out.prop((Object)"Vertex Orient ID", (Object)vertex.getIdentity());
        String entityOrd = (String)vertex.getProperty("__id");
        out.propValueLink((Object)"Entity ORD (Hyperlink to Station Space)", (Object)entityOrd, (Object)entityOrd);
        out.prop((Object)"Cached Category Mask", (Runnable)vertex.getProperty("CategoryMask"));
        String tagTypes = (String)vertex.getProperty("TagTypes");
        if (tagTypes != null) {
            out.prop((Object)"Non-inferrable Tag Types", (Object)tagTypes);
        }
        this.addShowHideInfoLink(out, 1, "Tags");
        this.addShowHideInfoLink(out, 2, "Relations");
        this.addShowHideInfoLink(out, 4, "Scoped Edges");
        this.addShowHideInfoLink(out, 8, "Nearest Ancestor/Descendant Entities", "Hide ", "Show ");
        out.endProps();
        if (this.showSpy(1)) {
            OrientSystemDbSpy.createTableForElementTags(out, (OElement)vertex);
        }
        if (this.showSpy(2)) {
            this.createTableForVertexEdges(out, vertex, "Entity Relations (stored as Edges in Orient)", false);
        }
        if (this.showSpy(4)) {
            this.createTableForVertexEdges(out, vertex, "Scoped Edges (stored as lightweight Edges in Orient)", true);
        }
        if (!this.showSpy(8)) {
            try (Stream<OVertex> ancestorEntities = StreamSupport.stream(vertex.getEdges(ODirection.IN, new String[]{"scopedEdge"}).spliterator(), false).map(scopedEdge -> scopedEdge.getVertex(ODirection.OUT));){
                OrientSystemDbSpy.createTableForEntities(out, ancestorEntities, "Nearest Ancestor Entity (Vertex from inbound scoped edge in Orient - should be only one)", false, linkBackupDepth + 2);
            }
            var7_7 = null;
            try (Stream<OVertex> descendantEntities = StreamSupport.stream(vertex.getEdges(ODirection.OUT, new String[]{"scopedEdge"}).spliterator(), false).map(scopedEdge -> scopedEdge.getVertex(ODirection.IN));){
                OrientSystemDbSpy.createTableForEntities(out, descendantEntities, "Nearest Descendant Entities (Vertices from outbound scoped edges in Orient)", false, linkBackupDepth);
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
        }
    }

    private void addShowHideInfoLink(SpyWriter out, int spyBitsToCheck, String title) {
        this.addShowHideInfoLink(out, spyBitsToCheck, title, "Show ", "Hide ");
    }

    private void addShowHideInfoLink(SpyWriter out, int spyBitToCheck, String title, String titlePrefixWhenBitUnset, String titlePrefixWhenBitSet) {
        if (this.showInfoMask == 0) {
            out.propNameLink((Object)(INFO_PREFIX + spyBitToCheck), (Object)(titlePrefixWhenBitUnset + title), (Object)"");
        } else if (!this.showSpy(spyBitToCheck)) {
            out.unsafe().prop((Object)("<a href='../info_" + this.newSpyMaskWithMoreBits(spyBitToCheck) + "'>" + Encode.forHtml((String)(titlePrefixWhenBitUnset + title)) + "</a>"), (Object)"");
        } else {
            int newSpyMask = this.newSpyMaskWithLessBits(spyBitToCheck);
            String href = newSpyMask != 0 ? "../info_" + newSpyMask : "../";
            out.propNameLink((Object)href, (Object)(titlePrefixWhenBitSet + title), (Object)"");
        }
    }

    private boolean showSpy(int bitMask) {
        return (this.showInfoMask & bitMask) == bitMask;
    }

    private int newSpyMaskWithMoreBits(int bitsToAdd) {
        return this.showInfoMask | bitsToAdd;
    }

    private int newSpyMaskWithLessBits(int bitsToRemove) {
        return this.showInfoMask & ~bitsToRemove;
    }

    private static void createSpyForEdge(SpyWriter out, OEdge edge) {
        out.startProps();
        out.trTitle((Object)"Orient Edge Info", 2);
        out.prop((Object)"Edge Orient ID", (Object)edge.getIdentity());
        Optional edgeType = edge.getSchemaType();
        edgeType.ifPresent(eType -> out.prop((Object)"Relation ID", (Object)OrientSystemDbConnection.unescapeFromOrientForm(eType.getName())));
        out.propValueLink((Object)"Outbound Vertex Orient ID", (Object)SlotPath.escape((String)edge.getFrom().getIdentity().toString()), (Object)edge.getFrom().getIdentity());
        String entityOrd = (String)edge.getFrom().getProperty("__id");
        out.propValueLink((Object)"Outbound Entity ORD (Hyperlink to Station Space)", (Object)entityOrd, (Object)entityOrd);
        out.propValueLink((Object)"Inbound Vertex Orient ID", (Object)SlotPath.escape((String)edge.getTo().getIdentity().toString()), (Object)edge.getTo().getIdentity());
        entityOrd = (String)edge.getTo().getProperty("__id");
        out.propValueLink((Object)"Inbound Entity ORD (Hyperlink to Station Space)", (Object)entityOrd, (Object)entityOrd);
        String tagTypes = (String)edge.getProperty("TagTypes");
        if (tagTypes != null) {
            out.prop((Object)"Non-inferrable Tag Types", (Object)tagTypes);
        }
        out.endProps();
        OrientSystemDbSpy.createTableForElementTags(out, (OElement)edge);
    }

    private static void createTableForElementTags(SpyWriter out, OElement element) {
        out.startProps();
        boolean isEdge = element.isEdge();
        String title = isEdge ? "Relation Tags (stored as Edge Properties in Orient)" : "Entity Tags (stored as Vertex Properties in Orient)";
        out.trTitle((Object)title, 1);
        AtomicBoolean foundFirst = new AtomicBoolean();
        element.getPropertyNames().stream().sorted(String.CASE_INSENSITIVE_ORDER).forEachOrdered(propName -> {
            Object value;
            if ((isEdge || OrientSystemDbConnection.isTagProperty(propName)) && !((value = element.getProperty(propName)) instanceof ORidBag) && !(value instanceof ODocument)) {
                if (!foundFirst.getAndSet(true)) {
                    out.endProps();
                    out.startTable(true);
                    out.tr();
                    out.thTitle((Object)"Tag ID");
                    out.thTitle((Object)"Value");
                    out.thTitle((Object)"Type in Orient (May be different from Niagara Tag Type)");
                    out.endTr();
                }
                out.tr();
                out.td((Object)OrientSystemDbConnection.unescapeFromOrientForm(propName));
                out.td(value);
                out.td((Object)value.getClass().getSimpleName());
                out.endTr();
            }
        });
        if (foundFirst.get()) {
            out.endTable();
        } else {
            out.prop((Object)NONE_FOUND, (Object)"");
            out.endProps();
        }
    }

    private void createTableForVertexEdges(SpyWriter out, OVertex vertex, String title, boolean onlyScopedEdges) {
        out.startProps();
        out.trTitle((Object)title, 1);
        AtomicBoolean foundFirst = new AtomicBoolean();
        Iterable edges = onlyScopedEdges ? vertex.getEdges(ODirection.BOTH, new String[]{"scopedEdge"}) : vertex.getEdges(ODirection.BOTH);
        StreamSupport.stream(edges.spliterator(), false).filter(edge -> !edge.isLightweight() && !onlyScopedEdges || edge.isLightweight() && onlyScopedEdges).sorted(Comparator.comparing(edge -> {
            OVertex fromVertex = edge.getFrom();
            if (vertex.getIdentity().equals(fromVertex.getIdentity())) {
                if (onlyScopedEdges) {
                    return (String)edge.getTo().getProperty("__id");
                }
                Optional edgeType = edge.getSchemaType();
                String prefix = edgeType.map(eType -> eType.getName() + ' ').orElse("");
                return prefix + edge.getTo().getProperty("__id");
            }
            if (onlyScopedEdges) {
                return (String)fromVertex.getProperty("__id");
            }
            Optional edgeType = edge.getSchemaType();
            String prefix = edgeType.map(eType -> eType.getName() + ' ').orElse("");
            return prefix + fromVertex.getProperty("__id");
        }, String.CASE_INSENSITIVE_ORDER)).forEachOrdered(edge -> {
            Optional edgeType;
            String hrefPrefix;
            if (!foundFirst.getAndSet(true)) {
                out.endProps();
                out.startTable(true);
                out.tr();
                if (!onlyScopedEdges) {
                    out.thTitle((Object)"Relation ID");
                }
                out.thTitle((Object)"Direction");
                out.thTitle((Object)"Endpoint Orient ID");
                out.w((Object)("<th align='left' nowrap='true' bgcolor='#d0d0d0' colspan='2'>" + out.href("Endpoint ORD (Hyperlink to Station Space)"))).endTh();
                out.endTr();
            }
            out.tr();
            OVertex otherVertex = edge.getFrom();
            String string = hrefPrefix = this.showInfoMask != 0 ? "../" : "";
            if (vertex.getIdentity().equals(otherVertex.getIdentity())) {
                if (!onlyScopedEdges) {
                    edgeType = edge.getSchemaType();
                    String edgeTypeName = edgeType.map(eType -> eType.getName()).orElse("Unknown");
                    out.td().a(hrefPrefix + SlotPath.escape((String)edge.getIdentity().toString()), (Object)OrientSystemDbConnection.unescapeFromOrientForm(edgeTypeName)).endTd();
                }
                out.td((Object)"Out");
                otherVertex = edge.getTo();
            } else {
                if (!onlyScopedEdges) {
                    edgeType = edge.getSchemaType();
                    String edgeTypeName = edgeType.map(eType -> eType.getName()).orElse("Unknown");
                    out.td().a(hrefPrefix + SlotPath.escape((String)edge.getIdentity().toString()), (Object)OrientSystemDbConnection.unescapeFromOrientForm(edgeTypeName)).endTd();
                }
                out.td((Object)"In");
            }
            out.td().a(hrefPrefix + SlotPath.escape((String)otherVertex.getIdentity().toString()), (Object)otherVertex.getIdentity()).endTd();
            String entityOrd = (String)otherVertex.getProperty("__id");
            out.td((Object)entityOrd);
            out.td().a(entityOrd, (Object)"Link").endTd();
            out.endTr();
        });
        if (foundFirst.get()) {
            out.endTable();
        } else {
            out.prop((Object)NONE_FOUND, (Object)"");
            out.endProps();
        }
    }

    private static void createTableForEntities(SpyWriter out, Stream<OVertex> entities, String title, boolean alwaysShowTitle, int linkBackupDepth) {
        if (alwaysShowTitle) {
            out.startProps();
            out.trTitle((Object)title, 2);
        }
        AtomicBoolean foundFirst = new AtomicBoolean();
        entities.sorted(Comparator.comparing(v -> (String)v.getProperty("__id"), String.CASE_INSENSITIVE_ORDER)).forEachOrdered(vertex -> {
            if (!foundFirst.getAndSet(true)) {
                if (!alwaysShowTitle) {
                    out.startProps();
                    out.trTitle((Object)title, 2);
                }
                out.endProps();
                out.startTable(true);
                out.tr();
                out.thTitle((Object)"Vertex Orient ID");
                out.w((Object)("<th align='left' nowrap='true' bgcolor='#d0d0d0' colspan='2'>" + out.href("Entity ORD (Hyperlink to Station Space)"))).endTh();
                out.endTr();
            }
            out.tr();
            if (linkBackupDepth > 0) {
                StringBuilder backupPrefix = new StringBuilder("../");
                for (int i = 1; i < linkBackupDepth; ++i) {
                    backupPrefix.append("../");
                }
                out.td().a(backupPrefix + SlotPath.escape((String)vertex.getIdentity().toString()), (Object)vertex.getIdentity()).endTd();
            } else {
                out.td().a(SlotPath.escape((String)vertex.getIdentity().toString()), (Object)vertex.getIdentity()).endTd();
            }
            String entityOrd = (String)vertex.getProperty("__id");
            out.td((Object)entityOrd);
            out.td().a(entityOrd, (Object)"Link").endTd();
            out.endTr();
        });
        if (foundFirst.get()) {
            out.endTable();
        } else if (alwaysShowTitle) {
            out.prop((Object)NONE_FOUND, (Object)"");
            out.endProps();
        }
    }
}

