/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.docdeveloper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.types.text.BJavascriptFile;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="help", type="BOrd", defaultValue="BOrd.NULL", flags=260), @NiagaraProperty(name="defaultJsFile", type="BOrd", defaultValue="BOrd.NULL", flags=4), @NiagaraProperty(name="enableSave", type="boolean", defaultValue="false", flags=260)})
@NiagaraActions(value={@NiagaraAction(name="save", parameterType="BString", defaultValue="BString.DEFAULT", returnType="BString", flags=260), @NiagaraAction(name="load", parameterType="BString", defaultValue="BString.DEFAULT", returnType="BString", flags=260)})
public final class BJsPlayground
extends BComponent {
    @Generated
    public static final Property help = BJsPlayground.newProperty((int)260, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property defaultJsFile = BJsPlayground.newProperty((int)4, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property enableSave = BJsPlayground.newProperty((int)260, (boolean)false, null);
    @Generated
    public static final Action save = BJsPlayground.newAction((int)260, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action load = BJsPlayground.newAction((int)260, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJsPlayground.class);
    private static final BIcon icon = BIcon.std((String)"script.png");
    private static final String userDirName = "jsPlaygroundCode";

    @Generated
    public BOrd getHelp() {
        return (BOrd)this.get(help);
    }

    @Generated
    public void setHelp(BOrd v) {
        this.set(help, (BValue)v, null);
    }

    @Generated
    public BOrd getDefaultJsFile() {
        return (BOrd)this.get(defaultJsFile);
    }

    @Generated
    public void setDefaultJsFile(BOrd v) {
        this.set(defaultJsFile, (BValue)v, null);
    }

    @Generated
    public boolean getEnableSave() {
        return this.getBoolean(enableSave);
    }

    @Generated
    public void setEnableSave(boolean v) {
        this.setBoolean(enableSave, v, null);
    }

    @Generated
    public BString save(BString parameter) {
        return (BString)this.invoke(save, (BValue)parameter, null);
    }

    @Generated
    public BString load(BString parameter) {
        return (BString)this.invoke(load, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BString doLoad(BString id, Context cx) throws Exception {
        if (id.getString().isEmpty()) {
            BIFile file;
            if (!this.getDefaultJsFile().isNull() && (file = (BIFile)this.getDefaultJsFile().get((BObject)BLocalHost.INSTANCE, cx)) instanceof BJavascriptFile) {
                return BString.make((String)BajaFileUtil.readString((BIFile)file));
            }
        } else {
            File userFile;
            File userCodeDir = new File(Sys.getStationHome(), userDirName);
            if (userCodeDir.exists() && (userFile = new File(userCodeDir, id + ".js")).exists()) {
                return BString.make((String)FileUtil.readString((File)userFile));
            }
        }
        return BString.DEFAULT;
    }

    public BString doSave(BString jsCode) throws Exception {
        String code = jsCode.toString();
        String id = BUuid.make().toCompactString().replace('*', '0').replace('$', '1');
        File userCodeDir = new File(Sys.getStationHome(), userDirName);
        if (!userCodeDir.exists() && !userCodeDir.mkdir()) {
            throw new IOException("Could not create User Code Directory");
        }
        File codeFile = new File(userCodeDir, id + ".js");
        try (FileOutputStream out = new FileOutputStream(codeFile);){
            out.write(code.getBytes("UTF-8"));
        }
        return BString.make((String)id);
    }

    public BIcon getIcon() {
        return icon;
    }
}

