/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.backup;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Supplier;

public final class SlicedOutputStream
extends OutputStream {
    private final int limit;
    private final Supplier<OutputStream> outFactory;
    private OutputStream out;
    private int count;

    public SlicedOutputStream(int limit, Supplier<OutputStream> outFactory) {
        if (limit <= 0) {
            throw new IndexOutOfBoundsException("Limit must be great than zero");
        }
        this.limit = limit;
        this.outFactory = outFactory;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.out == null) {
            this.out = this.outFactory.get();
        }
        this.out.write(b);
        if (++this.count >= this.limit) {
            this.count = 0;
            this.out.flush();
            this.out.close();
            this.out = this.outFactory.get();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.out == null) {
            this.out = this.outFactory.get();
        }
        while (len >= this.limit - this.count) {
            int newLen = this.limit - this.count;
            this.out.write(b, off, newLen);
            off += newLen;
            len -= newLen;
            this.count = 0;
            this.out.flush();
            this.out.close();
            this.out = this.outFactory.get();
        }
        if (len > 0) {
            this.out.write(b, off, len);
            this.count += len;
            if (this.count >= this.limit) {
                this.count = 0;
                this.out.flush();
                this.out.close();
                this.out = this.outFactory.get();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            try (OutputStream o = this.out;){
                o.flush();
            }
        }
    }
}

