/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nvideo.display;

import com.tridium.nvideo.display.BDisplayDeviceExt;
import com.tridium.videoDriver.display.BIVideoDisplay;
import com.tridium.videoDriver.display.BIVideoLocation;
import java.util.ArrayList;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="locationId", type="BValue", defaultValue="\"\"")
public class BVideoLocation
extends BComponent
implements BIVideoLocation,
BIDeviceFolder {
    @Generated
    public static final Property locationId = BVideoLocation.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BVideoLocation.class);
    private static final BIcon icon = BIcon.make((String)"module://videoDriver/icons/displayExt.png");

    @Generated
    public BValue getLocationId() {
        return this.get(locationId);
    }

    @Generated
    public void setLocationId(BValue v) {
        this.set(locationId, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type getDeviceFolderType() {
        return this.getDisplayDeviceExt().getLocationType();
    }

    public final Type getDeviceType() {
        return this.getDisplayType();
    }

    public Type getDisplayType() {
        return this.getDisplayDeviceExt().getDisplayType();
    }

    public BIVideoDisplay[] getAllDisplays() {
        ArrayList<BIVideoDisplay> list = new ArrayList<BIVideoDisplay>();
        this.getAllDisplays(this, this.getDisplayType(), list);
        return list.toArray(new BIVideoDisplay[0]);
    }

    private void getAllDisplays(BComponent comp, Type displayType, ArrayList<BIVideoDisplay> list) {
        SlotCursor cursor = comp.loadSlots().getProperties();
        while (cursor.nextComponent()) {
            BComponent kid = cursor.get().asComponent();
            if (kid.getType().is(displayType)) {
                list.add((BIVideoDisplay)kid);
                continue;
            }
            this.getAllDisplays(kid, displayType, list);
        }
    }

    public void updateStatus() {
        BIVideoDisplay[] displays = this.getAllDisplays();
        for (int i = 0; i < displays.length; ++i) {
            if (!(displays[i] instanceof BDevice)) continue;
            ((BDevice)displays[i]).updateStatus();
        }
    }

    public BDeviceNetwork getNetwork() {
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BDeviceNetwork)) continue;
            return (BDeviceNetwork)parent;
        }
        return null;
    }

    public BDisplayDeviceExt getDisplayDeviceExt() {
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BDisplayDeviceExt)) continue;
            return (BDisplayDeviceExt)parent;
        }
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }
}

