/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nvideo.camera.controlHelper;

import com.tridium.nvideo.BVideoNetwork;
import com.tridium.nvideo.camera.BVideoCamera;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BCameraControlHelper
extends BComponent
implements Runnable {
    @Generated
    public static final Type TYPE = Sys.loadType(BCameraControlHelper.class);
    protected Object controlReference;
    protected final Object doneReference;
    protected long keepAliveTimeStamp;
    protected boolean done;
    protected boolean beenDone;
    protected boolean scheduled;
    protected BVideoCamera camera;
    Clock.Ticket ticket = null;
    protected boolean inQ;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCameraControlHelper() {
        this.camera = null;
        this.doneReference = null;
    }

    public BCameraControlHelper(BVideoCamera camera, Object doneReference) {
        this.camera = camera;
        this.doneReference = doneReference;
        this.keepAliveTimeStamp = Clock.ticks();
        this.done = false;
    }

    public void doReevaluate() {
        this.enqueue();
    }

    private synchronized void enqueue() {
        if (this.inQ) {
            return;
        }
        this.inQ = true;
        ((BVideoNetwork)this.camera.getNetwork()).getAsync().post((Runnable)this);
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = null;
    }

    public void controlCamera(Object controlReference) {
        this.keepAlive();
        this.done = false;
        this.controlReference = controlReference;
        if (controlReference != this.doneReference) {
            this.beenDone = false;
        }
        this.enqueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BCameraControlHelper bCameraControlHelper = this;
        synchronized (bCameraControlHelper) {
            this.inQ = false;
        }
        if (this.isDone()) {
            if (!this.beenDone) {
                this.onStopControlling();
                this.beenDone = true;
            }
        } else {
            this.onControlling();
            BRelTime resendInterval = this.getResendInterval();
            if (resendInterval.getMillis() > 0L) {
                this.ticket = Clock.schedule((BComponent)this.camera, (BRelTime)resendInterval, (Action)BVideoCamera.reevaluate, (BValue)this);
            }
        }
    }

    public void keepAlive() {
        this.keepAliveTimeStamp = Clock.ticks();
    }

    public boolean isDone() {
        return this.done || this.controlReference == this.doneReference || Clock.ticks() - this.keepAliveTimeStamp > this.getWatchdogTimeout().getMillis();
    }

    public void stopControlling() {
        this.done = true;
    }

    public abstract BRelTime getResendInterval();

    public abstract BRelTime getWatchdogTimeout();

    protected abstract void onStopControlling();

    protected abstract void onControlling();
}

