/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.portal.util;

import com.tridium.nre.util.NiagaraFiles;
import com.tridium.portal.api.PortalApi;
import java.io.File;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.xml.XElem;

public final class LicenseDownload {
    private static final Logger log = Logger.getLogger("portalApi");

    private LicenseDownload() {
    }

    public static void main(String[] args) {
        block7: {
            try {
                if (PortalApi.checkConnectivity()) {
                    XElem[] licenses = PortalApi.getLicenses(PortalApi.MY_HOST_ID, PortalApi.getLocalBrandId(), Sys.getBajaVersion());
                    if (licenses == null || licenses.length == 0) {
                        log.warning("No licenses found.");
                        return;
                    }
                    XElem[] licenseElems = licenses[0].elems("license");
                    String[] vendorsArray = LicenseDownload.licenseToVendors(licenseElems);
                    XElem[] certificateElems = PortalApi.getCertificates(vendorsArray);
                    LicenseDownload.copyLicenses(licenseElems);
                    if (certificateElems == null || certificateElems.length == 0) {
                        log.warning("No certificates found.");
                    } else {
                        LicenseDownload.copyCertificates(certificateElems);
                    }
                    log.info("Successfully imported licenses for host " + PortalApi.MY_HOST_ID);
                } else {
                    log.warning("Unable to connect to portal.");
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not connect to portal: {}", e.getLocalizedMessage());
                if (!log.isLoggable(Level.FINE)) break block7;
                log.log(Level.FINE, "Caused by: ", e);
            }
        }
    }

    public static void copyLicenses(XElem[] licenses) throws Exception {
        File dir = NiagaraFiles.getPerpetualLicensePath();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new BajaRuntimeException("Cannot create directory " + dir.getAbsolutePath());
        }
        for (XElem license : licenses) {
            File f = new File(dir, LicenseDownload.getFilePrefix(license) + ".license");
            log.fine("writing license file '" + f + "'...");
            license.write(f);
        }
    }

    public static void copyCertificates(XElem[] certificates) throws Exception {
        File dir = NiagaraFiles.getPerpetualCertificatesPath();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new BajaRuntimeException("Cannot create directory " + dir.getAbsolutePath());
        }
        for (XElem certificate : certificates) {
            File f = new File(dir, LicenseDownload.getFilePrefix(certificate) + ".certificate");
            log.fine("writing certificate file '" + f + "'...");
            certificate.write(f);
        }
    }

    private static String getFilePrefix(XElem license) {
        for (XElem feature : license.elems("feature")) {
            String result;
            if (!"brand".equals(feature.get("name", null)) || (result = feature.get("brandId", null)) == null) continue;
            return TextUtil.capitalize((String)result);
        }
        return TextUtil.capitalize((String)license.get("vendor"));
    }

    public static String[] licenseToVendors(XElem[] licenseElems) {
        HashSet<String> vendorsFound = new HashSet<String>();
        for (XElem licenseElem : licenseElems) {
            String vendor = licenseElem.get("vendor", null);
            if (vendor == null) continue;
            vendorsFound.add(vendor);
        }
        return vendorsFound.toArray(new String[0]);
    }
}

