/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.portal.api;

import com.tridium.portal.api.PortalApi;
import java.util.ArrayList;
import java.util.Base64;
import javax.baja.nre.util.TextUtil;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public class XLicense {
    public static final String NOT_FOUND = "Not Found";
    public static final String PENDING = "Pending";
    public static final String ACTIVE = "Active";
    public static final String EXPIRED = "Expired";
    public static final String REVOKED = "Revoked";
    public String hostId;
    public String name;
    public String company;
    public String email;
    public String po;
    public String version;
    public String file;
    private ArrayList<String[]> dynamic = new ArrayList(8);

    public void add(String name, String value) {
        this.dynamic.add(new String[]{name, value});
    }

    public String get(String name) {
        if (name.equals("hostId")) {
            return this.hostId;
        }
        if (name.equals("name")) {
            return name;
        }
        if (name.equals("company")) {
            return this.company;
        }
        if (name.equals("email")) {
            return this.email;
        }
        if (name.equals("po")) {
            return this.po;
        }
        if (name.equals("version")) {
            return this.version;
        }
        for (String[] attr : this.dynamic) {
            if (!attr[0].equals(name)) continue;
            return attr[1];
        }
        return null;
    }

    public String toSubmitString() {
        StringBuilder s = new StringBuilder();
        this.append(s, "hostId", this.hostId, PortalApi.MY_HOST_ID);
        this.append(s, "name", this.name, "<your name>");
        this.append(s, "company", this.company, "<your company>");
        this.append(s, "email", this.email, "<your email>");
        this.append(s, "po", this.po, "<po number if applicable>");
        this.append(s, "version", this.version, "" + PortalApi.VERSION);
        return s.toString();
    }

    private void append(StringBuilder s, String name, String val, String def) {
        s.append(name).append(':');
        s.append(TextUtil.getSpaces((int)(8 - name.length())));
        if (val == null || val.length() == 0) {
            s.append(def);
        } else {
            s.append(val);
        }
        s.append('\n');
    }

    public XElem encode(String elemName) {
        XElem elem = new XElem(elemName);
        this.encode(elem, "hostId", this.hostId);
        this.encode(elem, "name", this.name);
        this.encode(elem, "company", this.company);
        this.encode(elem, "email", this.email);
        this.encode(elem, "po", this.po);
        this.encode(elem, "version", this.version);
        for (String[] attr : this.dynamic) {
            this.encode(elem, attr[0], attr[1]);
        }
        if (this.file != null) {
            XElem xfile = new XElem("file");
            xfile.addText(Base64.getMimeEncoder(70, new byte[]{10}).encodeToString(this.file.getBytes()));
            elem.addContent((XContent)xfile);
        }
        return elem;
    }

    private void encode(XElem elem, String key, String value) {
        if (value != null) {
            elem.addAttr(key, value);
        }
    }

    public static XLicense decode(XElem elem) {
        XLicense lic = new XLicense();
        lic.hostId = elem.get("hostId", null);
        lic.name = elem.get("name", null);
        lic.company = elem.get("company", null);
        lic.email = elem.get("email", null);
        lic.po = elem.get("po", null);
        lic.version = elem.get("version", null);
        XElem xfile = elem.elem("file");
        if (xfile != null) {
            lic.file = new String(Base64.getMimeDecoder().decode(xfile.string()));
        }
        return lic;
    }
}

