/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.ui;

import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.registry.Registry;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BForecast;
import javax.baja.weather.BWeatherProvider;
import javax.baja.weather.BWeatherReport;
import javax.baja.weather.advisory.BAdvisory;
import javax.baja.weather.advisory.BAdvisoryContainer;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"weather:WeatherService"}, requiredPermissions="W")})
public class BWeatherManager
extends BAbstractManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BWeatherManager.class);
    static Lexicon lex = Lexicon.make((String)"weather");
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colCurrent = new CurrentColumn();
    MgrColumn colToday = new ForecastColumn(lex.getText("today"), 0);
    MgrColumn colTomorrow = new ForecastColumn(lex.getText("tomorrow"), 1);
    MgrColumn colSunrise = new SunriseColumn();
    MgrColumn colStatus = new MgrColumn.Prop(BWeatherReport.status, 6);
    MgrColumn colProvider = new MgrColumn.Prop(BWeatherReport.provider, 3);
    MgrColumn colAdvisory = new AdvisoryColumn();
    protected MgrColumn[] cols = new MgrColumn[]{this.colName, this.colCurrent, this.colToday, this.colTomorrow, this.colAdvisory, this.colSunrise, this.colStatus, this.colProvider};

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    class AdvisoryColumn
    extends MgrColumn {
        public AdvisoryColumn() {
            super(lex.getText("advisory"));
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (value != null) {
                return ((BAdvisory)value).getWeatherSummary().getValue();
            }
            return lex.getText("advisory.none");
        }

        public Object get(Object row) {
            BWeatherReport report = (BWeatherReport)row;
            BAdvisoryContainer adv = report.getCurrent().getAdvisories();
            adv.lease();
            Object[] advisories = adv.getChildren(BAdvisory.class);
            if (advisories.length > 0) {
                ((BAdvisory)advisories[0]).lease();
                return advisories[0];
            }
            return null;
        }
    }

    class CurrentColumn
    extends MgrColumn.Prop {
        public CurrentColumn() {
            super(BWeatherReport.current, 4);
        }

        public Object get(Object row) {
            BComplex complex = (BComplex)row;
            BCurrentConditions curr = (BCurrentConditions)complex.get(this.prop);
            curr.lease();
            return curr;
        }
    }

    class SunriseColumn
    extends MgrColumn.Prop {
        public SunriseColumn() {
            super(lex.getText("sunrise.sunset"), BWeatherReport.current, 4);
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            BCurrentConditions r = (BCurrentConditions)value;
            return "" + r.getSunrise() + '/' + r.getSunset();
        }

        public Object toSortKey(Object row) {
            BCurrentConditions conditions = (BCurrentConditions)super.toSortKey(row);
            return conditions.getSunrise();
        }
    }

    class ForecastColumn
    extends MgrColumn {
        int index;

        public ForecastColumn(String name, int index) {
            super(name, 4);
            this.index = 0;
            this.index = index;
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (value == null) {
                return "-";
            }
            return ((BForecast)value).toString(cx);
        }

        public Object get(Object row) {
            BWeatherReport report = (BWeatherReport)row;
            report.lease();
            BForecast[] forecasts = report.getForecast();
            if (this.index < forecasts.length) {
                BForecast forecast = report.getForecast()[this.index];
                forecast.lease();
                return forecast;
            }
            return null;
        }
    }

    class Model
    extends MgrModel {
        Model(BWeatherManager mgr) {
            super((BAbstractManager)mgr);
        }

        protected String makeTableTitle() {
            return TYPE.getDisplayName(null);
        }

        protected MgrColumn[] makeColumns() {
            return this.appendMixInColumns(BWeatherManager.this.cols, BWeatherReport.TYPE);
        }

        public int getSubscribeDepth() {
            return 2;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BWeatherReport.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            Registry reg = Sys.getRegistry();
            TypeInfo[] t = reg.getTypes(BWeatherProvider.TYPE.getTypeInfo());
            Array types = new Array(MgrTypeInfo.class);
            for (TypeInfo typeInfo : t) {
                Type type = typeInfo.getTypeSpec().getResolvedType();
                if (type.equals(BWeatherProvider.TYPE)) continue;
                types.add((Object)MgrTypeInfo.make((BComponent)((BComponent)type.getInstance())));
            }
            return (MgrTypeInfo[])types.trim();
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BWeatherReport report = new BWeatherReport();
            report.setProvider((BWeatherProvider)type.newInstance());
            return report;
        }
    }
}

