/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.ui;

import com.tridium.weather.ui.BCurrentWeatherView;
import com.tridium.weather.ui.BWeatherIconSize;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.weather.BForecast;
import javax.baja.weather.BWeatherState;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"weather:Forecast"})})
@NiagaraProperties(value={@NiagaraProperty(name="iconSize", type="BWeatherIconSize", defaultValue="BWeatherIconSize.x64"), @NiagaraProperty(name="tempFont", type="BFont", defaultValue="BFont.make(lex.getText(\"temp.font\"))"), @NiagaraProperty(name="tempBrush", type="BBrush", defaultValue="BColor.black.toBrush()"), @NiagaraProperty(name="summaryFont", type="BFont", defaultValue="BFont.make(lex.getText(\"state.font\"))"), @NiagaraProperty(name="summaryBrush", type="BBrush", defaultValue="BColor.black.toBrush()"), @NiagaraProperty(name="halign", type="BHalign", defaultValue="BHalign.center"), @NiagaraProperty(name="valign", type="BValign", defaultValue="BValign.center")})
public class BForecastView
extends BWbComponentView {
    private static final Lexicon lex = Lexicon.make((String)"weather");
    @Generated
    public static final Property iconSize = BForecastView.newProperty((int)0, (BValue)BWeatherIconSize.x64, null);
    @Generated
    public static final Property tempFont = BForecastView.newProperty((int)0, (BValue)BFont.make((String)lex.getText("temp.font")), null);
    @Generated
    public static final Property tempBrush = BForecastView.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    @Generated
    public static final Property summaryFont = BForecastView.newProperty((int)0, (BValue)BFont.make((String)lex.getText("state.font")), null);
    @Generated
    public static final Property summaryBrush = BForecastView.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    @Generated
    public static final Property halign = BForecastView.newProperty((int)0, (BValue)BHalign.center, null);
    @Generated
    public static final Property valign = BForecastView.newProperty((int)0, (BValue)BValign.center, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BForecastView.class);

    @Generated
    public BWeatherIconSize getIconSize() {
        return (BWeatherIconSize)this.get(iconSize);
    }

    @Generated
    public void setIconSize(BWeatherIconSize v) {
        this.set(iconSize, (BValue)v, null);
    }

    @Generated
    public BFont getTempFont() {
        return (BFont)this.get(tempFont);
    }

    @Generated
    public void setTempFont(BFont v) {
        this.set(tempFont, (BValue)v, null);
    }

    @Generated
    public BBrush getTempBrush() {
        return (BBrush)this.get(tempBrush);
    }

    @Generated
    public void setTempBrush(BBrush v) {
        this.set(tempBrush, (BValue)v, null);
    }

    @Generated
    public BFont getSummaryFont() {
        return (BFont)this.get(summaryFont);
    }

    @Generated
    public void setSummaryFont(BFont v) {
        this.set(summaryFont, (BValue)v, null);
    }

    @Generated
    public BBrush getSummaryBrush() {
        return (BBrush)this.get(summaryBrush);
    }

    @Generated
    public void setSummaryBrush(BBrush v) {
        this.set(summaryBrush, (BValue)v, null);
    }

    @Generated
    public BHalign getHalign() {
        return (BHalign)this.get(halign);
    }

    @Generated
    public void setHalign(BHalign v) {
        this.set(halign, (BValue)v, null);
    }

    @Generated
    public BValign getValign() {
        return (BValign)this.get(valign);
    }

    @Generated
    public void setValign(BValign v) {
        this.set(valign, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (this.getCurrentValue() == null) {
            return;
        }
        if (prop.equals(iconSize) || prop.equals(tempFont) || prop.equals(tempBrush) || prop.equals(summaryFont) || prop.equals(summaryBrush) || prop.equals(halign) || prop.equals(valign)) {
            this.loadValue(this.getCurrentValue(), this.getCurrentContext());
        }
    }

    protected void doLoadValue(BObject v, Context cx) {
        BFacets mergedFacets;
        BForecast f = (BForecast)v;
        StringBuilder sb = new StringBuilder();
        if (f.getHigh().getStatus().isValid()) {
            mergedFacets = f.getSlotFacets((Slot)BForecast.high);
            if (cx != null) {
                mergedFacets = BFacets.make((BFacets)cx.getFacets(), (BFacets)f.getSlotFacets((Slot)BForecast.high));
            }
            sb.append(f.getHigh().valueToString((Context)mergedFacets));
        } else {
            sb.append('-');
        }
        sb.append('/');
        if (f.getLow().getStatus().isValid()) {
            mergedFacets = f.getSlotFacets((Slot)BForecast.low);
            if (cx != null) {
                mergedFacets = BFacets.make((BFacets)cx.getFacets(), (BFacets)f.getSlotFacets((Slot)BForecast.low));
            }
            sb.append(f.getLow().valueToString((Context)mergedFacets));
        } else {
            sb.append('-');
        }
        BLabel temp = new BLabel(sb.toString());
        temp.setFont(this.getTempFont());
        temp.setForeground(this.getTempBrush());
        BGridPane right = new BGridPane(1);
        right.setRowGap(1.0);
        right.add(null, (BValue)temp);
        String img = "unknown";
        if (f.getState().getStatus().isValid()) {
            BDynamicEnum ws = (BDynamicEnum)f.getState().getValueValue();
            String s = ws.toString();
            BLabel sum = new BLabel(s);
            sum.setFont(this.getSummaryFont());
            sum.setForeground(this.getSummaryBrush());
            right.add(null, (BValue)sum);
            if (!ws.equals((Object)new BStatusEnum((BEnum)BWeatherState.unknown).getValue())) {
                img = BCurrentWeatherView.getWeatherIcon((BEnum)ws);
            }
        }
        String size = this.getIconSize() == BWeatherIconSize.x64 ? "64" : "32";
        BLabel icon = new BLabel(BImage.make((String)("module://weather/rc/" + img + size + ".png")));
        if (f.getPrecipChance().getStatus().isValid()) {
            BLabel precip = new BLabel(lex.get("precipitation") + ": " + f.getPrecipChance().valueToString((Context)f.getSlotFacets((Slot)BForecast.precipChance)));
            precip.setFont(this.getSummaryFont());
            precip.setForeground(this.getSummaryBrush());
            right.add(null, (BValue)precip);
        }
        BGridPane grid = new BGridPane(2);
        grid.setColumnGap(6.0);
        grid.add("icon", (BValue)icon);
        grid.add("desc", (BValue)right);
        grid.setHalign(this.getHalign());
        grid.setValign(this.getValign());
        this.setContent((BWidget)grid);
        this.registerForComponentEvents((BComponent)f);
    }

    public void handleComponentEvent(BComponentEvent event) {
        BComponent c = event.getSourceComponent();
        if (c == this.getCurrentValue()) {
            this.doLoadValue((BObject)c, this.getCurrentContext());
            this.relayout();
        }
    }
}

