/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitpx;

import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;

@NiagaraType(agent={@AgentOn(types={"bajaui:Widget"})})
@NiagaraProperties(value={@NiagaraProperty(name="widgetProperty", type="String", defaultValue="fill"), @NiagaraProperty(name="lowColor", type="BColor", defaultValue="BColor.blue"), @NiagaraProperty(name="midColor", type="BColor", defaultValue="BColor.white"), @NiagaraProperty(name="highColor", type="BColor", defaultValue="BColor.red"), @NiagaraProperty(name="setpoint", type="double", defaultValue="50"), @NiagaraProperty(name="extent", type="double", defaultValue="100")})
public class BSpectrumBinding
extends BBinding {
    @Generated
    public static final Property widgetProperty = BSpectrumBinding.newProperty((int)0, (String)"fill", null);
    @Generated
    public static final Property lowColor = BSpectrumBinding.newProperty((int)0, (BValue)BColor.blue, null);
    @Generated
    public static final Property midColor = BSpectrumBinding.newProperty((int)0, (BValue)BColor.white, null);
    @Generated
    public static final Property highColor = BSpectrumBinding.newProperty((int)0, (BValue)BColor.red, null);
    @Generated
    public static final Property setpoint = BSpectrumBinding.newProperty((int)0, (int)50, null);
    @Generated
    public static final Property extent = BSpectrumBinding.newProperty((int)0, (int)100, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSpectrumBinding.class);

    @Generated
    public String getWidgetProperty() {
        return this.getString(widgetProperty);
    }

    @Generated
    public void setWidgetProperty(String v) {
        this.setString(widgetProperty, v, null);
    }

    @Generated
    public BColor getLowColor() {
        return (BColor)this.get(lowColor);
    }

    @Generated
    public void setLowColor(BColor v) {
        this.set(lowColor, (BValue)v, null);
    }

    @Generated
    public BColor getMidColor() {
        return (BColor)this.get(midColor);
    }

    @Generated
    public void setMidColor(BColor v) {
        this.set(midColor, (BValue)v, null);
    }

    @Generated
    public BColor getHighColor() {
        return (BColor)this.get(highColor);
    }

    @Generated
    public void setHighColor(BColor v) {
        this.set(highColor, (BValue)v, null);
    }

    @Generated
    public double getSetpoint() {
        return this.getDouble(setpoint);
    }

    @Generated
    public void setSetpoint(double v) {
        this.setDouble(setpoint, v, null);
    }

    @Generated
    public double getExtent() {
        return this.getDouble(extent);
    }

    @Generated
    public void setExtent(double v) {
        this.setDouble(extent, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BValue getOnWidget(Property prop) {
        BObject target;
        if (prop.getName().equals(this.getWidgetProperty()) && this.isBound() && (target = this.get()) instanceof BINumeric) {
            double value = ((BINumeric)target).getNumeric();
            BColor color = this.solveColor(value);
            if (prop.getType().is(BBrush.TYPE)) {
                return color.toBrush();
            }
            if (prop.getType().is(BColor.TYPE)) {
                return color;
            }
        }
        return super.getOnWidget(prop);
    }

    BColor solveColor(double value) {
        int alpha;
        int blue;
        int green;
        int red;
        double mid = this.getSetpoint();
        double delta = this.getExtent() / 2.0;
        BColor lowColor = this.getLowColor();
        BColor midColor = this.getMidColor();
        BColor highColor = this.getHighColor();
        if (value < mid) {
            if (value < mid - delta) {
                return lowColor;
            }
            double mRed = (double)(midColor.getRed() - lowColor.getRed()) / delta;
            double bRed = (double)midColor.getRed() - mRed * mid;
            red = (int)(mRed * value + bRed);
            double mGreen = (double)(midColor.getGreen() - lowColor.getGreen()) / delta;
            double bGreen = (double)midColor.getGreen() - mGreen * mid;
            green = (int)(mGreen * value + bGreen);
            double mBlue = (double)(midColor.getBlue() - lowColor.getBlue()) / delta;
            double bBlue = (double)midColor.getBlue() - mBlue * mid;
            blue = (int)(mBlue * value + bBlue);
            double mAlpha = (double)(midColor.getAlpha() - lowColor.getAlpha()) / delta;
            double bAlpha = (double)midColor.getAlpha() - mAlpha * mid;
            alpha = (int)(mAlpha * value + bAlpha);
        } else {
            if (value > mid + delta) {
                return highColor;
            }
            double mRed = (double)(highColor.getRed() - midColor.getRed()) / delta;
            double bRed = (double)midColor.getRed() - mRed * mid;
            red = (int)(mRed * value + bRed);
            double mGreen = (double)(highColor.getGreen() - midColor.getGreen()) / delta;
            double bGreen = (double)midColor.getGreen() - mGreen * mid;
            green = (int)(mGreen * value + bGreen);
            double mBlue = (double)(highColor.getBlue() - midColor.getBlue()) / delta;
            double bBlue = (double)midColor.getBlue() - mBlue * mid;
            blue = (int)(mBlue * value + bBlue);
            double mAlpha = (double)(highColor.getAlpha() - midColor.getAlpha()) / delta;
            double bAlpha = (double)midColor.getAlpha() - mAlpha * mid;
            alpha = (int)(mAlpha * value + bAlpha);
        }
        return BColor.make((int)red, (int)green, (int)blue, (int)alpha);
    }
}

