/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitpx;

import com.tridium.kitpx.BButtonGroupStyle;
import com.tridium.util.CompUtil;
import java.util.HashMap;
import java.util.Map;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BBinding;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;

@NiagaraType
@NiagaraProperty(name="style", type="BButtonGroupStyle", defaultValue="BButtonGroupStyle.radio")
public class BButtonGroupBinding
extends BBinding {
    @Generated
    public static final Property style = BButtonGroupBinding.newProperty((int)0, (BValue)BButtonGroupStyle.radio, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BButtonGroupBinding.class);
    private ToggleCommand[] cmds = null;
    Map<Integer, Integer> ordinalToCmdMap = null;

    @Generated
    public BButtonGroupStyle getStyle() {
        return (BButtonGroupStyle)this.get(style);
    }

    @Generated
    public void setStyle(BButtonGroupStyle v) {
        this.set(style, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isDegraded() {
        return !this.isBound() || !this.getTarget().canInvoke();
    }

    public void targetChanged() {
        String type;
        if (this.cmds == null) {
            this.init();
        }
        if ((type = this.get().getType().toString()).equals("control:BooleanWritable")) {
            this.booleanChanged();
        } else if (type.equals("control:EnumWritable")) {
            this.enumChanged();
        }
        super.targetChanged();
    }

    private void init() {
        String type = this.get().getType().toString();
        if (type.equals("control:BooleanWritable")) {
            this.booleanInit();
        } else if (type.equals("control:EnumWritable")) {
            this.enumInit();
        } else {
            System.out.println("Unknown type: " + type);
        }
    }

    private void booleanInit() {
        BWidget w = this.getWidget();
        final OrdTarget target = this.getTarget();
        final BComponent c = target.get().asComponent();
        final Action action = c.getAction("set");
        String trueText = "true";
        String falseText = "false";
        BFacets facets = (BFacets)c.get("facets");
        if (facets != null) {
            String s = facets.gets("trueText", null);
            if (s != null) {
                trueText = s;
            }
            if ((s = facets.gets("falseText", null)) != null) {
                falseText = s;
            }
        }
        this.cmds = new ToggleCommand[2];
        this.cmds[0] = new ToggleCommand(w, trueText){

            public CommandArtifact doInvoke() {
                if (this.isSelected()) {
                    c.invoke(action, (BValue)BBoolean.TRUE, (Context)target);
                }
                return null;
            }
        };
        this.cmds[1] = new ToggleCommand(w, falseText){

            public CommandArtifact doInvoke() {
                if (this.isSelected()) {
                    c.invoke(action, (BValue)BBoolean.FALSE, (Context)target);
                }
                return null;
            }
        };
        ToggleCommandGroup g = new ToggleCommandGroup();
        g.add(this.cmds[0]);
        g.add(this.cmds[1]);
        BToggleButton trueButton = this.makeButton(this.cmds[0]);
        BToggleButton falseButton = this.makeButton(this.cmds[1]);
        w.add(null, (BValue)trueButton, 2);
        w.add(null, (BValue)falseButton, 2);
    }

    private void booleanChanged() {
        BStatusBoolean sb = (BStatusBoolean)this.get().asComponent().get("out");
        if (sb.getValue()) {
            this.cmds[0].setSelected(true);
        } else {
            this.cmds[1].setSelected(true);
        }
    }

    private void enumInit() {
        BEnumRange r;
        BWidget w = this.getWidget();
        final OrdTarget target = this.getTarget();
        final BComponent c = target.get().asComponent();
        final Action action = c.getAction("set");
        BDynamicEnum enums = ((BStatusEnum)c.get("out")).getValue();
        BEnumRange range = enums.getRange();
        BFacets facets = (BFacets)c.get("facets");
        if (facets != null && (r = (BEnumRange)facets.getFacet("range")) != null) {
            range = r;
        }
        int[] ords = range.getOrdinals();
        this.cmds = new ToggleCommand[ords.length];
        ToggleCommandGroup g = new ToggleCommandGroup();
        this.ordinalToCmdMap = new HashMap<Integer, Integer>();
        BAbstractButton[] children = (BAbstractButton[])w.getChildren(BAbstractButton.class);
        for (int j = 0; j < children.length; ++j) {
            w.remove((BComplex)children[j]);
        }
        for (int i = 0; i < ords.length; ++i) {
            final int ord = ords[i];
            final BEnumRange r2 = range;
            String displayName = range.getDisplayTag(ord, null);
            this.cmds[i] = new ToggleCommand(w, displayName){

                public CommandArtifact doInvoke() {
                    if (this.isSelected()) {
                        BDynamicEnum val = BDynamicEnum.make((int)ord, (BEnumRange)r2);
                        c.invoke(action, (BValue)val, (Context)target);
                    }
                    return null;
                }
            };
            g.add(this.cmds[i]);
            BToggleButton xButton = null;
            BToggleButton button = this.makeButton(this.cmds[i]);
            if (children.length > 0 && (xButton = (BToggleButton)children[i]) != null && xButton.getText().equals(displayName)) {
                CompUtil.copyProperties((BComponent)button, (BComponent)xButton, null);
                button.setText(displayName);
            }
            w.add(null, (BValue)button, 0);
            this.ordinalToCmdMap.put(ord, i);
        }
    }

    private void enumChanged() {
        Integer idx;
        BDynamicEnum enums = ((BStatusEnum)this.get().asComponent().get("out")).getValue();
        if (this.ordinalToCmdMap != null && (idx = this.ordinalToCmdMap.get(enums.getOrdinal())) != null) {
            this.cmds[idx].setSelected(true);
        }
    }

    private BToggleButton makeButton(ToggleCommand c) {
        if (this.getStyle() == BButtonGroupStyle.radio) {
            return new BRadioButton(c);
        }
        return new BToggleButton((Command)c);
    }
}

