/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.iotdep;

import com.tridium.cloud.client.NiagaraMessageType;
import com.tridium.cloud.client.iotdep.BIMessageQueue;
import com.tridium.cloud.client.iotdep.internal.AmqpMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="queueSize", type="long", defaultValue="1048576", facets={@Facet(name="BFacets.MIN", value="1024"), @Facet(name="BFacets.MAX", value="Long.MAX_VALUE")}), @NiagaraProperty(name="weight", type="int", defaultValue="1", facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")})})
public class BMessageQueue
extends BComponent
implements BIMessageQueue {
    public static final Property queueSize = BMessageQueue.newProperty((int)0, (int)0x100000, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1024), (BFacets)BFacets.make((String)"max", (long)Long.MAX_VALUE)));
    public static final Property weight = BMessageQueue.newProperty((int)0, (int)1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    public static final Type TYPE = Sys.loadType(BMessageQueue.class);
    private final ArrayList<AmqpMessage> queue = new ArrayList();
    private final Map<String, AmqpMessage> pendingSet = new HashMap<String, AmqpMessage>();
    private final AtomicLong dataSize = new AtomicLong(0L);
    private long queueDataSizeErrorCount = 0L;
    private long totalQueueDataSizeRecalculationTime = 0L;
    private static final Logger log = Logger.getLogger("cloud.iotmsg.queue");

    public long getQueueSize() {
        return this.getLong(queueSize);
    }

    @Override
    public void setQueueSize(long v) {
        this.setLong(queueSize, v, null);
    }

    @Override
    public int getWeight() {
        return this.getInt(weight);
    }

    @Override
    public void setWeight(int v) {
        this.setInt(weight, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.queue.clear();
        this.pendingSet.clear();
        this.dataSize.set(0L);
    }

    public void stopped() throws Exception {
        this.clear();
        super.stopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueueMessage(AmqpMessage message, CompletableFuture<String> future) {
        log.finer(() -> "entering enqueueMessage for " + message.getMessageId());
        message.setFuture(future);
        if (this.getQueueSize() <= this.dataSize.get()) {
            future.completeExceptionally(new IOException("Queue full, try again later."));
            log.finer(() -> "exiting enqueueMessage, queue full enqueue failed for " + message.getMessageId());
            return;
        }
        ArrayList<AmqpMessage> arrayList = this.queue;
        synchronized (arrayList) {
            this.queue.add(message);
            this.dataSize.getAndAdd(message.getPayload().length);
        }
        log.finer(() -> "exiting enqueueMessage for " + message.getMessageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmqpMessage pullMessage() {
        AmqpMessage message;
        log.finer(() -> "entering pullMessage");
        if (this.queue.isEmpty()) {
            log.finer(() -> "exiting pullMessage, queue empty");
            return null;
        }
        try {
            ArrayList<AmqpMessage> arrayList = this.queue;
            synchronized (arrayList) {
                message = this.queue.remove(0);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            log.finer(() -> "exiting pullMessage, queue empty (out of bounds)");
            return null;
        }
        this.pendingSet.put(message.getMessageId(), message);
        log.finer(() -> "exiting pullMessage, returning message " + message.getMessageId());
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retryMessage(String messageId) {
        log.finer(() -> "entering retryMessage for " + messageId);
        boolean messageFound = false;
        ArrayList<AmqpMessage> arrayList = this.queue;
        synchronized (arrayList) {
            AmqpMessage message = this.pendingSet.remove(messageId);
            if (message != null) {
                this.queue.add(0, message);
                messageFound = true;
            }
        }
        if (messageFound) {
            log.finer(() -> "exiting retryMessage, message requeued for " + messageId);
        } else {
            log.finer(() -> "exiting retryMessage, message not found for " + messageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dequeueMessage(String messageId, Throwable ex) {
        AmqpMessage message;
        log.finer(() -> "entering dequeueMessage for " + messageId);
        ArrayList<AmqpMessage> arrayList = this.queue;
        synchronized (arrayList) {
            message = this.pendingSet.remove(messageId);
            if (message != null) {
                this.dataSize.getAndAdd(-message.getPayload().length);
            }
        }
        if (message != null) {
            if (this.dataSize.get() < 0L) {
                arrayList = this.queue;
                synchronized (arrayList) {
                    ++this.queueDataSizeErrorCount;
                    long start = BAbsTime.now().getMillis();
                    this.dataSize.set(0L);
                    for (AmqpMessage am : this.queue) {
                        this.dataSize.getAndAdd(am.getPayload().length);
                    }
                    for (AmqpMessage am : this.pendingSet.values()) {
                        this.dataSize.getAndAdd(am.getPayload().length);
                    }
                    long recalcTime = BAbsTime.now().getMillis() - start;
                    log.warning(() -> String.format("BMessageQueue, dataSize below zero recalculated queue size in %d ms.", recalcTime));
                    this.totalQueueDataSizeRecalculationTime += recalcTime;
                }
            }
            if (ex == null) {
                message.getFuture().complete(messageId);
                log.finer(() -> "exiting dequeueMessage, success for " + messageId);
            } else {
                message.getFuture().completeExceptionally(ex);
                log.finer(() -> "exiting dequeueMessage, exceptionally for " + messageId);
            }
        } else {
            log.finer(() -> "exiting retryMessage, message not found for " + messageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        log.finer(() -> "entering clear");
        ArrayList<AmqpMessage> arrayList = this.queue;
        synchronized (arrayList) {
            for (AmqpMessage am : this.queue) {
                log.finest(() -> "removing queued message with id " + am.getMessageId());
                am.getFuture().cancel(true);
            }
            for (AmqpMessage am : this.pendingSet.values()) {
                log.finest(() -> "removing pending message with id " + am.getMessageId());
                am.getFuture().cancel(true);
            }
            this.queue.clear();
            this.pendingSet.clear();
            this.dataSize.set(0L);
        }
        log.finer(() -> "exiting clear");
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean isFull() {
        return this.getQueueSize() <= this.dataSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(NiagaraMessageType msgType) {
        log.finer(() -> "entering remove");
        ArrayList<String> messageIds = new ArrayList<String>();
        ArrayList<AmqpMessage> arrayList = this.queue;
        synchronized (arrayList) {
            for (int i = this.queue.size() - 1; i >= 0; --i) {
                AmqpMessage message = this.queue.get(i);
                if (message == null || message.getNiagaraMessageType() == null || !message.getNiagaraMessageType().name().equals(msgType.name())) continue;
                this.queue.remove(i);
                this.dataSize.getAndAdd(-message.getPayload().length);
                messageIds.add(message.getMessageId());
            }
        }
        for (String messageId : messageIds) {
            log.finer(() -> "removing message from queue, success for " + messageId);
        }
        log.finer(() -> "exiting remove");
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("IoT Hub Message Queue");
        out.prop((Object)"Queue Data Size Error Count", (double)this.queueDataSizeErrorCount);
        out.prop((Object)"Total Queue Data Size Recalculation time (ms)", (double)this.totalQueueDataSizeRecalculationTime);
        out.endProps();
        super.spy(out);
    }
}

