/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.proton.transport.proxy;

import java.util.Locale;
import java.util.Objects;

public final class HttpStatusLine {
    private final String httpVersion;
    private final int statusCode;
    private final String reason;

    private HttpStatusLine(String protocolVersion, int statusCode, String reason) {
        this.httpVersion = Objects.requireNonNull(protocolVersion, "'httpVersion' cannot be null.");
        this.statusCode = statusCode;
        this.reason = Objects.requireNonNull(reason, "'reason' cannot be null.");
    }

    public static HttpStatusLine create(String line) {
        int statusCode;
        String[] components = line.split(" ", 3);
        if (components.length != 3) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "HTTP status-line is invalid. Line: %s", line));
        }
        String[] protocol = components[0].split("/", 2);
        if (protocol.length != 2) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Protocol is invalid, expected HTTP/{version}. Actual: %s", components[0]));
        }
        try {
            statusCode = Integer.parseInt(components[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format(Locale.US, "HTTP Status code '%s' is not valid.", components[1]), e);
        }
        return new HttpStatusLine(protocol[1], statusCode, components[2]);
    }

    public String getProtocolVersion() {
        return this.httpVersion;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReason() {
        return this.reason;
    }
}

