/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.sql;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.rdb.BResultSetTable;
import com.tridium.rdb.fox.BSqlSchemeChannel;
import com.tridium.rdb.sql.SqlParser;
import com.tridium.rdb.util.PasswordUtils;
import java.io.StringReader;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.SQLException;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsSession;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.sql.SqlQuery;
import javax.baja.rdb.sql.SqlSchemeConsumer;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ordScheme="sql")
@NiagaraSingleton
public class BSqlScheme
extends BOrdScheme {
    @Generated
    public static final BSqlScheme INSTANCE = new BSqlScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BSqlScheme.class);
    private static final boolean NIAGARA_SQL_PARSER_DISABLED = AccessController.doPrivileged(() -> Boolean.parseBoolean(System.getProperty("niagara.sql.parser.disable", "false")));

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSqlScheme() {
        super("sql");
    }

    public OrdQuery parse(String queryBody) {
        return new SqlQuery(queryBody);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery ordQuery) throws SyntaxException, UnresolvedException {
        Connection connection = null;
        try {
            if (!(base.getComponent().getSession() instanceof BFoxSession)) {
                ConnectionAndContext cc = this.obtainConnectionAndContext(base);
                connection = cc.connection;
                RdbmsContext cx = cc.context;
                String sql = ordQuery.getBody();
                if (NIAGARA_SQL_PARSER_DISABLED) {
                    OrdTarget ordTarget = new OrdTarget(base, new BResultSetTable(connection, sql, cx));
                    return ordTarget;
                }
                SqlParser parser = new SqlParser(new StringReader(sql), true);
                if (parser.parse() != 0) {
                    throw new SQLException(BSqlScheme.makeErrorMessage(parser));
                }
                String parametricQuery = parser.getQuery();
                Object[] params = parser.getParameters();
                OrdTarget ordTarget = new OrdTarget(base, new BResultSetTable(connection, parametricQuery, params, cx));
                return ordTarget;
            }
            BFoxChannelRegistry channels = ((BFoxSession)base.getComponent().getSession()).getConnection().getChannels();
            BSqlSchemeChannel channel = (BSqlSchemeChannel)channels.get("sql", BSqlSchemeChannel.TYPE);
            OrdTarget sql = channel.resolve(base);
            return sql;
        }
        catch (Exception e) {
            String msg = !PasswordUtils.isPasswordChangeAllowed(BOrd.toSession((BObject)base.get())) ? "Access denied: SQL scheme usage is restricted to sessions connected via FOXS" : "Could not resolve " + base + ", " + ordQuery;
            Throwable cause = e.getCause();
            if (cause != null) {
                String msg2 = cause.getLocalizedMessage();
                throw new UnresolvedException(msg + ". " + msg2, (Throwable)e);
            }
            if (!(base.getComponent().getSession() instanceof BFoxSession)) {
                throw new UnresolvedException(msg, (Throwable)e);
            }
            throw new UnresolvedException(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
        }
    }

    public void resolve(SqlSchemeConsumer consumer, OrdTarget base, OrdQuery ordQuery) {
        Connection connection = null;
        try {
            ConnectionAndContext cc = this.obtainConnectionAndContext(base);
            connection = cc.connection;
            RdbmsContext cx = cc.context;
            String sql = ordQuery.getBody();
            if (NIAGARA_SQL_PARSER_DISABLED) {
                BResultSetTable.load(consumer, connection, sql, null, cx);
            } else {
                SqlParser parser = new SqlParser(new StringReader(sql), true);
                if (parser.parse() != 0) {
                    throw new SQLException(BSqlScheme.makeErrorMessage(parser));
                }
                String parametricQuery = parser.getQuery();
                Object[] params = parser.getParameters();
                BResultSetTable.load(consumer, connection, parametricQuery, params, cx);
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String msg = "Could not resolve " + base + ", " + ordQuery + ".  " + e.getLocalizedMessage();
            if (cause != null) {
                msg = msg + e.getCause().getLocalizedMessage();
            }
            throw new UnresolvedException(msg, (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
        }
    }

    private static String makeErrorMessage(SqlParser parser) {
        return "Syntax error near: \"" + parser.getQuery().trim() + "\"\nUnexpected token \" " + parser.text().trim() + "\" at line: " + parser.line() + ", column: " + parser.column();
    }

    private ConnectionAndContext obtainConnectionAndContext(OrdTarget base) throws Exception {
        BRdbms db;
        BObject baseObject = base.get();
        if (baseObject instanceof BRdbms) {
            db = (BRdbms)baseObject;
        } else {
            BRdbmsSession session = (BRdbmsSession)BOrd.toSession((BObject)baseObject);
            session.connect();
            db = session.getDatabase();
        }
        db.lease();
        if (!db.getSqlSchemeEnabled()) {
            throw new BajaRuntimeException("The 'sql' scheme is not enabled.");
        }
        BPermissions permissions = db.getPermissions((Context)base);
        if (!permissions.hasAdminWrite() || !permissions.hasAdminInvoke()) {
            throw new PermissionException();
        }
        return new ConnectionAndContext(db.getConnection(db.getUserName(), db.getPassword()), db.getRdbmsContext());
    }

    private static class ConnectionAndContext {
        Connection connection;
        RdbmsContext context;

        ConnectionAndContext(Connection connection, RdbmsContext context) {
            this.connection = connection;
            this.context = context;
        }
    }
}

