/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.history;

import com.tridium.nre.util.tuple.Pair;
import com.tridium.rdb.BRdbmsDeprecatedDialect;
import com.tridium.rdb.history.RdbmsHistoryUtil;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.trans.BSqlType;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Logger;
import javax.baja.collection.TableCursor;
import javax.baja.driver.history.BHistoryExport;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BTrendRecord;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.HistoryQuery;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.history.BRdbmsHistoryDeviceExt;
import javax.baja.rdb.history.BRdbmsHistoryExportMode;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="userName", type="String", defaultValue=""), @NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="lastTimestamp", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65), @NiagaraProperty(name="exportInvalidValues", type="boolean", defaultValue="true")})
public abstract class BRdbmsHistoryExport
extends BHistoryExport {
    @Generated
    public static final Property userName = BRdbmsHistoryExport.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property password = BRdbmsHistoryExport.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property lastTimestamp = BRdbmsHistoryExport.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property exportInvalidValues = BRdbmsHistoryExport.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRdbmsHistoryExport.class);
    private BRdbmsHistoryDeviceExt devicelet;
    private BRdbms db;
    private BRdbmsDeprecatedDialect dialect;
    private Connection conn;
    private Statement stmt;
    private BIHistory history;
    private BHistoryConfig config;
    private BHistoryRecord template;
    private static final Logger LOG = Logger.getLogger("rdb");
    private static final BFacets SHOW_MILLIS = BFacets.make((String)"showMilliseconds", (boolean)true);
    private boolean isNewSchema;
    private static final int DEFAULT_EXPORT_BATCH_SIZE = 1000;
    private static final Integer EXPORT_BATCH_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("niagara.rdb.historyExport.batchSize", 1000));
    private static final String HISTORY_ID = "HISTORY_ID";

    @Generated
    public String getUserName() {
        return this.getString(userName);
    }

    @Generated
    public void setUserName(String v) {
        this.setString(userName, v, null);
    }

    @Generated
    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    @Generated
    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastTimestamp() {
        return (BAbsTime)this.get(lastTimestamp);
    }

    @Generated
    public void setLastTimestamp(BAbsTime v) {
        this.set(lastTimestamp, (BValue)v, null);
    }

    @Generated
    public boolean getExportInvalidValues() {
        return this.getBoolean(exportInvalidValues);
    }

    @Generated
    public void setExportInvalidValues(boolean v) {
        this.setBoolean(exportInvalidValues, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute() {
        this.devicelet = (BRdbmsHistoryDeviceExt)this.getDeviceExt();
        this.db = (BRdbms)this.devicelet.getDevice();
        if (!this.db.getEnabled()) {
            this.logTrace("database disabled, on thread " + Thread.currentThread().getName());
            this.setState(BDescriptorState.idle);
            this.updateStatus();
            return;
        }
        this.logTrace("begin export on thread " + Thread.currentThread().getName());
        long t0 = System.currentTimeMillis();
        this.conn = null;
        boolean isClosed = false;
        this.executeInProgress();
        try {
            this.dialect = BRdbmsDeprecatedDialect.make(this.db);
            String userName = this.devicelet.getUserName(this.db, this);
            BPassword password = this.devicelet.getPassword(this.db, this);
            this.conn = this.db.getConnection(userName, password);
            this.conn.setAutoCommit(false);
            this.stmt = this.conn.createStatement();
            BHistoryDatabase localDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
            BHistoryId hid = this.getHistoryId();
            try (HistorySpaceConnection conn = localDb.getConnection(null);){
                this.history = conn.getHistory(hid);
            }
            if (this.history == null) {
                throw new HistoryNotFoundException();
            }
            this.config = this.history.getConfig();
            this.template = this.config.makeRecord();
            if (this.devicelet.getUseHistoryConfigTimeZone()) {
                if (this.devicelet.getUseLastTimestamp()) {
                    this.dialect.setTimeZone(this.config.getTimeZone());
                } else {
                    throw new BajaRuntimeException("Export failed: useHistoryConfigTimeZone=true and useLastTimestamp=false.");
                }
            }
            this.exportRecords();
            this.stmt.close();
            this.conn.close();
            isClosed = true;
            this.executeOk();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.executeFail(e);
        }
        finally {
            if (this.conn != null && !isClosed) {
                try {
                    this.conn.close();
                }
                catch (Exception e) {
                    this.logError("Couldn't close connection: " + e.getMessage());
                }
            }
            long ms = System.currentTimeMillis() - t0;
            this.logTrace("end export (" + ms + "ms)");
        }
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        BRdbms db = (BRdbms)this.getDevice();
        if (db != null) {
            db.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return null;
    }

    private void exportRecords() throws Exception {
        String metaTableName = this.getMetaTableName();
        if (!this.dialect.tableExists(this.db, this.conn, metaTableName)) {
            this.isNewSchema = true;
            this.logTrace("table '" + metaTableName + "' does not exist.");
            this.createMetaTable();
        } else {
            this.isNewSchema = RdbmsHistoryUtil.isNewSchema(this.conn, metaTableName);
        }
        ResultSet meta = this.getMetaRecord();
        String tableName = null;
        boolean historyIdColumnAddedToExistingTable = false;
        if (meta.next()) {
            tableName = meta.getString("TABLE_NAME");
            int tableId = meta.getInt("ID");
            if (this.columnExists(metaTableName, "VALUEFACETS")) {
                String dbValueFacets = meta.getString("VALUEFACETS");
                BValue valuefacets = this.config.get("valueFacets");
                if (valuefacets != null && valuefacets instanceof BFacets) {
                    String configValueFacets = valuefacets.asSimple().encodeToString();
                    if (dbValueFacets != null && !dbValueFacets.equals(configValueFacets)) {
                        String updateFacetsSql = this.dialect.makeUpdateSql(metaTableName, new Property[]{this.config.getProperty("valueFacets")}, new String[0], this.dialect.mangleIdentifier(BHistoryConfig.id.getName()));
                        try (PreparedStatement stmt = this.conn.prepareStatement(updateFacetsSql);){
                            stmt.setString(1, configValueFacets);
                            stmt.setString(2, this.config.getId().toString());
                            stmt.execute();
                        }
                    }
                }
            }
            if (!this.dialect.tableExists(this.db, this.conn, tableName)) {
                this.logTrace("table '" + tableName + "' does not exist.");
                this.createTable(tableName, tableId);
            } else if (this.db.getExportMode().getOrdinal() == 1 && !this.columnExists(tableName, HISTORY_ID)) {
                this.addHistoryIdColumnAndIndexToTable(tableName, tableId);
                historyIdColumnAddedToExistingTable = true;
            }
            meta.close();
        } else {
            meta.close();
            this.insertMetaRecord();
            meta = this.getMetaRecord();
            if (!meta.next()) {
                throw new BajaRuntimeException("Could not create metadata record for history " + this.config.getId().getDeviceName() + " ::: " + this.config.getId().getHistoryName());
            }
            tableName = meta.getString("TABLE_NAME");
            int tableId = meta.getInt("ID");
            meta.close();
            if (!this.dialect.tableExists(this.db, this.conn, tableName)) {
                this.logTrace("table '" + tableName + "' does not exist.");
                this.createTable(tableName, tableId);
            } else if (this.db.getExportMode().getOrdinal() == 1 && !this.columnExists(tableName, HISTORY_ID)) {
                this.addHistoryIdColumnAndIndexToTable(tableName, tableId);
                historyIdColumnAddedToExistingTable = true;
            }
        }
        BAbsTime oldStamp = this.getLastTimestamp();
        BAbsTime newStamp = this.insertRecords(oldStamp, tableName, historyIdColumnAddedToExistingTable);
        this.setLastTimestamp(newStamp);
    }

    private void createTable(String tableName, int tableId) throws SQLException {
        Property[] propTemplate = this.template.getPropertiesArray();
        Array extraFields = new Array(String.class);
        Array extraFieldTypes = new Array(Type.class);
        Array extraFacets = new Array(BFacets.class);
        if (this.db.getExportMode().getOrdinal() == 1) {
            extraFields.add((Object)HISTORY_ID);
            extraFieldTypes.add((Object)BString.TYPE);
            extraFacets.add((Object)BFacets.NULL);
        }
        if (this.template instanceof BTrendRecord) {
            extraFields.addAll((Object[])new String[]{"TRENDFLAGS_TAG", "STATUS_TAG"});
            extraFieldTypes.addAll((Object[])new Type[]{BString.TYPE, BString.TYPE});
            extraFacets.addAll((Object[])new BFacets[]{BFacets.NULL, BFacets.NULL});
        }
        String sql = this.dialect.makeCreateTableSql(tableName, propTemplate, (String[])extraFields.trim(), (Type[])extraFieldTypes.trim(), (BFacets[])extraFacets.trim());
        this.stmt.executeUpdate(sql);
        if (this.dialect.hasSequences()) {
            this.stmt.executeUpdate("CREATE SEQUENCE " + tableName + "_Q");
        }
        if (!this.devicelet.getUseLastTimestamp() || this.devicelet.getAlwaysCreateIndexForNewTables()) {
            Pair<String, String> indexNameAndColumns = this.dialect.getNewIndexNameAndColumns(String.valueOf(tableId));
            RdbmsHistoryUtil.createIndex(this.conn, this.dialect, tableName, indexNameAndColumns);
        }
        this.conn.commit();
        this.logTrace("created table '" + tableName + "'.");
    }

    private void addHistoryIdColumnAndIndexToTable(String tableName, int tableId) throws SQLException {
        this.logTrace(String.format("Adding HISTORY_ID column to table '%s'", tableName));
        String addColumnStatement = this.dialect.makeAddColumnSql(tableName, HISTORY_ID, BSqlType.sqlVarchar, 500, "");
        this.stmt.executeUpdate(addColumnStatement);
        if (!this.devicelet.getUseLastTimestamp() || this.devicelet.getAlwaysCreateIndexForNewTables()) {
            Pair<String, String> indexNameAndColumns = this.dialect.getNewIndexNameAndColumns(String.valueOf(tableId));
            RdbmsHistoryUtil.createIndex(this.conn, this.dialect, tableName, indexNameAndColumns);
        }
    }

    private boolean columnExists(String tableName, String columnName) throws SQLException {
        DatabaseMetaData metadata = this.conn.getMetaData();
        try (ResultSet rs = metadata.getColumns(null, null, tableName, columnName);){
            boolean bl = rs.next();
            return bl;
        }
    }

    private BAbsTime insertRecords(BAbsTime lastTime, String tableName, boolean fallbackToLastTimestampPropertyValueIfNoMaxTimestampInDatabase) throws SQLException {
        BAbsTime since = this.lookupMaxTimestamp(tableName);
        if (since != null) {
            since = BAbsTime.make((long)(since.getMillis() + this.dialect.getTimestampAccuracy()));
            this.logTrace("maxTimestamp " + since.toString((Context)SHOW_MILLIS));
        } else if (fallbackToLastTimestampPropertyValueIfNoMaxTimestampInDatabase) {
            since = BAbsTime.make((long)(lastTime.getMillis() + this.dialect.getTimestampAccuracy()));
        }
        BHistoryDatabase localDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
        try (HistorySpaceConnection historyConn = localDb.getConnection(HistoryQuery.makeExcludeArchiveDataContext(null));
             TableCursor records = historyConn.timeQuery(this.history, since, null).cursor();){
            boolean addUtcOffsetEntry;
            Array extraFields = new Array(String.class);
            if (this.db.getExportMode().getOrdinal() == 1) {
                extraFields.add((Object)HISTORY_ID);
            }
            if (this.template instanceof BTrendRecord) {
                extraFields.addAll((Object[])new String[]{"TRENDFLAGS_TAG", "STATUS_TAG"});
            }
            if (addUtcOffsetEntry = false) {
                extraFields.add((Object)"UTC_OFFSET");
            }
            int extraFieldsSize = extraFields.size();
            BObject[] extraValues = new BObject[extraFieldsSize];
            BFacets[] extraFacets = new BFacets[extraFieldsSize];
            Property[] propTemplate = this.template.getPropertiesArray();
            String sql = this.dialect.makeInsertSql(tableName, propTemplate, (String[])extraFields.trim());
            int totalCount = 0;
            int count = 0;
            try (PreparedStatement ps = this.conn.prepareStatement(sql);){
                while (records.next()) {
                    BHistoryRecord rec = (BHistoryRecord)records.get();
                    BAbsTime ts = rec.getTimestamp();
                    if (lastTime.compareTo((Object)ts) < 0) {
                        lastTime = ts;
                    }
                    switch (this.db.getExportMode().getOrdinal()) {
                        case 0: {
                            if (!(this.template instanceof BTrendRecord)) break;
                            BTrendRecord t = (BTrendRecord)rec;
                            extraValues[0] = BString.make((String)t.getTrendFlags().toString());
                            extraValues[1] = BString.make((String)t.getStatus().toString());
                            break;
                        }
                        case 1: {
                            if (extraValues.length > 0) {
                                extraValues[0] = BString.make((String)this.history.getId().toString());
                            }
                            if (!(this.template instanceof BTrendRecord)) break;
                            BTrendRecord t = (BTrendRecord)rec;
                            extraValues[1] = BString.make((String)t.getTrendFlags().toString());
                            extraValues[2] = BString.make((String)t.getStatus().toString());
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    if (addUtcOffsetEntry) {
                        RdbmsDialect context = (RdbmsDialect)this.db.getRdbmsContext();
                        BTimeZone timezone = context.useUtcTimestamps() ? BTimeZone.UTC : (this.devicelet.getUseHistoryConfigTimeZone() ? this.config.getTimeZone() : BTimeZone.getLocal());
                        BLong utcOffset = BLong.make((long)timezone.getJavaTimeZone().getOffset(ts.getMillis()));
                        extraValues[extraValues.length - 1] = utcOffset;
                    }
                    if (this.getExportInvalidValues() || !this.hasInvalidValues(rec, propTemplate, extraValues)) {
                        this.dialect.insertRecord(ps, (BComplex)rec, propTemplate, extraValues, extraFacets);
                        ++count;
                        ++totalCount;
                    }
                    if (count < EXPORT_BATCH_SIZE) continue;
                    this.logTrace("sending batch at " + totalCount + " records");
                    ps.executeBatch();
                    ps.clearBatch();
                    count = 0;
                }
                if (count > 0) {
                    ps.executeBatch();
                }
            }
            this.conn.commit();
            this.logTrace("inserted " + totalCount + " records");
        }
        return lastTime;
    }

    private boolean hasInvalidValues(BHistoryRecord rec, Property[] propTemplate, BObject[] extraValues) {
        for (Property property : propTemplate) {
            if (rec.get(property).getType().is(BDouble.TYPE) && !Double.isFinite(((BDouble)rec.get(property)).getDouble())) {
                return true;
            }
            if (!rec.get(property).getType().is(BFloat.TYPE) || Float.isFinite(((BFloat)rec.get(property)).getFloat())) continue;
            return true;
        }
        for (Property property : extraValues) {
            if (property.getType().is(BDouble.TYPE) && !Double.isFinite(((BDouble)property.asValue()).getDouble())) {
                return true;
            }
            if (!property.getType().is(BFloat.TYPE) || Float.isFinite(((BFloat)property.asValue()).getFloat())) continue;
            return true;
        }
        return false;
    }

    private BAbsTime lookupMaxTimestamp(String tableName) throws SQLException {
        if (this.devicelet.getUseLastTimestamp()) {
            BAbsTime time = this.getLastTimestamp();
            if (!time.equals((Object)BAbsTime.NULL)) {
                return time;
            }
        } else {
            String sql = "SELECT MAX(TIMESTAMP) AS MAX_TIMESTAMP FROM " + tableName;
            switch (this.db.getExportMode().getOrdinal()) {
                case 0: {
                    break;
                }
                case 1: {
                    sql = sql + " WHERE HISTORY_ID = '" + RdbmsHistoryUtil.fixQuotes(this.history.getId().toString()) + '\'';
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            Timestamp ts = null;
            try (ResultSet rs = this.stmt.executeQuery(sql);){
                if (rs.next()) {
                    if (this.dialect.supportsTimestamp()) {
                        Calendar cal = this.db.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcTimestamp) ? Calendar.getInstance(BTimeZone.UTC.getJavaTimeZone()) : (this.devicelet.getUseHistoryConfigTimeZone() && this.devicelet.getUseLastTimestamp() ? Calendar.getInstance(this.config.getTimeZone().getJavaTimeZone()) : Calendar.getInstance());
                        ts = rs.getTimestamp("MAX_TIMESTAMP", cal);
                        if (ts == null) {
                            BAbsTime bAbsTime = null;
                            return bAbsTime;
                        }
                    } else {
                        String str = rs.getString("MAX_TIMESTAMP");
                        if (str == null) {
                            BAbsTime bAbsTime = null;
                            return bAbsTime;
                        }
                        ts = new Timestamp(Long.parseLong(str));
                    }
                    long millis = ts.getTime();
                    BAbsTime bAbsTime = BAbsTime.make((long)millis);
                    return bAbsTime;
                }
            }
        }
        return null;
    }

    private BTimeZone getExportTimeZone() throws SQLException {
        ResultSet rs = this.getMetaRecord();
        BTimeZone timezone = BTimeZone.NULL;
        if (rs.next() && this.isNewSchema) {
            try {
                String timeZoneId = rs.getString("DB_TIMEZONE");
                timeZoneId = timeZoneId.substring(0, timeZoneId.indexOf("(")).trim();
                timezone = BTimeZone.getTimeZone((String)timeZoneId);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            timezone = this.devicelet.getUseHistoryConfigTimeZone() && this.devicelet.getUseLastTimestamp() ? this.config.getTimeZone() : BTimeZone.getLocal();
        }
        rs.close();
        return timezone;
    }

    private String getMetaTableName() {
        switch (this.db.getExportMode().getOrdinal()) {
            case 0: {
                return "HISTORY_CONFIG";
            }
            case 1: {
                return "HISTORY_TYPE_MAP";
            }
        }
        throw new IllegalStateException();
    }

    private void createMetaTable() throws SQLException {
        String name = this.getMetaTableName();
        Property[] metaTemplate = this.makeMetaTemplate();
        String sql = this.dialect.makeCreateTableSql(name, metaTemplate, new String[]{"TABLE_NAME", "DB_TIMEZONE"}, new Type[]{BString.TYPE, BString.TYPE}, new BFacets[]{BFacets.NULL, BFacets.NULL});
        this.stmt.executeUpdate(sql);
        if (this.dialect.hasSequences()) {
            this.stmt.executeUpdate("CREATE SEQUENCE " + name + "_Q");
        }
        this.conn.commit();
        this.logTrace("created table '" + name + "'.");
    }

    private void insertMetaRecord() throws SQLException {
        try {
            String[] stringArray;
            Property[] template = this.makeMetaTemplate();
            String string = this.getMetaTableName();
            if (this.isNewSchema) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "TABLE_NAME";
                stringArray = stringArray2;
                stringArray2[1] = "DB_TIMEZONE";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "TABLE_NAME";
            }
            try (PreparedStatement ps = this.conn.prepareStatement(this.dialect.makeInsertSql(string, template, stringArray));){
                BFacets[] bFacetsArray;
                String tableName = this.inventTableName();
                BString tableNameStr = BString.make((String)tableName);
                RdbmsDialect context = (RdbmsDialect)this.db.getRdbmsContext();
                BTimeZone dbTimeZone = context.useUtcTimestamps() ? BTimeZone.UTC : (this.devicelet.getUseHistoryConfigTimeZone() ? this.config.getTimeZone() : BTimeZone.getLocal());
                BString timeZoneStr = BString.make((String)dbTimeZone.toString());
                BObject[] tablePlusTz = new BObject[]{tableNameStr, timeZoneStr};
                BObject[] table = new BObject[]{tableNameStr};
                BObject[] bObjectArray = this.isNewSchema ? tablePlusTz : table;
                if (this.isNewSchema) {
                    BFacets[] bFacetsArray2 = new BFacets[2];
                    bFacetsArray2[0] = BFacets.NULL;
                    bFacetsArray = bFacetsArray2;
                    bFacetsArray2[1] = BFacets.NULL;
                } else {
                    BFacets[] bFacetsArray3 = new BFacets[1];
                    bFacetsArray = bFacetsArray3;
                    bFacetsArray3[0] = BFacets.NULL;
                }
                this.dialect.insertRecord(ps, (BComplex)this.config, template, bObjectArray, bFacetsArray);
                ps.executeBatch();
            }
            this.conn.commit();
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    private ResultSet getMetaRecord() throws SQLException {
        String sql = null;
        String metaTableName = this.getMetaTableName();
        boolean exportingById = this.db.getExportMode().equals((Object)BRdbmsHistoryExportMode.byHistoryId);
        sql = exportingById || this.isNewSchema ? "SELECT * FROM " + metaTableName + " WHERE ID_ = '" + RdbmsHistoryUtil.fixQuotes(this.config.getId().toString()) + "'" : "SELECT * FROM " + metaTableName + " WHERE RECORDTYPE = '" + RdbmsHistoryUtil.fixQuotes(this.config.getRecordType().toString()) + "'";
        return this.stmt.executeQuery(sql);
    }

    private String inventTableName() throws SQLException {
        String tableName;
        int seq;
        int max = this.dialect.getMaxTableName();
        if (this.dialect.hasSequences() && max > (seq = this.dialect.getMaxSequenceName()) - 2) {
            max = seq - 2;
        }
        switch (this.db.getExportMode().getOrdinal()) {
            case 0: {
                String devName = SlotPath.unescape((String)this.config.getId().getDeviceName()).toUpperCase();
                String histName = SlotPath.unescape((String)this.config.getId().getHistoryName()).toUpperCase();
                tableName = TextUtil.truncate((String)(this.dialect.mangleIdentifier(devName) + "_" + this.dialect.mangleIdentifier(histName)), (int)max);
                break;
            }
            case 1: {
                tableName = TextUtil.truncate((String)this.dialect.mangleIdentifier(this.config.getRecordType().toString()), (int)max);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (this.db.getExportMode().equals((Object)BRdbmsHistoryExportMode.byHistoryId) && this.metaRecordExists(tableName)) {
            String nn;
            String fullName = tableName;
            int n = 1;
            while (this.metaRecordExists(tableName = TextUtil.truncate((String)fullName, (int)(max - (nn = Integer.toString(n++)).length())) + nn)) {
            }
        }
        return tableName;
    }

    private boolean metaRecordExists(String tableName) throws SQLException {
        ResultSet rs = this.stmt.executeQuery("SELECT * FROM " + this.getMetaTableName() + " WHERE TABLE_NAME = '" + tableName + "'");
        boolean hasNext = rs.next();
        rs.close();
        return hasNext;
    }

    private Property[] makeMetaTemplate() throws SQLException {
        if (this.config.getProperty("valueFacets") == null) {
            this.config.add("valueFacets", (BValue)BFacets.NULL);
        }
        Array arr = new Array(Property.class);
        SlotCursor historyConfigProperties = this.config.getProperties();
        boolean exportingByType = this.db.getExportMode().equals((Object)BRdbmsHistoryExportMode.byHistoryType);
        while (historyConfigProperties.next()) {
            Property property = historyConfigProperties.property();
            String name = property.getName();
            if (exportingByType) {
                if (this.isNewSchema) {
                    if (name.equals(BHistoryConfig.id.getName()) || name.equals(BHistoryConfig.timeZone.getName()) || name.equals(BHistoryConfig.recordType.getName())) {
                        arr.add((Object)property);
                        continue;
                    }
                } else if (name.equals(BHistoryConfig.recordType.getName())) {
                    arr.add((Object)property);
                    continue;
                }
            } else if (name.equals(BHistoryConfig.id.getName()) || name.equals(BHistoryConfig.historyName.getName()) || name.equals(BHistoryConfig.source.getName()) || name.equals(BHistoryConfig.sourceHandle.getName()) || name.equals(BHistoryConfig.timeZone.getName()) || name.equals(BHistoryConfig.interval.getName()) || name.equals(BHistoryConfig.systemTags.getName())) {
                arr.add((Object)property);
                continue;
            }
            if (!property.isDynamic() || !name.equals("valueFacets")) continue;
            String metaTableName = this.getMetaTableName();
            String facetsColumn = this.dialect.mangleIdentifier(name);
            if (this.dialect.tableExists(this.db, this.conn, metaTableName) && !this.columnExists(metaTableName, facetsColumn)) continue;
            arr.add((Object)property);
        }
        return (Property[])arr.trim();
    }

    private void logTrace(String str) {
        LOG.fine("HistoryExport " + this.getHistoryId() + " " + str);
    }

    private void logError(String str) {
        LOG.severe("HistoryExport " + this.getHistoryId() + " " + str);
    }
}

