/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.ddl;

import com.tridium.rdb.jdbc.RdbmsDialect;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.sys.BajaRuntimeException;

public class RenameTable
implements DdlCommand {
    private final String oldName;
    private final String newName;

    public RenameTable(String oldName, String newName) {
        this.oldName = oldName;
        this.newName = newName;
    }

    @Override
    public String getDdl(RdbmsContext context) {
        RdbmsDialect dialect = (RdbmsDialect)context;
        if (!dialect.supportsRenameTable()) {
            throw new BajaRuntimeException(dialect.getClass().getName() + " does not support RENAME TABLE");
        }
        return "RENAME TABLE " + this.oldName + " TO " + this.newName;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }
}

