/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.ddl;

import com.tridium.rdb.jdbc.RdbmsDialect;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.BClustered;
import javax.baja.rdb.ddl.BOnDelete;
import javax.baja.rdb.ddl.CreateIndex;

public class Constraint {
    public static final int UNIQUE = 0;
    public static final int PRIMARY_KEY = 1;
    public static final int FOREIGN_KEY = 2;
    private final String name;
    private final String[] columns;
    private final int type;
    private final BClustered clustered;
    private final String refTable;
    private final String[] refColumns;
    private final BOnDelete refOnDelete;

    public static Constraint makeUnique(String name, String[] columns) {
        return new Constraint(name, columns, 0);
    }

    public static Constraint makeUnique(String name, String[] columns, BClustered clustered) {
        return new Constraint(name, columns, 0, clustered);
    }

    public static Constraint makePrimaryKey(String name, String[] columns) {
        return new Constraint(name, columns, 1);
    }

    public static Constraint makePrimaryKey(String name, String[] columns, BClustered clustered) {
        return new Constraint(name, columns, 1, clustered);
    }

    public static Constraint makeForeignKey(String name, String[] columns, String refTable, String[] refColumns, BOnDelete refOnDelete) {
        return new Constraint(name, columns, refTable, refColumns, refOnDelete);
    }

    public static Constraint makeUnique(String name, String column) {
        return new Constraint(name, new String[]{column}, 0);
    }

    public static Constraint makePrimaryKey(String name, String column) {
        return new Constraint(name, new String[]{column}, 1);
    }

    public static Constraint makeForeignKey(String name, String column, String refTable, String refColumn, BOnDelete refOnDelete) {
        return new Constraint(name, new String[]{column}, refTable, new String[]{refColumn}, refOnDelete);
    }

    private Constraint(String name, String[] columns, int type) {
        this.name = name;
        this.columns = columns;
        this.type = type;
        this.clustered = BClustered.unspecified;
        this.refTable = null;
        this.refColumns = null;
        this.refOnDelete = null;
    }

    private Constraint(String name, String[] columns, int type, BClustered clustered) {
        this.name = name;
        this.columns = columns;
        this.type = type;
        this.clustered = clustered;
        this.refTable = null;
        this.refColumns = null;
        this.refOnDelete = null;
    }

    private Constraint(String name, String[] columns, String refTable, String[] refColumns, BOnDelete refOnDelete) {
        this.name = name;
        this.columns = columns;
        this.type = 2;
        this.clustered = BClustered.unspecified;
        this.refTable = refTable;
        this.refColumns = refColumns;
        this.refOnDelete = refOnDelete;
    }

    public String getDdl(RdbmsContext context, String tableName) {
        int i;
        RdbmsDialect dialect = (RdbmsDialect)context;
        StringBuilder sql = new StringBuilder();
        sql.append("CONSTRAINT ").append(this.getName()).append(" ");
        switch (this.type) {
            case 0: {
                sql.append("UNIQUE ");
                break;
            }
            case 1: {
                sql.append("PRIMARY KEY ");
                break;
            }
            case 2: {
                sql.append("FOREIGN KEY ");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        sql.append(CreateIndex.clusteredDdl(dialect, tableName, this.clustered));
        sql.append("(");
        for (i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(this.columns[i]);
        }
        sql.append(")");
        if (this.type == 2) {
            sql.append(" REFERENCES ").append(this.refTable).append(" ");
            sql.append("(");
            for (i = 0; i < this.refColumns.length; ++i) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append(this.refColumns[i]);
            }
            sql.append(")");
            sql.append(" ON DELETE ");
            sql.append(dialect.getOnDelete(this.refOnDelete.getOrdinal()));
        }
        return sql.toString();
    }

    public String getName() {
        return this.name;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public int getConstraintType() {
        return this.type;
    }

    public BClustered isClustered() {
        return this.clustered;
    }

    public String getRefTable() {
        if (this.type != 2) {
            throw new UnsupportedOperationException();
        }
        return this.refTable;
    }

    public String[] getRefColumns() {
        if (this.type != 2) {
            throw new UnsupportedOperationException();
        }
        return this.refColumns;
    }

    public BOnDelete getRefOnDelete() {
        if (this.type != 2) {
            throw new UnsupportedOperationException();
        }
        return this.refOnDelete;
    }
}

