/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb;

import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.rdb.aes.BRdbSecuritySettings;
import com.tridium.rdb.jdbc.RdbmsDialect;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.license.BILicensed;
import javax.baja.license.Feature;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbmsNetwork;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.BRdbmsWorker;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.history.BRdbmsHistoryExportMode;
import javax.baja.rdb.point.BRdbmsPointDeviceExt;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="hostAddress", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(name="BFacets.ORD_RELATIVIZE", value="BBoolean.FALSE"), @Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"workbench:HostOrdFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:HostOrdEditor\")")}), @NiagaraProperty(name="ownerName", type="String", defaultValue="", flags=4), @NiagaraProperty(name="useEncryptedConnection", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="userName", type="String", defaultValue=""), @NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="worker", type="BRdbmsWorker", defaultValue="new BRdbmsWorker()"), @NiagaraProperty(name="exportMode", type="BRdbmsHistoryExportMode", defaultValue="BRdbmsHistoryExportMode.byHistoryId"), @NiagaraProperty(name="useUnicodeEncodingScheme", type="boolean", defaultValue="false", flags=0x10000000), @NiagaraProperty(name="timestampStorage", type="BRdbmsTimestampStorage", defaultValue="BRdbmsTimestampStorage.dialectDefault", flags=0x10000000), @NiagaraProperty(name="points", type="BRdbmsPointDeviceExt", defaultValue="new BRdbmsPointDeviceExt()"), @NiagaraProperty(name="sqlSchemeEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="rdbSecuritySettings", type="BRdbSecuritySettings", defaultValue="new BRdbSecuritySettings()")})
@NiagaraAction(name="allowDialectModifications", flags=128)
public abstract class BRdbms
extends BDevice
implements BILicensed {
    @Generated
    public static final Property hostAddress = BRdbms.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"ordRelativize", (BIDataValue)BBoolean.FALSE), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:HostOrdFE"))), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:HostOrdEditor"))));
    @Generated
    public static final Property ownerName = BRdbms.newProperty((int)4, (String)"", null);
    @Generated
    public static final Property useEncryptedConnection = BRdbms.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property userName = BRdbms.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property password = BRdbms.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property worker = BRdbms.newProperty((int)0, (BValue)new BRdbmsWorker(), null);
    @Generated
    public static final Property exportMode = BRdbms.newProperty((int)0, (BValue)BRdbmsHistoryExportMode.byHistoryId, null);
    @Generated
    public static final Property useUnicodeEncodingScheme = BRdbms.newProperty((int)0x10000000, (boolean)false, null);
    @Generated
    public static final Property timestampStorage = BRdbms.newProperty((int)0x10000000, (BValue)BRdbmsTimestampStorage.dialectDefault, null);
    @Generated
    public static final Property points = BRdbms.newProperty((int)0, (BValue)new BRdbmsPointDeviceExt(), null);
    @Generated
    public static final Property sqlSchemeEnabled = BRdbms.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property rdbSecuritySettings = BRdbms.newProperty((int)0, (BValue)new BRdbSecuritySettings(), null);
    @Generated
    public static final Action allowDialectModifications = BRdbms.newAction((int)128, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRdbms.class);
    private static boolean sslCtxInitialized;

    @Generated
    public BOrd getHostAddress() {
        return (BOrd)this.get(hostAddress);
    }

    @Generated
    public void setHostAddress(BOrd v) {
        this.set(hostAddress, (BValue)v, null);
    }

    @Generated
    public String getOwnerName() {
        return this.getString(ownerName);
    }

    @Generated
    public void setOwnerName(String v) {
        this.setString(ownerName, v, null);
    }

    @Generated
    public boolean getUseEncryptedConnection() {
        return this.getBoolean(useEncryptedConnection);
    }

    @Generated
    public void setUseEncryptedConnection(boolean v) {
        this.setBoolean(useEncryptedConnection, v, null);
    }

    @Generated
    public String getUserName() {
        return this.getString(userName);
    }

    @Generated
    public void setUserName(String v) {
        this.setString(userName, v, null);
    }

    @Generated
    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    @Generated
    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    @Generated
    public BRdbmsWorker getWorker() {
        return (BRdbmsWorker)this.get(worker);
    }

    @Generated
    public void setWorker(BRdbmsWorker v) {
        this.set(worker, (BValue)v, null);
    }

    @Generated
    public BRdbmsHistoryExportMode getExportMode() {
        return (BRdbmsHistoryExportMode)this.get(exportMode);
    }

    @Generated
    public void setExportMode(BRdbmsHistoryExportMode v) {
        this.set(exportMode, (BValue)v, null);
    }

    @Generated
    public boolean getUseUnicodeEncodingScheme() {
        return this.getBoolean(useUnicodeEncodingScheme);
    }

    @Generated
    public void setUseUnicodeEncodingScheme(boolean v) {
        this.setBoolean(useUnicodeEncodingScheme, v, null);
    }

    @Generated
    public BRdbmsTimestampStorage getTimestampStorage() {
        return (BRdbmsTimestampStorage)this.get(timestampStorage);
    }

    @Generated
    public void setTimestampStorage(BRdbmsTimestampStorage v) {
        this.set(timestampStorage, (BValue)v, null);
    }

    @Generated
    public BRdbmsPointDeviceExt getPoints() {
        return (BRdbmsPointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BRdbmsPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Generated
    public boolean getSqlSchemeEnabled() {
        return this.getBoolean(sqlSchemeEnabled);
    }

    @Generated
    public void setSqlSchemeEnabled(boolean v) {
        this.setBoolean(sqlSchemeEnabled, v, null);
    }

    @Generated
    public BRdbSecuritySettings getRdbSecuritySettings() {
        return (BRdbSecuritySettings)this.get(rdbSecuritySettings);
    }

    @Generated
    public void setRdbSecuritySettings(BRdbSecuritySettings v) {
        this.set(rdbSecuritySettings, (BValue)v, null);
    }

    @Generated
    public void allowDialectModifications() {
        this.invoke(allowDialectModifications, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return BRdbmsNetwork.TYPE;
    }

    protected IFuture postPing() {
        this.doPing();
        return null;
    }

    public void doPing() {
        try (Connection conn = this.getConnection();
             Statement statement = conn.createStatement();){
            RdbmsDialect dialect = (RdbmsDialect)this.getRdbmsContext();
            statement.execute(dialect.getValidationQuery());
            this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)false));
            this.pingOk();
        }
        catch (Throwable e) {
            this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
            this.pingFail(e.getMessage());
            e.printStackTrace();
        }
    }

    public final void started() throws Exception {
        super.started();
        this.checkLicense();
        this.rdbmsStarted();
    }

    public void rdbmsStarted() throws Exception {
    }

    public void pingOk() {
        super.pingOk();
        this.preventDialectModifications();
    }

    public void preventDialectModifications() {
        Property[] props = this.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            if (!Flags.isUserDefined1((BComplex)this, (Slot)props[i]) || Flags.isReadonly((BComplex)this, (Slot)props[i])) continue;
            this.setFlags((Slot)props[i], this.getFlags((Slot)props[i]) | 1);
        }
    }

    public void doAllowDialectModifications(Context cx) {
        Property[] props = this.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            if (!Flags.isUserDefined1((BComplex)this, (Slot)props[i]) || !Flags.isReadonly((BComplex)this, (Slot)props[i])) continue;
            this.setFlags((Slot)props[i], this.getFlags((Slot)props[i]) & 0xFFFFFFFE);
        }
    }

    public abstract Feature getLicenseFeature();

    private void checkLicense() {
        try {
            Feature feature = this.getLicenseFeature();
            if (feature != null) {
                feature.check();
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Unlicensed: " + this.toPathString(), e);
            this.configFatal("Unlicensed: " + e);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.getUserName(), this.getPassword());
    }

    public abstract Connection getConnection(String var1, BPassword var2) throws SQLException;

    @Deprecated
    public void initSSLContext() {
    }

    public final String getHostname() {
        if (this.getHostAddress().isNull()) {
            return "";
        }
        try {
            return ((BHost)this.getHostAddress().get()).getHostname();
        }
        catch (IllegalArgumentException e) {
            return "";
        }
    }

    public abstract RdbmsContext getRdbmsContext();

    public AesSysKeyEncoder getEncoder() {
        return this.getRdbSecuritySettings().getEncoder();
    }

    public int getResultSetFetchSize() {
        return 0;
    }
}

