/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.jdbc.trans;

import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.rdb.exception.PasswordCipherException;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.RdbmsResultSet;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import com.tridium.rdb.jdbc.trans.BSqlType;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAbstractPasswordEncoder;
import javax.baja.security.BAes256PasswordEncoder;
import javax.baja.security.BAliasedAes256PasswordEncoder;
import javax.baja.security.BPassword;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:Password"})})
public class BPasswordTranslator
extends BColumnTranslator {
    @Generated
    public static final Type TYPE = Sys.loadType(BPasswordTranslator.class);
    private static final Logger LOG = Logger.getLogger("rdb");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPasswordTranslator(RdbmsDialect dialect, BValue defaultValue) {
        super(dialect, defaultValue);
    }

    @Override
    public BSqlType getSqlType() {
        return BSqlType.sqlVarchar;
    }

    @Override
    public void setPreparedStatementValue(RdbmsPreparedStatement prep, int index, BValue input, Context context) {
        try {
            String value;
            BPassword password;
            BPassword bPassword = password = input != null && input instanceof BPassword ? (BPassword)input : null;
            String string = password != null ? AccessController.doPrivileged(() -> ((BPassword)password).getValue()) : (value = "");
            if ("".equals(value)) {
                prep.setNull(index, 12);
            } else {
                BAbstractPasswordEncoder encoder;
                AesSysKeyEncoder aesSysKeyEncoder = this.getDialect().getSysEncoder();
                String encrypted = aesSysKeyEncoder.encrypt(value);
                BAbstractPasswordEncoder bAbstractPasswordEncoder = encoder = password == null ? null : password.getPasswordEncoder();
                if (encoder instanceof BAliasedAes256PasswordEncoder) {
                    encrypted = ((BAliasedAes256PasswordEncoder)encoder).getKeyAlias() + ':' + encrypted;
                }
                prep.setString(index, encrypted);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error in encoding the input string.", e);
            throw new PasswordCipherException(this.getLexicon().getText("rdb.passwordCipherException.message"), e, this.getLexicon().getText("rdb.setEncryptedValue.passwordCipherException.errorCode"));
        }
    }

    @Override
    public BValue getResultSetValue(RdbmsResultSet rs, int index, Context context) {
        try {
            String dbValue = rs.getString(index);
            String[] split = dbValue.split(":");
            String alias = null;
            if (split.length == 3) {
                alias = split[0];
                dbValue = dbValue.substring(dbValue.indexOf(58) + 1);
            }
            AesSysKeyEncoder aesSysKeyEncoder = this.getDialect().getSysEncoder();
            String encodedValue = aesSysKeyEncoder.decrypt(dbValue);
            Object encoder = alias != null ? new BAliasedAes256PasswordEncoder(alias) : new BAes256PasswordEncoder();
            encoder.encode(encodedValue);
            return BPassword.make((BAbstractPasswordEncoder)encoder);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error in decoding the value, probably the key is bad.", e);
            throw new PasswordCipherException(this.getLexicon().getText("rdb.passwordCipherException.message"), e, this.getLexicon().getText("rdb.readResult.passwordCipherException.errorCode"));
        }
    }
}

