/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.baja.sys.BajaRuntimeException;

public class RdbmsResultSet {
    private static final byte[] NO_BYTES = new byte[0];
    private ResultSet rs;

    public RdbmsResultSet(ResultSet rs) {
        this.rs = rs;
    }

    public boolean isNull(int idx) {
        try {
            return this.rs.getObject(idx) == null;
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public int getInt(int idx) {
        try {
            return this.rs.getInt(idx);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public long getLong(int idx) {
        try {
            return this.rs.getLong(idx);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public float getFloat(int idx) {
        try {
            float val = this.rs.getFloat(idx);
            return this.rs.wasNull() ? Float.NaN : val;
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public double getDouble(int idx) {
        try {
            double val = this.rs.getDouble(idx);
            return this.rs.wasNull() ? Double.NaN : val;
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public boolean getBoolean(int idx) {
        try {
            return this.rs.getBoolean(idx);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public Timestamp getTimestamp(int idx) {
        try {
            return this.rs.getTimestamp(idx);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public Timestamp getTimestamp(int idx, Calendar calendar) {
        try {
            return this.rs.getTimestamp(idx, calendar);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public Date getDate(int idx) {
        try {
            return this.rs.getDate(idx);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public String getString(int idx) {
        try {
            return this.rs.getString(idx);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public byte[] getBytes(int idx) {
        try {
            return this.rs.getBytes(idx);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public InputStream getBinaryStream(int idx) {
        try {
            return this.rs.getBinaryStream(idx);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public Reader getCharacterStream(int idx) {
        try {
            return this.rs.getCharacterStream(idx);
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public boolean next() {
        try {
            return this.rs.next();
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void close() {
        try {
            this.rs.close();
        }
        catch (SQLException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public ResultSet getResultSet() {
        return this.rs;
    }
}

