/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.history;

import com.tridium.nre.util.tuple.Pair;
import com.tridium.rdb.BRdbmsDeprecatedDialect;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.nre.util.TextUtil;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.history.BRdbmsHistoryExportMode;

public final class RdbmsHistoryUtil {
    private static final Logger LOG = Logger.getLogger("rdb");
    private static final Pattern INDEX_PATTERN_TP_TS = Pattern.compile("^TP[_][0-9]+[_]TS$");
    private static final Pattern INDEX_PATTERN_IDX_ID = Pattern.compile("^IDX[_][0-9]+[_]ID$");

    private RdbmsHistoryUtil() {
    }

    public static List<TableNameIdHistory> getTableNamesFromMetaRecord(Connection connection, String metaTableName, BRdbmsHistoryExportMode exportMode) throws SQLException {
        ArrayList<TableNameIdHistory> result = new ArrayList<TableNameIdHistory>();
        try (Statement stmt = connection.createStatement();){
            String sql = exportMode.equals((Object)BRdbmsHistoryExportMode.byHistoryId) ? "SELECT TABLE_NAME, ID, ID_ FROM " + metaTableName : "SELECT TABLE_NAME, min(id), RECORDTYPE FROM " + metaTableName + " GROUP BY TABLE_NAME, RECORDTYPE";
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                result.add(new TableNameIdHistory(rs.getString(1), rs.getString(2), rs.getString(3)));
            }
        }
        catch (SQLException e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Exception while getting the table names from the metadata", e);
            }
            throw e;
        }
        return result;
    }

    public static String getMetaTableName(BRdbms db) {
        switch (db.getExportMode().getOrdinal()) {
            case 0: {
                return "HISTORY_CONFIG";
            }
            case 1: {
                return "HISTORY_TYPE_MAP";
            }
        }
        throw new IllegalStateException();
    }

    public static boolean indexAlreadyExists(Connection connection, String tableName, String expectedIndexName) throws SQLException {
        try (ResultSet rs = null;){
            DatabaseMetaData metaData = connection.getMetaData();
            rs = metaData.getIndexInfo(null, null, tableName, false, false);
            while (rs.next()) {
                String dbIndexName = rs.getString("INDEX_NAME");
                if (dbIndexName == null || !dbIndexName.equalsIgnoreCase(expectedIndexName)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static void createIndex(Connection connection, BRdbmsDeprecatedDialect dialect, String tableName, Pair<String, String> indexNameAndColumns) throws SQLException {
        block31: {
            try {
                String sql = dialect.supportsOnlineIndexCreation() ? dialect.makeCreateIndexSql((String)indexNameAndColumns.getFirst(), tableName, (String)indexNameAndColumns.getSecond(), true) : dialect.makeCreateIndexSql((String)indexNameAndColumns.getFirst(), tableName, (String)indexNameAndColumns.getSecond(), false);
                try (Statement stmt = connection.createStatement();){
                    stmt.executeUpdate(sql);
                }
                catch (SQLException e) {
                    if (dialect.supportsOnlineIndexCreation()) {
                        sql = dialect.makeCreateIndexSql((String)indexNameAndColumns.getFirst(), tableName, (String)indexNameAndColumns.getSecond(), false);
                        try (Statement stmt2 = connection.createStatement();){
                            stmt2.executeUpdate(sql);
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "Index created successfully in non ONLINE mode");
                            }
                            break block31;
                        }
                    }
                    throw e;
                }
            }
            catch (SQLException e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Exception while creating the index", e);
                }
                throw e;
            }
        }
    }

    public static Set<String> getOldIndexName(Connection connection, String tableName) throws SQLException {
        HashSet<String> indexNames = new HashSet<String>();
        try (ResultSet rs = null;){
            DatabaseMetaData metaData = connection.getMetaData();
            rs = metaData.getIndexInfo(null, null, tableName, false, false);
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                String column = rs.getString("COLUMN_NAME");
                if ("TIMESTAMP".equals(column) && INDEX_PATTERN_TP_TS.matcher(indexName).matches()) {
                    indexNames.add(indexName);
                    continue;
                }
                if (!"HISTORY_ID".equals(column) || !INDEX_PATTERN_IDX_ID.matcher(indexName).matches()) continue;
                indexNames.add(indexName);
            }
        }
        return indexNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean dropIndex(Connection connection, BRdbmsDeprecatedDialect dialect, String tableName, String indexName) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            String sql = dialect.makeDropIndexSql(indexName, tableName);
            stmt.execute(sql);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            if (!LOG.isLoggable(Level.FINE)) throw e;
            LOG.log(Level.FINE, "Exception while dropping the index", e);
            throw e;
        }
    }

    public static boolean isNewSchema(Connection conn, String tableName) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        try (ResultSet rs = metaData.getColumns(null, null, tableName, "DB_TIMEZONE");){
            boolean bl = rs.next();
            return bl;
        }
    }

    public static String fixQuotes(String str) {
        return TextUtil.replace((String)str, (String)"'", (String)"''");
    }

    static class TableNameIdHistory {
        String tableName;
        String tableId;
        String historyIdOrRecType;

        TableNameIdHistory(String tableName, String tableId, String historyIdOrRecType) {
            this.tableName = tableName;
            this.tableId = tableId;
            this.historyIdOrRecType = historyIdOrRecType;
        }
    }
}

