/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.weather.advisory;

import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BWeatherReport;
import javax.baja.weather.BWeatherState;
import javax.baja.weather.advisory.BAdvisoryCertainty;
import javax.baja.weather.advisory.BAdvisoryContainer;
import javax.baja.weather.advisory.BAdvisorySeverity;
import javax.baja.weather.advisory.BAdvisoryUrgency;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.alarm", flags=1), @NiagaraProperty(name="id", type="BValue", defaultValue="BAdvisoryUrgency.unknown", flags=5), @NiagaraProperty(name="lastUpdate", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="urgency", type="BStatusEnum", defaultValue="new BStatusEnum(BAdvisoryUrgency.unknown)", flags=1), @NiagaraProperty(name="severity", type="BStatusEnum", defaultValue="new BStatusEnum(BAdvisorySeverity.unknown)", flags=1), @NiagaraProperty(name="certainty", type="BStatusEnum", defaultValue="new BStatusEnum(BAdvisoryCertainty.unknown)", flags=1), @NiagaraProperty(name="effective", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="expires", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="weatherSummary", type="BStatusString", defaultValue="new BStatusString(\"\")", flags=1), @NiagaraProperty(name="state", type="BStatusEnum", defaultValue="new BStatusEnum(BWeatherState.unknown, BStatus.alarm)", flags=1), @NiagaraProperty(name="description", type="BStatusString", defaultValue="new BStatusString(\"\")", flags=1, facets={@Facet(value="BFacets.make(BFacets.MULTI_LINE, BBoolean.TRUE)")}), @NiagaraProperty(name="instructions", type="BStatusString", defaultValue="new BStatusString(\"\")", flags=1, facets={@Facet(value="BFacets.make(BFacets.MULTI_LINE, BBoolean.TRUE)")})})
@NiagaraAction(name="update", flags=16)
public class BAdvisory
extends BComponent
implements BIComparable,
BIStatus {
    @Generated
    public static final Property status = BAdvisory.newProperty((int)1, (BValue)BStatus.alarm, null);
    @Generated
    public static final Property id = BAdvisory.newProperty((int)5, (BValue)BAdvisoryUrgency.unknown, null);
    @Generated
    public static final Property lastUpdate = BAdvisory.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property urgency = BAdvisory.newProperty((int)1, (BValue)new BStatusEnum((BEnum)BAdvisoryUrgency.unknown), null);
    @Generated
    public static final Property severity = BAdvisory.newProperty((int)1, (BValue)new BStatusEnum((BEnum)BAdvisorySeverity.unknown), null);
    @Generated
    public static final Property certainty = BAdvisory.newProperty((int)1, (BValue)new BStatusEnum((BEnum)BAdvisoryCertainty.unknown), null);
    @Generated
    public static final Property effective = BAdvisory.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property expires = BAdvisory.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property weatherSummary = BAdvisory.newProperty((int)1, (BValue)new BStatusString(""), null);
    @Generated
    public static final Property state = BAdvisory.newProperty((int)1, (BValue)new BStatusEnum((BEnum)BWeatherState.unknown, BStatus.alarm), null);
    @Generated
    public static final Property description = BAdvisory.newProperty((int)1, (BValue)new BStatusString(""), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property instructions = BAdvisory.newProperty((int)1, (BValue)new BStatusString(""), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Action update = BAdvisory.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAdvisory.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.make((String)"module://weather/icons/weather.png"), (BIcon)BIcon.make((String)"module://icons/x16/badges/warning.png"));
    Clock.Ticket expiresTicket;

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public BValue getId() {
        return this.get(id);
    }

    @Generated
    public void setId(BValue v) {
        this.set(id, v, null);
    }

    @Generated
    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    @Generated
    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    @Generated
    public BStatusEnum getUrgency() {
        return (BStatusEnum)this.get(urgency);
    }

    @Generated
    public void setUrgency(BStatusEnum v) {
        this.set(urgency, (BValue)v, null);
    }

    @Generated
    public BStatusEnum getSeverity() {
        return (BStatusEnum)this.get(severity);
    }

    @Generated
    public void setSeverity(BStatusEnum v) {
        this.set(severity, (BValue)v, null);
    }

    @Generated
    public BStatusEnum getCertainty() {
        return (BStatusEnum)this.get(certainty);
    }

    @Generated
    public void setCertainty(BStatusEnum v) {
        this.set(certainty, (BValue)v, null);
    }

    @Generated
    public BAbsTime getEffective() {
        return (BAbsTime)this.get(effective);
    }

    @Generated
    public void setEffective(BAbsTime v) {
        this.set(effective, (BValue)v, null);
    }

    @Generated
    public BAbsTime getExpires() {
        return (BAbsTime)this.get(expires);
    }

    @Generated
    public void setExpires(BAbsTime v) {
        this.set(expires, (BValue)v, null);
    }

    @Generated
    public BStatusString getWeatherSummary() {
        return (BStatusString)this.get(weatherSummary);
    }

    @Generated
    public void setWeatherSummary(BStatusString v) {
        this.set(weatherSummary, (BValue)v, null);
    }

    @Generated
    public BStatusEnum getState() {
        return (BStatusEnum)this.get(state);
    }

    @Generated
    public void setState(BStatusEnum v) {
        this.set(state, (BValue)v, null);
    }

    @Generated
    public BStatusString getDescription() {
        return (BStatusString)this.get(description);
    }

    @Generated
    public void setDescription(BStatusString v) {
        this.set(description, (BValue)v, null);
    }

    @Generated
    public BStatusString getInstructions() {
        return (BStatusString)this.get(instructions);
    }

    @Generated
    public void setInstructions(BStatusString v) {
        this.set(instructions, (BValue)v, null);
    }

    @Generated
    public void update() {
        this.invoke(update, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    public void doUpdate() {
        BAdvisoryContainer advisoryContainer = (BAdvisoryContainer)this.getParent();
        BCurrentConditions currentConditions = (BCurrentConditions)advisoryContainer.getParent();
        BWeatherReport weatherReport = (BWeatherReport)currentConditions.getParent();
        weatherReport.updateWeatherReport();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(expires)) {
            if (this.expiresTicket != null && !this.expiresTicket.isExpired()) {
                this.expiresTicket.cancel();
            }
            try {
                if (!this.getExpires().isNull()) {
                    Clock.schedule((BComponent)this, (BAbsTime)this.getExpires(), (Action)update, null);
                }
            }
            catch (NotRunningException notRunningException) {}
        } else if (property.equals(status)) {
            BStatusValue[] values;
            for (BStatusValue value : values = (BStatusValue[])this.getChildren(BStatusValue.class)) {
                value.setStatus(BStatus.make((int)(value.getStatus().getBits() & 0x48 | this.getStatus().getBits() & 0x16)));
            }
        }
        super.changed(property, context);
    }

    public void started() {
        if (this.expiresTicket != null && !this.expiresTicket.isExpired()) {
            this.expiresTicket.cancel();
        }
        if (!this.getExpires().isNull()) {
            Clock.schedule((BComponent)this, (BAbsTime)this.getExpires(), (Action)update, null);
        }
    }

    public void stopped() {
        if (this.expiresTicket != null && !this.expiresTicket.isExpired()) {
            this.expiresTicket.cancel();
        }
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof BAdvisory)) {
            return 0;
        }
        int value = this.getUrgency().getValue().compareTo((Object)((BAdvisory)((Object)obj)).getUrgency().getValue());
        if (value != 0) {
            return value;
        }
        return ((BAdvisory)((Object)obj)).getEffective().compareTo((Object)this.getEffective());
    }
}

