/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.weather.nws.NwsStationList;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.PermissionException;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;
import javax.baja.weather.BWeatherService;

@NiagaraType
@NiagaraSingleton
public final class BWeatherRpc
extends BSingleton {
    @Generated
    public static final BWeatherRpc INSTANCE = new BWeatherRpc();
    @Generated
    public static final Type TYPE = Sys.loadType(BWeatherRpc.class);
    private static final LexiconModule LEX_MODULE = LexiconModule.make((String)"weather");

    @Generated
    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static BVector getWeatherReportsForStation(String stationName, Context cx) {
        BWeatherService weatherService = (BWeatherService)Sys.getService((Type)BWeatherService.TYPE);
        if (!weatherService.getPermissions(cx).hasOperatorRead()) {
            throw new PermissionException(LEX_MODULE.getText("weatherRpc.getWeatherReports.permissionException.message", cx));
        }
        return weatherService.getReports(stationName, cx);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static JSONArray getNwsWeatherStations(Context cx) throws Exception {
        NwsStationList stationList = new NwsStationList();
        NwsStationList.Station[] list = stationList.getStations();
        JSONArray stationArray = new JSONArray();
        for (NwsStationList.Station s : list) {
            JSONObject stationObj = new JSONObject();
            stationObj.put("state", (Object)s.state);
            stationObj.put("id", (Object)s.id);
            stationObj.put("name", (Object)s.name);
            stationObj.put("latitude", s.latitude);
            stationObj.put("longitude", s.longitude);
            stationObj.put("zone", (Object)s.zone);
            stationObj.put("zipCode", (Object)s.zipCode);
            stationArray.put((Object)stationObj);
        }
        return stationArray;
    }
}

