/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.ui.device;

import com.tridium.ddf.BDdfDevice;
import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.ui.DdfMgrModelUtil;
import com.tridium.ddf.ui.DdfUiLexicon;
import com.tridium.ddf.ui.device.BDdfDeviceManager;
import com.tridium.ddf.ui.device.DdfDeviceManagerLexicon;
import javax.baja.driver.BDeviceFolder;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class DdfDeviceModel
extends DeviceModel
implements IDdfFacetConst {
    protected BIDeviceFolder folder;
    protected Type deviceType = BDdfDevice.TYPE;
    protected Type folderType = BDeviceFolder.TYPE;

    public DdfDeviceModel(BDdfDeviceManager manager) {
        super((BDeviceManager)manager);
    }

    protected MgrColumn[] makeColumns() {
        return DdfMgrModelUtil.makeColumns(this.getManager());
    }

    public void init() {
        this.folder = (BIDeviceFolder)this.getManager().getCurrentValue();
        try {
            this.deviceType = this.folder.getDeviceType();
            this.folderType = this.folder.getDeviceFolderType();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.deviceType == null) {
            throw new BajaRuntimeException(DdfUiLexicon.LEX.getText("MustSpecifyDeviceType", new Object[]{this.folder.getType().getTypeSpec()}));
        }
        if (this.deviceType.isAbstract()) {
            throw new BajaRuntimeException(DdfDeviceManagerLexicon.deviceTypeCannotBeAbstract(this.folder, this.deviceType));
        }
        super.init();
    }

    public void load(BComponent target) {
        super.load(target);
        BComponent[] dbRows = this.getTable().getComponentModel().getRows();
        for (int i = 0; i < dbRows.length; ++i) {
            if (!(dbRows[i] instanceof BDdfDevice)) continue;
            ((BDdfDeviceManager)this.getManager()).registerDeviceCommunicator((BDdfDevice)dbRows[i]);
        }
    }

    public MgrTypeInfo[] getNewTypes() {
        if (this.deviceType.isAbstract()) {
            throw new BajaRuntimeException(DdfDeviceManagerLexicon.deviceTypeCannotBeAbstract(this.folder, this.deviceType));
        }
        String protoDef = Sys.getRegistry().getDef("proto:" + this.deviceType.getTypeSpec().toString(), "false").toLowerCase();
        if (protoDef.equals("true")) {
            Array bajaArrayConcreteDeviceTypes = new Array((Object[])Sys.getRegistry().getConcreteTypes(this.deviceType.getTypeInfo()));
            bajaArrayConcreteDeviceTypes.remove((Object)this.deviceType.getTypeInfo());
            return MgrTypeInfo.makeArray((TypeInfo[])((TypeInfo[])bajaArrayConcreteDeviceTypes.trim()));
        }
        return MgrTypeInfo.makeArray((Type)this.deviceType);
    }
}

