/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.ui;

import com.vykon.vykonPro.history.BMinTracker;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.view.BWbComponentView;

public class BMinTrackerView
extends BWbComponentView {
    public static final Property showTitle = BMinTrackerView.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BMinTrackerView.class);
    public static final BFont appFont = BFont.make((String)"11pt Tahoma");
    public static final BFont appBoldFont = BFont.make((String)"bold 11pt Tahoma");
    public static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BMinTrackerView.class);
    public static final UiLexicon monthLex = UiLexicon.makeUiLexicon(BMonth.class);
    static final BBrush appRGB = BColor.make((int)200, (int)200, (int)200).toBrush();
    BTable minTrackerTable = new BTable();
    BMinTracker base = null;
    BLabel titleLabel = new BLabel("", appBoldFont);
    private BFacets f = null;
    private BStatusNumeric num = null;
    private boolean editor = true;

    public boolean getShowTitle() {
        return this.getBoolean(showTitle);
    }

    public void setShowTitle(boolean v) {
        this.setBoolean(showTitle, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        BWidgetShell shell = this.getShell();
        this.editor = shell == null;
    }

    public BMinTrackerView() {
        BBorderPane mainBorderPane = new BBorderPane();
        mainBorderPane.setContent(this.buildPeakTrackerTable());
        this.setContent((BWidget)mainBorderPane);
        this.minTrackerTable.repaint();
    }

    private BWidget buildPeakTrackerTable() {
        BEdgePane edgePane = new BEdgePane();
        this.minTrackerTable.setModel((TableModel)new MinTrackerTableModel());
        this.minTrackerTable.setMultipleSelection(false);
        edgePane.setTop((BWidget)this.titleLabel);
        BBorderPane bpane = new BBorderPane((BWidget)this.minTrackerTable);
        edgePane.setCenter((BWidget)bpane);
        return edgePane;
    }

    public void doLoadValue(BObject value, Context cx) {
        this.base = (BMinTracker)value;
        if (this.getShowTitle()) {
            this.titleLabel.setText(String.valueOf(this.base.getDisplayName(cx)) + " - Monthly Min Values");
        }
    }

    public void handleComponentEvent(BComponentEvent event) {
        if (event.getSlotName().endsWith("Peak") || event.getSlotName().endsWith("Timestamp")) {
            this.minTrackerTable.repaint();
        }
    }

    class MinTrackerTableModel
    extends TableModel {
        MinTrackerTableModel() {
        }

        public int getRowCount() {
            return 12;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Month";
                }
                case 1: {
                    return "Timestamp";
                }
                case 2: {
                    return "Value";
                }
            }
            throw new IllegalStateException();
        }

        public Object getValueAt(int row, int col) {
            int i;
            if (col == 0) {
                for (int i2 = 0; i2 < 12; ++i2) {
                    if (row != i2) continue;
                    return monthLex.getText(BMonth.make((int)i2).getTag());
                }
            }
            if (BMinTrackerView.this.base == null) {
                return "";
            }
            if (col == 1 && !BMinTrackerView.this.editor) {
                BAbsTime[] tstamps = BMinTrackerView.this.base.getTimestamps();
                for (i = 0; i < 12; ++i) {
                    if (row != i) continue;
                    return tstamps[i];
                }
            }
            if (col == 2 && !BMinTrackerView.this.editor) {
                BStatusNumeric[] peaks = BMinTrackerView.this.base.getMins();
                BMinTrackerView.this.f = BMinTrackerView.this.base.getFacets();
                for (i = 0; i < 12; ++i) {
                    if (row != i) continue;
                    BMinTrackerView.this.num = peaks[i];
                    return BString.make((String)BDouble.toString((double)BMinTrackerView.this.num.getValue(), (Context)BMinTrackerView.this.f));
                }
            }
            return "";
        }

        public boolean isColumnSortable(int col) {
            return false;
        }

        public void sortByColumn(int col, boolean ascending) {
            if (col == 0) {
                System.out.println("sort by column for col 1 ");
            }
        }
    }
}

