/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.ui;

import com.tridium.nv.NiagaraVirtualUtil;
import com.tridium.workbench.shell.BNiagaraWbApplet;
import com.vykon.vykonPro.ui.BIAppletLinks;
import java.net.URL;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BIHyperlinkShell;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BHyperlinkListFE
extends BWbFieldEditor {
    public static final Action buttonMouseEvent = BHyperlinkListFE.newAction((int)0, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType(BHyperlinkListFE.class);
    public static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BHyperlinkListFE.class);
    private static BModule module = Sys.getModuleForClass(BHyperlinkListFE.class);
    private BListDropDown linkList;
    private BButton linkButton = new BButton((Command)new Hyperlink());
    private BVirtualGateway gw = null;
    private BComponent hll = null;
    private BString[] linkNames = null;
    private BOrd[] linkOrds = null;
    private BBoolean[] linkExt = null;
    double gap = 4.0;

    public void buttonMouseEvent(BMouseEvent event) {
        this.invoke(buttonMouseEvent, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BHyperlinkListFE() {
        this.linkButton.setButtonStyle(BButtonStyle.make((String)lexicon.get("hyperlinkListSelector.buttonStyle")));
        this.linkButton.setText(lexicon.get("hyperlinkListSelector.buttonText"));
        this.linkButton.setImage(BImage.make((String)lexicon.get("hyperlinkListSelector.buttonImage")));
        this.linkButton.setFont(BFont.make((String)lexicon.get("hyperlinkListSelector.buttonFont")));
        this.linkList = new BListDropDown();
        BGridPane grid = new BGridPane(2);
        grid.setStretchColumn(0);
        grid.add("linkList", (BValue)this.linkList);
        grid.add("linkButton", (BValue)this.linkButton);
        this.setContent((BWidget)grid);
        this.linkTo("link1", (BComponent)this.linkButton, (Slot)BButton.mouseEvent, (Slot)buttonMouseEvent);
    }

    protected void doLoadValue(BObject value, Context cx) {
        int i;
        this.hll = (BComponent)value;
        this.hll.lease(1);
        this.linkNames = (BString[])this.hll.getChildren(BString.class);
        this.linkOrds = (BOrd[])this.hll.getChildren(BOrd.class);
        this.linkExt = new BBoolean[this.linkOrds.length];
        for (i = 0; i < this.linkOrds.length; ++i) {
            this.linkExt[i] = this.get("external" + (i + 1)) != null ? (BBoolean)this.hll.get("external" + (i + 1)) : BBoolean.make((boolean)false);
        }
        if (this.hll instanceof BVirtualComponent) {
            BVirtualComponent vcomp = (BVirtualComponent)this.hll;
            this.gw = vcomp.getVirtualGateway();
        }
        this.linkList.getList().removeAllItems();
        for (i = 0; i < this.linkNames.length; ++i) {
            this.linkList.getList().addItem((Object)this.linkNames[i].getString());
        }
        this.linkList.setSelectedIndex(0);
    }

    public void doButtonMouseEvent(BMouseEvent event) {
        BWidgetShell shell;
        if (event.getId() == 504) {
            BWidgetShell shell2 = this.getShell();
            if (shell2 != null) {
                shell2.showStatus(this.toShowStatus());
                this.linkButton.setMouseCursor(MouseCursor.hand);
            }
        } else if (event.getId() == 505 && (shell = this.getShell()) != null) {
            shell.showStatus("");
            this.linkButton.setMouseCursor(MouseCursor.normal);
        }
    }

    public void computePreferredSize() {
        this.linkList.computePreferredSize();
        this.linkButton.computePreferredSize();
        double w = 0.0;
        double fieldWidth = this.linkList.getPreferredWidth();
        double buttonWidth = this.linkButton.getPreferredWidth();
        w = fieldWidth + this.gap + buttonWidth;
        double h = 0.0;
        double viewHeight = Math.max(this.linkList.getPreferredHeight(), this.linkButton.getPreferredHeight());
        h = viewHeight + this.gap;
        this.setPreferredSize(w, h);
    }

    String toShowStatus() {
        if (this.linkOrds == null) {
            return "";
        }
        BOrd hyperlink = this.linkOrds[this.linkList.getSelectedIndex()];
        if (this.gw != null) {
            hyperlink = BOrd.make((BOrd)this.gw.getNavOrd().relativizeToSession(), (OrdQuery)NiagaraVirtualUtil.fromServerOrdToClientVirtual((BOrd)BOrd.make((String)"slot:/"), (BOrd)hyperlink));
        }
        if (hyperlink.isNull()) {
            return "";
        }
        BWidgetShell shell = this.getShell();
        if (shell instanceof BNiagaraWbApplet) {
            return "Link to " + hyperlink;
        }
        if (shell instanceof BIHyperlinkShell) {
            return "Link to " + hyperlink;
        }
        return "Link to ";
    }

    class Hyperlink
    extends Command {
        public Hyperlink() {
            super((BWidget)BHyperlinkListFE.this, module, "hyperlinkListSelector.hyperlink");
        }

        public CommandArtifact doInvoke(CommandEvent cmdEvent) {
            try {
                BWidgetShell shell;
                BOrd ord = BHyperlinkListFE.this.linkOrds[BHyperlinkListFE.this.linkList.getSelectedIndex()];
                boolean external = BHyperlinkListFE.this.linkExt[BHyperlinkListFE.this.linkList.getSelectedIndex()].getBoolean();
                if (BHyperlinkListFE.this.gw != null && !external) {
                    ord = BOrd.make((BOrd)BHyperlinkListFE.this.gw.getNavOrd().relativizeToSession(), (OrdQuery)NiagaraVirtualUtil.fromServerOrdToClientVirtual((BOrd)BOrd.make((String)"slot:/"), (BOrd)ord));
                }
                BInputEvent inputEvent = null;
                if (cmdEvent != null) {
                    inputEvent = cmdEvent.getInputEvent();
                }
                if ((shell = this.getShell()) instanceof BNiagaraWbApplet) {
                    try {
                        BNiagaraWbApplet wbapp = (BNiagaraWbApplet)shell;
                        URL url = wbapp.ordToUrl(ord);
                        BIAppletLinks.hyperlink(wbapp, url);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (shell instanceof BIHyperlinkShell) {
                    if (!external) {
                        ord = BOrd.make((BOrd)((BWbShell)shell).getActiveOrd(), (BOrd)ord).normalize();
                    }
                    ((BIHyperlinkShell)shell).hyperlink(new HyperlinkInfo(ord, inputEvent));
                }
            }
            catch (Exception e) {
                BDialog.error((BWidget)this.getOwner(), (String)"Error", (Object)"Hyperlink Failed.", (Throwable)e);
            }
            return null;
        }

        public String getLabel() {
            return null;
        }
    }
}

