/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.ui;

import com.tridium.kitpx.BPopupProfile;
import com.tridium.ui.UiEnv;
import com.tridium.workbench.shell.BNiagaraWbDialog;
import javax.baja.gx.BPoint;
import javax.baja.gx.BSize;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.BFormat;
import javax.baja.workbench.BWbShell;

public class BEnhancedPopupBinding
extends BBinding {
    public static final Property title = BEnhancedPopupBinding.newProperty((int)0, (String)"Pop up", null);
    public static final Property position = BEnhancedPopupBinding.newProperty((int)0, (BValue)BPoint.make((double)100.0, (double)100.0), null);
    public static final Property size = BEnhancedPopupBinding.newProperty((int)0, (BValue)BSize.make((double)800.0, (double)600.0), null);
    public static final Property modal = BEnhancedPopupBinding.newProperty((int)0, (boolean)false, null);
    public static final Property hyperlink = BEnhancedPopupBinding.newProperty((int)5, (BValue)BOrd.NULL, null);
    public static final Property hyperlinkFormat = BEnhancedPopupBinding.newProperty((int)0, (BValue)BFormat.make((String)"%slotPath%"), null);
    public static final Action mouseEvent = BEnhancedPopupBinding.newAction((int)0, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType(BEnhancedPopupBinding.class);
    private MouseCursor restoreCursor;
    private boolean isOver = false;

    public String getTitle() {
        return this.getString(title);
    }

    public void setTitle(String v) {
        this.setString(title, v, null);
    }

    public BPoint getPosition() {
        return (BPoint)this.get(position);
    }

    public void setPosition(BPoint v) {
        this.set(position, (BValue)v, null);
    }

    public BSize getSize() {
        return (BSize)this.get(size);
    }

    public void setSize(BSize v) {
        this.set(size, (BValue)v, null);
    }

    public boolean getModal() {
        return this.getBoolean(modal);
    }

    public void setModal(boolean v) {
        this.setBoolean(modal, v, null);
    }

    public BOrd getHyperlink() {
        return (BOrd)this.get(hyperlink);
    }

    public void setHyperlink(BOrd v) {
        this.set(hyperlink, (BValue)v, null);
    }

    public BFormat getHyperlinkFormat() {
        return (BFormat)this.get(hyperlinkFormat);
    }

    public void setHyperlinkFormat(BFormat v) {
        this.set(hyperlinkFormat, (BValue)v, null);
    }

    public void mouseEvent(BMouseEvent event) {
        this.invoke(mouseEvent, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        super.started();
        if (this.getWidget() != null) {
            this.linkTo((BComponent)this.getWidget(), (Slot)BWidget.mouseEvent, (Slot)mouseEvent);
        }
    }

    public void resolveHyperlink() {
        BOrd hOrd = BOrd.make((String)this.getHyperlinkFormat().format((Object)this.get()));
        this.setHyperlink(hOrd);
    }

    public void resolveHyperlink(Context cx) {
        BOrd hOrd = BOrd.make((String)this.getHyperlinkFormat().format((Object)this.get(), cx));
        this.setHyperlink(hOrd);
    }

    public void doMouseEvent(BMouseEvent event) {
        if (!this.getWidget().isEnabled()) {
            return;
        }
        switch (event.getId()) {
            case 504: {
                this.entered(event);
                break;
            }
            case 505: {
                this.exited(event);
                break;
            }
            case 502: {
                this.released(event);
            }
        }
    }

    private void entered(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        this.isOver = true;
        if (shell != null && !Sys.isStation()) {
            if (!this.isBound()) {
                return;
            }
            this.resolveHyperlink();
            shell.showStatus(this.toShowStatus());
            this.restoreCursor = !this.getHyperlink().isNull() && UiEnv.get().hasMouse() ? this.getWidget().setMouseCursor(MouseCursor.hand) : null;
        }
    }

    private void exited(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        this.isOver = false;
        if (shell != null && !Sys.isStation()) {
            shell.showStatus("");
        }
        if (this.restoreCursor != null) {
            this.getWidget().setMouseCursor(this.restoreCursor);
        }
    }

    private void released(BMouseEvent event) {
        if (this.isOver && !this.getOrd().isNull() && event.isButton1Down() && !Sys.isStation()) {
            this.popup();
        }
    }

    String toShowStatus() {
        BOrd hyperlink = this.getHyperlink();
        if (hyperlink.isNull()) {
            return "";
        }
        return "Link to " + hyperlink;
    }

    private void popup() {
        try {
            BWbShell shell = BWbShell.getWbShell((BWidget)this.getWidget());
            BOrd o = BOrd.make((BOrd)shell.getActiveOrd(), (BOrd)BOrd.make((String)this.getHyperlinkFormat().format((Object)this.get())).normalize());
            BNiagaraWbDialog dlg = new BNiagaraWbDialog(BPopupProfile.TYPE, (BWidget)shell, o, this.getTitle(), this.getPosition(), this.getSize(), this.getModal());
            dlg.open();
        }
        catch (Exception e) {
            System.out.println("Could not resolve pop up binding ORD...");
            e.printStackTrace();
        }
    }
}

