/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.hx;

import com.tridium.ui.theme.Theme;
import com.vykon.vykonPro.hvac.BZoneInfo;
import com.vykon.vykonPro.hvac.BZoneListExt;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.util.UiLexicon;

public class BHxZoneListView
extends BHxView {
    public static final BHxZoneListView INSTANCE = new BHxZoneListView();
    public static final Type TYPE = Sys.loadType(BHxZoneListView.class);
    public static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BHxZoneListView.class);
    private String borderColor;
    private String rowColor;
    private String headerColor;
    private String altRowColor;

    public Type getType() {
        return TYPE;
    }

    public void write(HxOp op) throws Exception {
        String themeName;
        HtmlWriter out = op.getHtmlWriter();
        op.setDynamic();
        BDynamicEnum theme = (BDynamicEnum)op.getProfileConfig().get("selectedHxTheme");
        String string = themeName = theme == null ? null : theme.getTag();
        if (themeName != null && !themeName.isEmpty()) {
            op.addStyleSheet("module://theme" + themeName + "/ux/theme.css");
        }
        this.borderColor = Theme.table().getGridBrush().encodeToString();
        this.rowColor = Theme.table().getBandBrush().encodeToString();
        this.headerColor = Theme.gridPane().getControlHeader().encodeToString();
        this.altRowColor = lexicon.getText("zonelistView.altRowColor");
        BZoneListExt base = (BZoneListExt)op.get();
        BZoneInfo[] zones = (BZoneInfo[])base.getChildren(BZoneInfo.class);
        BComponent.lease((BComponent[])zones, (int)1);
        out.w((Object)"<div class=\"ZoneListView\" >");
        out.w((Object)("<table height='100%' width='100%' cellspacing='0' cellpadding='5' style='border-collapse: collapse; border: 1px solid " + this.borderColor + ";'>"));
        out.w((Object)("<tr style='background-color: " + this.headerColor + ";'><th style='border: 1px solid " + this.borderColor + ";'>"));
        out.safe((Object)lexicon.getText("zoneListView.zoneId")).w((Object)("</th><th style='border: 1px solid " + this.borderColor + ";'>"));
        out.safe((Object)lexicon.getText("zoneListView.value"));
        out.w((Object)"</th></tr>");
        for (int i = 0; i < zones.length; ++i) {
            if (i % 2 == 0) {
                this.writeZoneRow(op, zones[i], this.rowColor);
                continue;
            }
            this.writeZoneRow(op, zones[i], this.altRowColor);
        }
        out.w((Object)"</table>");
        out.w((Object)"</div>");
    }

    protected void writeZoneRow(HxOp op, BZoneInfo info, String color) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        String rowClass = "hx-table-row";
        out.w((Object)("<tr class=\"" + rowClass + "\" style='background-color: " + color + ";'>"));
        out.w((Object)("<td style='text-align: left; border: 1px solid " + this.borderColor + ";'>"));
        out.safe((Object)info.getZoneId().toString());
        out.w((Object)"</td>");
        out.w((Object)("<td style='text-align: left; border: 1px solid " + this.borderColor + ";'>"));
        out.safe((Object)info.getOut().valueToString((Context)info.getFacets()));
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
    }
}

