/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bql.util;

import java.util.HashMap;
import javax.baja.bql.util.BAbstractExprComponent;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.Tables;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.Registry;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BConversionLink;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.util.BConverter;

@NiagaraType
@NiagaraAction(name="resetConverters", flags=20)
public class BExprComponent
extends BAbstractExprComponent {
    @Generated
    public static final Action resetConverters = BExprComponent.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BExprComponent.class);
    private static final BIcon icon = BIcon.std((String)"control/control.png");
    private final HashMap<String, BConverter> converters = new HashMap();

    @Generated
    public void resetConverters() {
        this.invoke(resetConverters, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    @Override
    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        if (this.isRunning() && (x == 2 && a == expr || x == 3 || x == 4 || x == 5)) {
            this.resetConverters();
        }
        return super.fw(x, a, b, c, d);
    }

    @Override
    protected final void updateOutputs(BITable<?> result, Context cx) throws Exception {
        Column[] cols = result.getColumns().list();
        if (cols.length == 0) {
            throw new Exception("result is empty");
        }
        Object lastError = null;
        BIRandomAccessTable rat = Tables.slurp(result);
        for (int i = 0; i < cols.length; ++i) {
            Column col = cols[i];
            String propName = col.getDisplayName(cx);
            Property prop = this.getProperty(propName);
            if (col.getName().equals(col.getDisplayName(cx))) continue;
            if (prop == null) {
                lastError = new NoSuchSlotException(propName);
                continue;
            }
            BValue val = this.toPropertyValue((BObject)rat.get(0).cell(col).as(BObject.class), prop);
            if (val == null) {
                StringBuilder err = new StringBuilder().append(propName).append(" is type ").append(col.getType()).append(", but property is type ").append(prop.getType());
                lastError = new TypeException(err.toString());
                continue;
            }
            this.set(prop, val, cx);
        }
        if (lastError != null) {
            throw lastError;
        }
    }

    private BValue toPropertyValue(BObject colVal, Property prop) {
        BConverter converter;
        Type propType = prop.getType();
        if (colVal.getType().is(propType)) {
            return colVal.asValue();
        }
        if (!this.converters.containsKey(prop.getName())) {
            Registry registry = Sys.getRegistry();
            TypeInfo[] adapters = registry.getAdapters(colVal.getType().getTypeInfo(), prop.getType().getTypeInfo());
            for (int i = adapters.length - 1; i >= 0; --i) {
                if (!registry.isAgent(adapters[i], BConversionLink.TYPE.getTypeInfo())) continue;
                this.converters.put(prop.getName(), (BConverter)adapters[i].getInstance());
                break;
            }
        }
        if ((converter = this.converters.get(prop.getName())) == null) {
            return null;
        }
        return converter.convert(colVal, prop.getType().getInstance()).asValue();
    }

    public final void doResetConverters() {
        this.converters.clear();
    }
}

