/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.script;

import com.tridium.script.ScriptField;
import com.tridium.util.FormatDenylist;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BBitString;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public class ScriptFields {
    static HashMap<String, Integer> fieldFlags = ScriptFields.initFieldFlags();
    private static final Logger LOGGER = Logger.getLogger("bql");
    protected HashMap<String, ScriptField> scriptFields = new HashMap();

    public ScriptFields(Class<?> cls) {
        this(cls, true);
    }

    public ScriptFields(Class<?> cls, boolean introspect) {
        if (introspect) {
            this.introspect(cls);
        }
    }

    public ScriptField getField(Object target, String name) {
        return this.scriptFields.get(name);
    }

    public final ScriptField[] getFields(Object target) {
        return this.getFields(target, false);
    }

    public ScriptField[] getFields(Object target, boolean operatorOnly) {
        if (!operatorOnly) {
            return this.scriptFields.values().toArray(new ScriptField[0]);
        }
        ArrayList<ScriptField> opFields = new ArrayList<ScriptField>(this.scriptFields.size());
        for (ScriptField field : this.scriptFields.values()) {
            int flags = field.scriptFlags(target);
            if ((flags & 0x100) == 0) continue;
            opFields.add(field);
        }
        return opFields.toArray(new ScriptField[0]);
    }

    protected void addField(ScriptField field) {
        this.scriptFields.put(field.scriptName(), field);
    }

    protected void removeField(ScriptField field) {
        this.scriptFields.remove(field.scriptName());
    }

    private void introspect(Class<?> cls) {
        try {
            Method[] methods;
            Field[] fields;
            for (Field field : fields = cls.getFields()) {
                String moduleName;
                String name = field.getName();
                BModule module = Sys.getModuleForClass(field.getDeclaringClass());
                String string = moduleName = module == null ? null : module.getModuleName();
                if (!ScriptFields.isPublic(field) || ScriptFields.isStatic(field)) continue;
                this.addField(new FieldField(name, field, moduleName));
            }
            for (Method method : methods = cls.getMethods()) {
                String moduleName;
                String name = method.getName();
                BModule module = Sys.getModuleForClass(method.getDeclaringClass());
                String string = moduleName = module == null ? null : module.getModuleName();
                if (!ScriptFields.isPublic(method) || ScriptFields.isStatic(method)) continue;
                Class[] paramTypes = method.getParameterTypes();
                if (FormatDenylist.isDenied(cls, (String)name, (Class[])paramTypes)) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine(cls.getName() + "::" + name + " is included in FormatDenyList and will not be included in Bql script fields.");
                    continue;
                }
                boolean useContext = false;
                if (paramTypes.length > 1) continue;
                if (paramTypes.length == 1) {
                    if (!paramTypes[0].equals(Context.class)) continue;
                    useContext = true;
                }
                if (method.getReturnType() == Void.TYPE) continue;
                if (name.startsWith("get") && name.length() > 3) {
                    name = TextUtil.decapitalize((String)name.substring(3));
                }
                if (this.scriptFields.get(name) != null) continue;
                if (useContext) {
                    this.addField(new ContextBeanField(name, method, null, moduleName));
                    continue;
                }
                this.addField(new BeanField(name, method, null, moduleName));
            }
            if (BBitString.class.isAssignableFrom(cls)) {
                int[] ords;
                BBitString bs = (BBitString)Sys.getType(cls).getInstance();
                for (int ord : ords = bs.getOrdinals()) {
                    this.addField(new BitField(ord, bs));
                }
            }
        }
        catch (Throwable e) {
            System.out.println("ScriptSupport.introspect(" + cls.getName() + ")");
            e.printStackTrace();
        }
    }

    static boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    static HashMap<String, Integer> initFieldFlags() {
        Integer opFlag = 256;
        HashMap<String, Integer> flags = new HashMap<String, Integer>();
        flags.put("class", opFlag);
        flags.put("isNull", opFlag);
        flags.put("toString", opFlag);
        flags.put("type", opFlag);
        flags.put("absoluteOrd", opFlag);
        flags.put("displayName", opFlag);
        flags.put("handle", opFlag);
        flags.put("handleOrd", opFlag);
        flags.put("host", opFlag);
        flags.put("name", opFlag);
        flags.put("navOrd", opFlag);
        flags.put("navParent", opFlag);
        flags.put("ordinal", opFlag);
        flags.put("ordInHost", opFlag);
        flags.put("ordInSession", opFlag);
        flags.put("ordInSpace", opFlag);
        flags.put("parent", opFlag);
        flags.put("slotPath", opFlag);
        flags.put("slotPathOrd", opFlag);
        flags.put("tag", opFlag);
        flags.put("toPathString", opFlag);
        return flags;
    }

    public static class NoBitsField
    implements ScriptField {
        private final String tag;
        private final BBitString empty;

        public NoBitsField(BBitString bitString) {
            this.tag = bitString.getEmptyTag();
            this.empty = bitString.getInstance(new int[0]);
        }

        @Override
        public String scriptName() {
            return this.tag;
        }

        @Override
        public String scriptDisplayName(Object target, Context cx) {
            return this.tag;
        }

        @Override
        public boolean isProperty() {
            return false;
        }

        @Override
        public boolean isReusable() {
            return true;
        }

        @Override
        public Class<?> scriptType() {
            return BBoolean.class;
        }

        @Override
        public Object scriptGet(Object target, Context cx) {
            if (this.empty.equals(target)) {
                return BBoolean.TRUE;
            }
            return BBoolean.FALSE;
        }

        @Override
        public int scriptFlags(Object target) {
            return 256;
        }

        @Override
        public BFacets scriptFacets(Object target) {
            return BFacets.NULL;
        }
    }

    public static class BitField
    implements ScriptField {
        private final BBitString bitString;
        private final int ordinal;
        private final String tag;

        public BitField(int ordinal, BBitString bitString) {
            this.ordinal = ordinal;
            this.bitString = bitString;
            this.tag = bitString.getTag(ordinal);
        }

        @Override
        public String scriptName() {
            return this.tag;
        }

        @Override
        public String scriptDisplayName(Object target, Context cx) {
            return this.bitString.getDisplayTag(this.ordinal, cx);
        }

        @Override
        public boolean isProperty() {
            return false;
        }

        @Override
        public boolean isReusable() {
            return true;
        }

        @Override
        public Class<?> scriptType() {
            return BBoolean.class;
        }

        @Override
        public Object scriptGet(Object target, Context cx) {
            if (((BBitString)target).getBit(this.ordinal)) {
                return BBoolean.TRUE;
            }
            return BBoolean.FALSE;
        }

        @Override
        public int scriptFlags(Object target) {
            return 256;
        }

        @Override
        public BFacets scriptFacets(Object target) {
            return BFacets.NULL;
        }
    }

    static class ContextBeanField
    extends BeanField {
        ContextBeanField(String name, Method getter, Method setter, String moduleName) {
            super(name, getter, setter, moduleName);
        }

        @Override
        public Object scriptGet(Object target, Context cx) throws Exception {
            try {
                Object[] param = new Object[]{cx};
                return this.getter.invoke(target, param);
            }
            catch (InvocationTargetException e) {
                return e.getTargetException().getClass().getName();
            }
        }

        @Override
        public Object scriptSet(Object target, Object value) throws Exception {
            if (this.setter == null) {
                throw new UnsupportedOperationException("Field is readonly");
            }
            this.setter.invoke(target, value);
            return value;
        }
    }

    static class BeanField
    extends IntrospectedField {
        Method getter;
        Method setter;
        int flags;

        BeanField(String name, Method getter, Method setter, String moduleName) {
            super(name, moduleName);
            this.getter = getter;
            this.setter = setter;
            Integer f = fieldFlags.get(name);
            this.flags = f == null ? 0 : f;
        }

        @Override
        public Class<?> scriptType() {
            return this.getter.getReturnType();
        }

        @Override
        public Object scriptGet(Object target, Context cx) throws Exception {
            try {
                return this.getter.invoke(target, new Object[0]);
            }
            catch (InvocationTargetException e) {
                return e.getTargetException().getClass().getName();
            }
        }

        public Object scriptSet(Object target, Object value) throws Exception {
            if (this.setter == null) {
                throw new UnsupportedOperationException("Field is readonly");
            }
            this.setter.invoke(target, value);
            return value;
        }

        @Override
        public int scriptFlags(Object target) {
            return this.flags;
        }
    }

    static class FieldField
    extends IntrospectedField {
        Field field;

        FieldField(String name, Field field, String moduleName) {
            super(name, moduleName);
            this.field = field;
        }

        @Override
        public Class<?> scriptType() {
            return this.field.getType();
        }

        @Override
        public Object scriptGet(Object target, Context cx) throws Exception {
            return this.field.get(target);
        }

        public Object scriptSet(Object target, Object value) throws Exception {
            this.field.set(target, value);
            return value;
        }
    }

    static abstract class IntrospectedField
    implements ScriptField {
        String name;
        String friendly;
        String moduleName;

        IntrospectedField(String name, String moduleName) {
            this.name = name;
            this.moduleName = moduleName;
        }

        @Override
        public boolean isProperty() {
            return false;
        }

        @Override
        public boolean isReusable() {
            return true;
        }

        @Override
        public String scriptName() {
            return this.name;
        }

        @Override
        public String scriptDisplayName(Object target, Context cx) {
            String lang = null;
            if (cx != null) {
                lang = cx.getLanguage();
            }
            if (lang == null) {
                lang = Sys.getLanguage();
            }
            if (this.moduleName == null) {
                return this.friendlyName();
            }
            String n = Lexicon.make((String)this.moduleName, (String)lang).get(this.name);
            if (n != null) {
                return n;
            }
            return this.friendlyName();
        }

        public String friendlyName() {
            if (this.friendly == null) {
                this.friendly = TextUtil.toFriendly((String)this.name);
            }
            return this.friendly;
        }

        @Override
        public int scriptFlags(Object target) {
            Integer flags = fieldFlags.get(this.name);
            if (flags == null) {
                return 0;
            }
            return flags;
        }

        @Override
        public BFacets scriptFacets(Object target) {
            return BFacets.NULL;
        }
    }
}

